/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.services;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.relations.api.DocumentRelationManager;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.exceptions.RelationAlreadyExistsException;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.runtime.api.Framework;

public class DocumentRelationService
implements DocumentRelationManager {
    private static final Log log = LogFactory.getLog(DocumentRelationService.class);
    private RelationManager relationManager = null;

    protected RelationManager getRelationManager() {
        if (this.relationManager == null) {
            this.relationManager = (RelationManager)Framework.getService(RelationManager.class);
        }
        return this.relationManager;
    }

    private static void putStatements(Map<String, Serializable> options, List<Statement> statements) {
        options.put("statements", (Serializable)((Object)statements));
    }

    private static void putStatements(Map<String, Serializable> options, Statement statement) {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        statements.add(statement);
        options.put("statements", statements);
    }

    private QNameResource getNodeFromDocumentModel(DocumentModel model) {
        return (QNameResource)this.getRelationManager().getResource("http://www.nuxeo.org/document/uid/", (Serializable)model, null);
    }

    public void addRelation(CoreSession session, DocumentModel from, DocumentModel to, String predicate, boolean inverse) {
        this.addRelation(session, from, (Node)this.getNodeFromDocumentModel(to), predicate, inverse);
    }

    public void addRelation(CoreSession session, DocumentModel from, Node to, String predicate) {
        this.addRelation(session, from, to, predicate, false);
    }

    public void addRelation(CoreSession session, DocumentModel from, Node to, String predicate, boolean inverse) {
        this.addRelation(session, from, to, predicate, inverse, false);
    }

    public void addRelation(CoreSession session, DocumentModel from, Node to, String predicate, boolean inverse, boolean includeStatementsInEvents) {
        this.addRelation(session, from, to, predicate, inverse, includeStatementsInEvents, null);
    }

    public void addRelation(CoreSession session, DocumentModel from, Node toResource, String predicate, boolean inverse, boolean includeStatementsInEvents, String comment) {
        Graph graph = this.getRelationManager().getGraph("default", session);
        QNameResource fromResource = this.getNodeFromDocumentModel(from);
        ResourceImpl predicateResource = new ResourceImpl(predicate);
        StatementImpl stmt = null;
        List statements = null;
        if (inverse) {
            stmt = new StatementImpl(toResource, (Node)predicateResource, (Node)fromResource);
            statements = graph.getStatements(toResource, (Node)predicateResource, (Node)fromResource);
            if (statements != null && statements.size() > 0) {
                throw new RelationAlreadyExistsException();
            }
        } else {
            stmt = new StatementImpl((Node)fromResource, (Node)predicateResource, toResource);
            statements = graph.getStatements((Node)fromResource, (Node)predicateResource, toResource);
            if (statements != null && statements.size() > 0) {
                throw new RelationAlreadyExistsException();
            }
        }
        if (!StringUtils.isEmpty((String)comment)) {
            stmt.addProperty(RelationConstants.COMMENT, (Node)new LiteralImpl(comment));
        }
        Literal now = RelationDate.getLiteralDate((Date)new Date());
        if (stmt.getProperties(RelationConstants.CREATION_DATE) == null) {
            stmt.addProperty(RelationConstants.CREATION_DATE, (Node)now);
        }
        if (stmt.getProperties(RelationConstants.MODIFICATION_DATE) == null) {
            stmt.addProperty(RelationConstants.MODIFICATION_DATE, (Node)now);
        }
        if (session.getPrincipal() != null && stmt.getProperty(RelationConstants.AUTHOR) == null) {
            stmt.addProperty(RelationConstants.AUTHOR, (Node)new LiteralImpl(session.getPrincipal().getName()));
        }
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        String currentLifeCycleState = from.getCurrentLifeCycleState();
        options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
        if (includeStatementsInEvents) {
            DocumentRelationService.putStatements(options, (Statement)stmt);
        }
        options.put("graph", (Serializable)((Object)"default"));
        this.notifyEvent("beforeRelationCreation", from, options, comment, session);
        graph.add((Statement)stmt);
        if (includeStatementsInEvents) {
            DocumentRelationService.putStatements(options, graph.getStatements((Statement)stmt));
        }
        this.notifyEvent("afterRelationCreation", from, options, comment, session);
    }

    protected void notifyEvent(String eventId, DocumentModel source, Map<String, Serializable> options, String comment, CoreSession session) {
        DocumentEventContext docCtx = new DocumentEventContext(session, session.getPrincipal(), source);
        options.put("category", (Serializable)((Object)"relationNotificationCategory"));
        options.put("comment", (Serializable)((Object)comment));
        EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        evtProducer.fireEvent(docCtx.newEvent(eventId));
    }

    public void deleteRelation(CoreSession session, DocumentModel from, DocumentModel to, String predicate) {
        this.deleteRelation(session, from, to, predicate, false);
    }

    public void deleteRelation(CoreSession session, DocumentModel from, DocumentModel to, String predicate, boolean includeStatementsInEvents) {
        QNameResource fromResource = (QNameResource)this.getRelationManager().getResource("http://www.nuxeo.org/document/uid/", (Serializable)from, null);
        QNameResource toResource = (QNameResource)this.getRelationManager().getResource("http://www.nuxeo.org/document/uid/", (Serializable)to, null);
        ResourceImpl predicateResource = new ResourceImpl(predicate);
        Graph graph = this.getRelationManager().getGraphByName("default");
        List statements = graph.getStatements((Node)fromResource, (Node)predicateResource, (Node)toResource);
        if (statements == null || statements.size() == 0) {
            return;
        }
        for (Statement stmt : statements) {
            this.deleteRelation(session, stmt);
        }
    }

    public void deleteRelation(CoreSession session, Statement stmt) {
        this.deleteRelation(session, stmt, false);
    }

    public void deleteRelation(CoreSession session, Statement stmt, boolean includeStatementsInEvents) {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        DocumentModel eventDocument = null;
        if (stmt.getSubject() instanceof QNameResource) {
            eventDocument = (DocumentModel)this.getRelationManager().getResourceRepresentation("http://www.nuxeo.org/document/uid/", (Resource)((QNameResource)stmt.getSubject()), null);
        } else if (stmt.getObject() instanceof QNameResource) {
            eventDocument = (DocumentModel)this.getRelationManager().getResourceRepresentation("http://www.nuxeo.org/document/uid/", (Resource)((QNameResource)stmt.getObject()), null);
        }
        if (eventDocument != null) {
            String currentLifeCycleState = eventDocument.getCurrentLifeCycleState();
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
            options.put("graph", (Serializable)((Object)"default"));
            if (includeStatementsInEvents) {
                DocumentRelationService.putStatements(options, stmt);
            }
            this.notifyEvent("beforeRelationRemoval", eventDocument, options, null, session);
        }
        this.getRelationManager().getGraphByName("default").remove(stmt);
        if (eventDocument != null) {
            this.notifyEvent("afterRelationRemoval", eventDocument, options, null, session);
        }
    }
}

