/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

public class AuditEntryJSONWriter {
    protected static final Log log = LogFactory.getLog(AuditEntryJSONWriter.class);

    public static void asJSON(JsonGenerator jg, LogEntry logEntry) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("esAuditJson", Version.unknownVersion());
        module.addSerializer(Map.class, (JsonSerializer)new MapEntrySerializer());
        module.addSerializer(AbstractBlob.class, (JsonSerializer)new BinaryBlobEntrySerializer());
        objectMapper.registerModule((Module)module);
        jg.setCodec((ObjectCodec)objectMapper);
        jg.writeStartObject();
        jg.writeStringField("entity-type", "logEntry");
        AuditEntryJSONWriter.writeField(jg, "category", logEntry.getCategory());
        AuditEntryJSONWriter.writeField(jg, "principalName", logEntry.getPrincipalName());
        AuditEntryJSONWriter.writeField(jg, "comment", logEntry.getComment());
        AuditEntryJSONWriter.writeField(jg, "docLifeCycle", logEntry.getDocLifeCycle());
        AuditEntryJSONWriter.writeField(jg, "docPath", logEntry.getDocPath());
        AuditEntryJSONWriter.writeField(jg, "docType", logEntry.getDocType());
        AuditEntryJSONWriter.writeField(jg, "docUUID", logEntry.getDocUUID());
        AuditEntryJSONWriter.writeField(jg, "eventId", logEntry.getEventId());
        AuditEntryJSONWriter.writeField(jg, "repositoryId", logEntry.getRepositoryId());
        jg.writeStringField("eventDate", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)logEntry.getEventDate())));
        jg.writeNumberField("id", logEntry.getId());
        jg.writeStringField("logDate", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)logEntry.getLogDate())));
        Map extended = logEntry.getExtendedInfos();
        jg.writeObjectFieldStart("extended");
        for (String key : extended.keySet()) {
            ExtendedInfo ei = (ExtendedInfo)extended.get(key);
            if (ei != null && ei.getSerializableValue() != null) {
                Serializable value = ei.getSerializableValue();
                if (value instanceof String) {
                    String strValue = (String)((Object)value);
                    if (AuditEntryJSONWriter.isJsonContent(strValue)) {
                        jg.writeFieldName(key);
                        jg.writeRawValue(strValue);
                        continue;
                    }
                    jg.writeStringField(key, strValue);
                    continue;
                }
                try {
                    jg.writeObjectField(key, (Object)ei.getSerializableValue());
                }
                catch (JsonMappingException e) {
                    log.error((Object)"No Serializer found.", (Throwable)e);
                }
                continue;
            }
            jg.writeNullField(key);
        }
        jg.writeEndObject();
        jg.writeEndObject();
        jg.flush();
    }

    protected static boolean isJsonContent(String value) {
        if (value != null) {
            if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
                return true;
            }
            if (value.startsWith("[") && value.endsWith("]")) {
                return true;
            }
        }
        return false;
    }

    protected static void writeField(JsonGenerator jg, String name, String value) throws IOException {
        if (value == null) {
            jg.writeNullField(name);
        } else {
            jg.writeStringField(name, value);
        }
    }

    static class BinaryBlobEntrySerializer
    extends JsonSerializer<AbstractBlob> {
        BinaryBlobEntrySerializer() {
        }

        public void serialize(AbstractBlob blob, JsonGenerator jgen, SerializerProvider provider) throws JsonGenerationException, IOException {
            jgen.writeNull();
        }
    }

    static class MapEntrySerializer
    extends JsonSerializer<Map> {
        MapEntrySerializer() {
        }

        public void serialize(Map map, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            for (Object key : map.keySet()) {
                jgen.writeObjectField((String)key, map.get(key));
            }
            jgen.writeEndObject();
        }
    }
}

