/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class Insert
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Dialect dialect;
    private final Table table;
    private final List<Column> columns;
    private Column idColumn;
    private String insertValues;

    public Insert(Table table) {
        this.table = table;
        this.dialect = table.getDialect();
        this.columns = new LinkedList<Column>();
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void addIdentityColumn(Column idColumn) {
        this.idColumn = idColumn;
    }

    public void setValues(String insertValues) {
        this.insertValues = insertValues;
    }

    public String getStatement() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("INSERT INTO ");
        buf.append(this.table.getQuotedName());
        buf.append(' ');
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<String> values = new LinkedList<String>();
        for (Column column : this.columns) {
            columnNames.add(column.getQuotedName());
            values.add(column.getFreeVariableSetter());
        }
        if (columnNames.isEmpty()) {
            buf.append(this.dialect.getNoColumnsInsertString(this.idColumn));
        } else {
            buf.append('(');
            buf.append(String.join((CharSequence)", ", columnNames));
            buf.append(") ");
            if (this.insertValues == null) {
                buf.append("VALUES (");
                buf.append(String.join((CharSequence)", ", values));
                buf.append(')');
            } else {
                buf.append(this.insertValues);
            }
        }
        return buf.toString();
    }
}

