/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import java.io.PrintWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionFactoryImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionManagerImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionImpl;
import org.nuxeo.runtime.api.Framework;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
RepositoryManagement {
    private static final Log log = LogFactory.getLog(ManagedConnectionFactoryImpl.class);
    private static final long serialVersionUID = 1L;
    protected final String name;
    private transient ResourceAdapter resourceAdapter;
    private transient PrintWriter out;
    private RepositoryImpl repository;
    private static final Pattern KEYVALUE = Pattern.compile("([^=]*)=(.*)");

    public ManagedConnectionFactoryImpl(String name) {
        this.name = name;
        RepositoryDescriptor repositoryDescriptor = ManagedConnectionFactoryImpl.getRepositoryDescriptor(name);
        this.repository = new RepositoryImpl(repositoryDescriptor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        this.resourceAdapter = resourceAdapter;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(new ConnectionManagerImpl());
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        ConnectionFactoryImpl connectionFactory = new ConnectionFactoryImpl(this, connectionManager);
        log.debug((Object)("Created repository factory (" + connectionFactory + ')'));
        return connectionFactory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return new ManagedConnectionImpl(this);
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        for (Object candidate : set) {
            ManagedConnectionImpl managedConnection;
            if (!(candidate instanceof ManagedConnectionImpl) || !this.equals((managedConnection = (ManagedConnectionImpl)candidate).getManagedConnectionFactory())) continue;
            log.debug((Object)("matched: " + managedConnection));
            return managedConnection;
        }
        return null;
    }

    @Override
    public int getActiveSessionsCount() {
        if (this.repository == null) {
            return 0;
        }
        return this.repository.getActiveSessionsCount();
    }

    @Override
    public int clearCaches() {
        if (this.repository == null) {
            return 0;
        }
        return this.repository.clearCaches();
    }

    @Override
    public long getCacheSize() {
        return this.repository.getCacheSize();
    }

    @Override
    public long getCachePristineSize() {
        return this.repository.getCachePristineSize();
    }

    @Override
    public long getCacheSelectionSize() {
        return this.repository.getCacheSelectionSize();
    }

    @Override
    public void processClusterInvalidationsNext() {
        if (this.repository != null) {
            this.repository.processClusterInvalidationsNext();
        }
    }

    @Override
    public void markReferencedBinaries() {
        if (this.repository != null) {
            this.repository.markReferencedBinaries();
        }
    }

    @Override
    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        if (this.repository == null) {
            return 0;
        }
        return this.repository.cleanupDeletedDocuments(max, beforeTime);
    }

    public void shutdown() {
        try {
            this.repository.close();
        }
        finally {
            this.repository = null;
        }
    }

    protected static RepositoryDescriptor getRepositoryDescriptor(String name) {
        SQLRepositoryService sqlRepositoryService = (SQLRepositoryService)((Object)Framework.getService(SQLRepositoryService.class));
        return sqlRepositoryService.getRepositoryDescriptor(name);
    }

    protected SessionImpl getConnection() {
        return this.repository.getConnection();
    }

    public static Map<String, String> parseProperties(String expr) {
        String SPECIAL = "\u1fff";
        HashMap<String, String> props = new HashMap<String, String>();
        for (String kv : expr.replace(";;", SPECIAL).split(";")) {
            if ("".equals(kv = kv.replace(SPECIAL, ";"))) continue;
            Matcher m = KEYVALUE.matcher(kv);
            if (m == null || !m.matches()) {
                log.error((Object)("Invalid property expression: " + kv));
                continue;
            }
            props.put(m.group(1), m.group(2));
        }
        return props;
    }
}

