/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSClusterInvalidator;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSInvalidations;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.ecm.core.storage.dbs.GuavaCacheMetric;
import org.nuxeo.runtime.metrics.MetricsService;

public class DBSCachingRepository
implements DBSRepository {
    private static final Log log = LogFactory.getLog(DBSCachingRepository.class);
    private static final Random RANDOM = new Random();
    private final DBSRepository repository;
    private final Cache<String, State> cache;
    private final Cache<String, String> childCache;
    private DBSClusterInvalidator clusterInvalidator;
    private final DBSInvalidations invalidations;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());

    public DBSCachingRepository(DBSRepository repository, DBSRepositoryDescriptor descriptor) {
        this.repository = repository;
        this.cache = this.newCache(descriptor);
        this.registry.registerAll(GuavaCacheMetric.of(this.cache, "nuxeo", "repositories", repository.getName(), "cache"));
        this.childCache = this.newCache(descriptor);
        this.registry.registerAll(GuavaCacheMetric.of(this.childCache, "nuxeo", "repositories", repository.getName(), "childCache"));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("DBS cache activated on '%s' repository", repository.getName()));
        }
        this.invalidations = new DBSInvalidations();
        if (descriptor.isClusteringEnabled()) {
            this.initClusterInvalidator(descriptor);
        }
    }

    protected <T> Cache<String, T> newCache(DBSRepositoryDescriptor descriptor) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder = builder.expireAfterWrite(descriptor.cacheTTL.longValue(), TimeUnit.MINUTES).recordStats();
        if (descriptor.cacheConcurrencyLevel != null) {
            builder = builder.concurrencyLevel(descriptor.cacheConcurrencyLevel.intValue());
        }
        if (descriptor.cacheMaxSize != null) {
            builder = builder.maximumSize(descriptor.cacheMaxSize.longValue());
        }
        return builder.build();
    }

    protected void initClusterInvalidator(DBSRepositoryDescriptor descriptor) {
        String nodeId = descriptor.clusterNodeId;
        if (StringUtils.isBlank((String)nodeId)) {
            nodeId = String.valueOf(RANDOM.nextInt(Integer.MAX_VALUE));
            log.warn((Object)("Missing cluster node id configuration, please define it explicitly (usually through repository.clustering.id). Using random cluster node id instead: " + nodeId));
        } else {
            nodeId = nodeId.trim();
        }
        this.clusterInvalidator = this.createClusterInvalidator(descriptor);
        this.clusterInvalidator.initialize(nodeId, this.getName());
    }

    protected DBSClusterInvalidator createClusterInvalidator(DBSRepositoryDescriptor descriptor) {
        Class<? extends DBSClusterInvalidator> klass = descriptor.clusterInvalidatorClass;
        if (klass == null) {
            throw new NuxeoException("Unable to get cluster invalidator class from descriptor whereas clustering is enabled");
        }
        try {
            return klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void begin() {
        this.repository.begin();
        this.processReceivedInvalidations();
    }

    @Override
    public void commit() {
        this.repository.commit();
        this.sendInvalidationsToOther();
        this.processReceivedInvalidations();
    }

    @Override
    public void rollback() {
        this.repository.rollback();
    }

    public void shutdown() {
        this.repository.shutdown();
        this.cache.invalidateAll();
        this.childCache.invalidateAll();
        String cacheName = MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.repository.getName(), "cache"});
        String childCacheName = MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.repository.getName(), "childCache"});
        this.registry.removeMatching((name, metric) -> name.startsWith(cacheName) || name.startsWith(childCacheName));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("DBS cache deactivated on '%s' repository", this.repository.getName()));
        }
        if (this.clusterInvalidator != null) {
            this.clusterInvalidator.sendInvalidations(new DBSInvalidations(true));
        }
    }

    @Override
    public State readState(String id) {
        State state = (State)this.cache.getIfPresent((Object)id);
        if (state == null && (state = this.repository.readState(id)) != null) {
            this.putInCache(state);
        }
        return state;
    }

    @Override
    public State readPartialState(String id, Collection<String> keys) {
        return this.repository.readPartialState(id, keys);
    }

    @Override
    public List<State> readStates(List<String> ids) {
        ImmutableMap statesMap = this.cache.getAllPresent(ids);
        ArrayList<String> idsToRetrieve = new ArrayList<String>(ids);
        idsToRetrieve.removeAll((Collection<?>)statesMap.keySet());
        List<State> states = this.repository.readStates(idsToRetrieve);
        states.forEach(this::putInCache);
        states.addAll((Collection<State>)statesMap.values());
        states.sort(Comparator.comparing(state -> state.get((Object)"ecm:id").toString(), Ordering.explicit(ids)));
        return states;
    }

    @Override
    public void createState(State state) {
        this.repository.createState(state);
    }

    @Override
    public void createStates(List<State> states) {
        this.repository.createStates(states);
    }

    @Override
    public void updateState(String id, State.StateDiff diff, DBSTransactionState.ChangeTokenUpdater changeTokenUpdater) {
        this.repository.updateState(id, diff, changeTokenUpdater);
        this.invalidate(id);
    }

    @Override
    public void deleteStates(Set<String> ids) {
        this.repository.deleteStates(ids);
        this.invalidateAll(ids);
    }

    @Override
    public State readChildState(String parentId, String name, Set<String> ignored) {
        State state;
        this.processReceivedInvalidations();
        String childCacheKey = this.computeChildCacheKey(parentId, name);
        String stateId = (String)this.childCache.getIfPresent((Object)childCacheKey);
        if (stateId != null && (state = (State)this.cache.getIfPresent((Object)stateId)) != null) {
            if (parentId.equals(state.get((Object)"ecm:parentId")) && name.equals(state.get((Object)"ecm:name"))) {
                return state;
            }
            this.childCache.invalidate((Object)childCacheKey);
        }
        state = this.repository.readChildState(parentId, name, ignored);
        this.putInCache(state);
        return state;
    }

    private void putInCache(State state) {
        if (state != null) {
            String stateId = state.get((Object)"ecm:id").toString();
            this.cache.put((Object)stateId, (Object)state);
            Serializable stateParentId = state.get((Object)"ecm:parentId");
            if (stateParentId != null) {
                this.childCache.put((Object)this.computeChildCacheKey(stateParentId.toString(), state.get((Object)"ecm:name").toString()), (Object)stateId);
            }
        }
    }

    private String computeChildCacheKey(String parentId, String name) {
        return parentId + '_' + name;
    }

    private void invalidate(String id) {
        this.invalidateAll(Collections.singleton(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAll(Collection<String> ids) {
        this.cache.invalidateAll(ids);
        if (this.clusterInvalidator != null) {
            DBSInvalidations dBSInvalidations = this.invalidations;
            synchronized (dBSInvalidations) {
                this.invalidations.addAll(ids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendInvalidationsToOther() {
        DBSInvalidations dBSInvalidations = this.invalidations;
        synchronized (dBSInvalidations) {
            if (!this.invalidations.isEmpty()) {
                if (this.clusterInvalidator != null) {
                    this.clusterInvalidator.sendInvalidations(this.invalidations);
                }
                this.invalidations.clear();
            }
        }
    }

    protected void processReceivedInvalidations() {
        if (this.clusterInvalidator != null) {
            DBSInvalidations invalidations = this.clusterInvalidator.receiveInvalidations();
            if (invalidations.all) {
                this.cache.invalidateAll();
                this.childCache.invalidateAll();
            } else if (invalidations.ids != null) {
                this.cache.invalidateAll(invalidations.ids);
            }
        }
    }

    @Override
    public BlobManager getBlobManager() {
        return this.repository.getBlobManager();
    }

    @Override
    public FulltextConfiguration getFulltextConfiguration() {
        return this.repository.getFulltextConfiguration();
    }

    @Override
    public boolean isFulltextDisabled() {
        return this.repository.isFulltextDisabled();
    }

    @Override
    public boolean isChangeTokenEnabled() {
        return this.repository.isChangeTokenEnabled();
    }

    @Override
    public String getRootId() {
        return this.repository.getRootId();
    }

    @Override
    public String generateNewId() {
        return this.repository.generateNewId();
    }

    @Override
    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        return this.repository.hasChild(parentId, name, ignored);
    }

    @Override
    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        return this.repository.queryKeyValue(key, value, ignored);
    }

    @Override
    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        return this.repository.queryKeyValue(key1, value1, key2, value2, ignored);
    }

    @Override
    public Stream<State> getDescendants(String id, Set<String> keys) {
        return this.repository.getDescendants(id, keys);
    }

    @Override
    public Stream<State> getDescendants(String id, Set<String> keys, int limit) {
        return this.repository.getDescendants(id, keys, limit);
    }

    @Override
    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        return this.repository.queryKeyValuePresence(key, value, ignored);
    }

    @Override
    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        return this.repository.queryAndFetch(evaluator, orderByClause, distinctDocuments, limit, offset, countUpTo);
    }

    @Override
    public LockManager getLockManager() {
        return this.repository.getLockManager();
    }

    @Override
    public ScrollResult<String> scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveSeconds) {
        return this.repository.scroll(evaluator, batchSize, keepAliveSeconds);
    }

    @Override
    public ScrollResult<String> scroll(String scrollId) {
        return this.repository.scroll(scrollId);
    }

    public Lock getLock(String id) {
        return this.repository.getLock(id);
    }

    public Lock setLock(String id, Lock lock) {
        return this.repository.setLock(id, lock);
    }

    public Lock removeLock(String id, String owner) {
        return this.repository.removeLock(id, owner);
    }

    public void closeLockManager() {
        this.repository.closeLockManager();
    }

    public void clearLockManagerCaches() {
        this.repository.clearLockManagerCaches();
    }

    public String getName() {
        return this.repository.getName();
    }

    public Session getSession() {
        if (this.repository instanceof DBSRepositoryBase) {
            return ((DBSRepositoryBase)this.repository).getSession(this);
        }
        return this.repository.getSession();
    }

    public int getActiveSessionsCount() {
        return this.repository.getActiveSessionsCount();
    }

    public void markReferencedBinaries() {
        this.repository.markReferencedBinaries();
    }
}

