/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;

public class PDFInfo {
    private Blob pdfBlob;
    private int numberOfPages = -1;
    private float mediaBoxWidthInPoints = 0.0f;
    private float mediaBoxHeightInPoints = 0.0f;
    private float cropBoxWidthInPoints = 0.0f;
    private float cropBoxHeightInPoints = 0.0f;
    private long fileSize = -1L;
    private boolean isEncrypted;
    private boolean doXMP = false;
    private boolean alreadyParsed = false;
    private String password;
    private String author = "";
    private String contentCreator = "";
    private String fileName = "";
    private String keywords = "";
    private String pageLayout = "";
    private String pdfVersion = "";
    private String producer = "";
    private String subject = "";
    private String title;
    private String xmp;
    private Calendar creationDate;
    private Calendar modificationDate;
    private AccessPermission permissions;
    private LinkedHashMap<String, String> cachedMap;

    public PDFInfo(Blob inBlob) {
        this(inBlob, null);
    }

    public PDFInfo(Blob inBlob, String inPassword) {
        this.pdfBlob = inBlob;
        this.password = inPassword;
        this.title = "";
    }

    public PDFInfo(DocumentModel inDoc) {
        this(inDoc, null, null);
    }

    public PDFInfo(DocumentModel inDoc, String inXPath, String inPassword) {
        if (inXPath == null || inXPath.isEmpty()) {
            inXPath = "file:content";
        }
        this.pdfBlob = (Blob)inDoc.getPropertyValue(inXPath);
        this.password = inPassword;
        this.title = "";
    }

    public void setParseWithXMP(boolean inValue) {
        if (this.alreadyParsed && this.doXMP != inValue) {
            throw new NuxeoException("Value of 'doXML' cannot be modified after the blob has been already parsed.");
        }
        this.doXMP = inValue;
    }

    private String checkNotNull(String inValue) {
        return inValue == null ? "" : inValue;
    }

    public void run() throws NuxeoException {
        if (this.alreadyParsed) {
            return;
        }
        this.fileName = this.pdfBlob.getFilename();
        File pdfFile = this.pdfBlob.getFile();
        this.fileSize = pdfFile == null ? -1L : pdfFile.length();
        try (PDDocument pdfDoc = PDDocument.load((InputStream)this.pdfBlob.getStream());){
            this.isEncrypted = pdfDoc.isEncrypted();
            if (this.isEncrypted) {
                pdfDoc.openProtection((DecryptionMaterial)new StandardDecryptionMaterial(this.password));
            }
            this.numberOfPages = pdfDoc.getNumberOfPages();
            PDDocumentCatalog docCatalog = pdfDoc.getDocumentCatalog();
            this.pageLayout = this.checkNotNull(docCatalog.getPageLayout());
            this.pdfVersion = String.valueOf(pdfDoc.getDocument().getVersion());
            PDDocumentInformation docInfo = pdfDoc.getDocumentInformation();
            this.author = this.checkNotNull(docInfo.getAuthor());
            this.contentCreator = this.checkNotNull(docInfo.getCreator());
            this.keywords = this.checkNotNull(docInfo.getKeywords());
            try {
                this.creationDate = docInfo.getCreationDate();
            }
            catch (IOException e) {
                this.creationDate = null;
            }
            try {
                this.modificationDate = docInfo.getModificationDate();
            }
            catch (IOException e) {
                this.modificationDate = null;
            }
            this.producer = this.checkNotNull(docInfo.getProducer());
            this.subject = this.checkNotNull(docInfo.getSubject());
            this.title = this.checkNotNull(docInfo.getTitle());
            this.permissions = pdfDoc.getCurrentAccessPermission();
            this.cropBoxHeightInPoints = -1.0f;
            this.cropBoxWidthInPoints = -1.0f;
            this.mediaBoxHeightInPoints = -1.0f;
            this.mediaBoxWidthInPoints = -1.0f;
            List allPages = docCatalog.getAllPages();
            boolean gotMediaBox = false;
            boolean gotCropBox = false;
            for (Object pageObject : allPages) {
                PDPage page = (PDPage)pageObject;
                if (page != null) {
                    PDRectangle r = page.findMediaBox();
                    if (r != null) {
                        this.mediaBoxWidthInPoints = r.getWidth();
                        this.mediaBoxHeightInPoints = r.getHeight();
                        gotMediaBox = true;
                    }
                    if ((r = page.findCropBox()) != null) {
                        this.cropBoxWidthInPoints = r.getWidth();
                        this.cropBoxHeightInPoints = r.getHeight();
                        gotCropBox = true;
                    }
                }
                if (!gotMediaBox || !gotCropBox) continue;
                break;
            }
            if (this.doXMP) {
                this.xmp = null;
                PDMetadata metadata = docCatalog.getMetadata();
                if (metadata != null) {
                    String line;
                    this.xmp = "";
                    InputStream xmlInputStream = metadata.createInputStream();
                    InputStreamReader isr = new InputStreamReader(xmlInputStream);
                    BufferedReader reader = new BufferedReader(isr);
                    do {
                        if ((line = reader.readLine()) == null) continue;
                        this.xmp = this.xmp + line + "\n";
                    } while (line != null);
                    reader.close();
                }
            }
            this.alreadyParsed = true;
        }
        catch (IOException | CryptographyException | BadSecurityHandlerException e) {
            throw new NuxeoException(e);
        }
    }

    public HashMap<String, String> toHashMap() {
        this.run();
        if (this.cachedMap == null) {
            this.cachedMap = new LinkedHashMap();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.cachedMap.put("File name", this.fileName);
            this.cachedMap.put("File size", String.valueOf(this.fileSize));
            this.cachedMap.put("PDF version", this.pdfVersion);
            this.cachedMap.put("Page count", String.valueOf(this.numberOfPages));
            this.cachedMap.put("Page size", String.format(Locale.ENGLISH, "%.1f x %.1f points", Float.valueOf(this.mediaBoxWidthInPoints), Float.valueOf(this.mediaBoxHeightInPoints)));
            this.cachedMap.put("Page width", String.valueOf(this.mediaBoxWidthInPoints));
            this.cachedMap.put("Page height", String.valueOf(this.mediaBoxHeightInPoints));
            this.cachedMap.put("Page layout", this.pageLayout);
            this.cachedMap.put("Title", this.title);
            this.cachedMap.put("Author", this.author);
            this.cachedMap.put("Subject", this.subject);
            this.cachedMap.put("PDF producer", this.producer);
            this.cachedMap.put("Content creator", this.contentCreator);
            if (this.creationDate != null) {
                this.cachedMap.put("Creation date", dateFormat.format(this.creationDate.getTime()));
            } else {
                this.cachedMap.put("Creation date", "");
            }
            if (this.modificationDate != null) {
                this.cachedMap.put("Modification date", dateFormat.format(this.modificationDate.getTime()));
            } else {
                this.cachedMap.put("Modification date", "");
            }
            this.cachedMap.put("Encrypted", String.valueOf(this.isEncrypted));
            this.cachedMap.put("Keywords", this.keywords);
            this.cachedMap.put("Media box width", String.valueOf(this.mediaBoxWidthInPoints));
            this.cachedMap.put("Media box height", String.valueOf(this.mediaBoxHeightInPoints));
            this.cachedMap.put("Crop box width", String.valueOf(this.cropBoxWidthInPoints));
            this.cachedMap.put("Crop box height", String.valueOf(this.cropBoxHeightInPoints));
            if (this.permissions != null) {
                this.cachedMap.put("Can Print", String.valueOf(this.permissions.canPrint()));
                this.cachedMap.put("Can Modify", String.valueOf(this.permissions.canModify()));
                this.cachedMap.put("Can Extract", String.valueOf(this.permissions.canExtractContent()));
                this.cachedMap.put("Can Modify Annotations", String.valueOf(this.permissions.canModifyAnnotations()));
                this.cachedMap.put("Can Fill Forms", String.valueOf(this.permissions.canFillInForm()));
                this.cachedMap.put("Can Extract for Accessibility", String.valueOf(this.permissions.canExtractForAccessibility()));
                this.cachedMap.put("Can Assemble", String.valueOf(this.permissions.canAssembleDocument()));
                this.cachedMap.put("Can Print Degraded", String.valueOf(this.permissions.canPrintDegraded()));
            }
        }
        return this.cachedMap;
    }

    public DocumentModel toFields(DocumentModel inDoc, HashMap<String, String> inMapping, boolean inSave, CoreSession inSession) {
        this.run();
        HashMap<String, String> values = this.toHashMap();
        for (String inXPath : inMapping.keySet()) {
            String value = (String)values.get(inMapping.get(inXPath));
            inDoc.setPropertyValue(inXPath, (Serializable)((Object)value));
        }
        if (inSave) {
            inDoc = inSession.saveDocument(inDoc);
        }
        return inDoc;
    }

    public String toString() {
        return this.toHashMap().toString();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public float getMediaBoxWidthInPoints() {
        return this.mediaBoxWidthInPoints;
    }

    public float getMediaBoxHeightInPoints() {
        return this.mediaBoxHeightInPoints;
    }

    public float getCropBoxWidthInPoints() {
        return this.cropBoxWidthInPoints;
    }

    public float getCropBoxHeightInPoints() {
        return this.cropBoxHeightInPoints;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getContentCreator() {
        return this.contentCreator;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getPageLayout() {
        return this.pageLayout;
    }

    public String getPdfVersion() {
        return this.pdfVersion;
    }

    public String getProducer() {
        return this.producer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTitle() {
        return this.title;
    }

    public String getXmp() {
        return this.xmp;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getModificationDate() {
        return this.modificationDate;
    }

    public AccessPermission getPermissions() {
        return this.permissions;
    }
}

