/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.io.IOException;
import java.io.Serializable;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.pdf.PDFTextExtractor;

@Operation(id="PDF.ExtractText", category="Document", label="PDF: Extract Text", description="Extracts raw text from a PDF. If the PDF is encrypted, a password is required.")
public class PDFExtractTextOperation {
    public static final String ID = "PDF.ExtractText";
    @Context
    protected CoreSession session;
    @Param(name="pdfxpath", required=false)
    protected String pdfxpath = "file:content";
    @Param(name="save", required=false)
    protected boolean save = false;
    @Param(name="targetxpath", required=false)
    protected String targetxpath;
    @Param(name="patterntofind", required=false)
    protected String patterntofind;
    @Param(name="removepatternfromresult", required=false)
    protected boolean removepatternfromresult = false;
    @Param(name="password", required=false)
    protected String password = null;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel input) throws IOException {
        String extractedText;
        PDFTextExtractor textExtractor = new PDFTextExtractor(input, this.pdfxpath);
        textExtractor.setPassword(this.password);
        String string = extractedText = this.removepatternfromresult ? textExtractor.extractLastPartOfLine(this.patterntofind) : textExtractor.extractLineOf(this.patterntofind);
        if (extractedText != null) {
            input.setPropertyValue(this.targetxpath, (Serializable)((Object)extractedText));
        } else {
            DocumentHelper.removeProperty((DocumentModel)input, (String)this.targetxpath);
        }
        if (this.save) {
            input = this.session.saveDocument(input);
        }
        return input;
    }
}

