/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bson.Document;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.FulltextQueryAnalyzer;
import org.nuxeo.ecm.core.storage.QueryOptimizer;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConverter;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepository;
import org.nuxeo.runtime.api.Framework;

public class MongoDBQueryBuilder {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Double ONE = 1.0;
    public static final Double MINUS_ONE = -1.0;
    protected static final String DATE_CAST = "DATE";
    protected final AtomicInteger counter = new AtomicInteger();
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
    protected final MongoDBConverter converter;
    protected final String idKey;
    protected List<String> documentTypes;
    protected final Expression expression;
    protected final SelectClause selectClause;
    protected final OrderByClause orderByClause;
    protected final ExpressionEvaluator.PathResolver pathResolver;
    public boolean hasFulltext;
    public boolean sortOnFulltextScore;
    protected Document query;
    protected Document orderBy;
    protected Document projection;
    protected Map<String, String> propertyKeys;
    boolean projectionHasWildcard;
    private boolean fulltextSearchDisabled;
    protected String elemMatchPrefix;
    protected static final Pattern SLASH_WILDCARD_SLASH = Pattern.compile("/\\*\\d+(/)?");
    protected static final Pattern NON_CANON_INDEX = Pattern.compile("[^/\\[\\]]+\\[(\\d+|\\*|\\*\\d+)\\]");

    public MongoDBQueryBuilder(MongoDBRepository repository, Expression expression, SelectClause selectClause, OrderByClause orderByClause, ExpressionEvaluator.PathResolver pathResolver, boolean fulltextSearchDisabled) {
        this.converter = repository.converter;
        this.idKey = repository.idKey;
        this.expression = expression;
        this.selectClause = selectClause;
        this.orderByClause = orderByClause;
        this.pathResolver = pathResolver;
        this.fulltextSearchDisabled = fulltextSearchDisabled;
        this.propertyKeys = new HashMap<String, String>();
    }

    public void walk() {
        this.query = this.walkExpression(this.expression);
        this.walkOrderBy();
        this.walkProjection();
    }

    public Document getQuery() {
        return this.query;
    }

    public Document getOrderBy() {
        return this.orderBy;
    }

    public Document getProjection() {
        return this.projection;
    }

    public boolean hasProjectionWildcard() {
        return this.projectionHasWildcard;
    }

    protected void walkOrderBy() {
        this.sortOnFulltextScore = false;
        if (this.orderByClause == null) {
            this.orderBy = null;
        } else {
            this.orderBy = new Document();
            for (OrderByExpr ob : this.orderByClause.elements) {
                Double value;
                Reference ref = ob.reference;
                boolean desc = ob.isDescending;
                String field = this.walkReference((Reference)ref).queryField;
                if (this.orderBy.containsKey((Object)field)) continue;
                if ("ecm:fulltextScore".equals(field)) {
                    if (!desc) {
                        throw new QueryParseException("Cannot sort by ecm:fulltextScore ascending");
                    }
                    this.sortOnFulltextScore = true;
                    value = new Document("$meta", (Object)"textScore");
                } else {
                    value = desc ? MINUS_ONE : ONE;
                }
                this.orderBy.put(field, (Object)value);
            }
            if (this.sortOnFulltextScore && this.orderBy.size() > 1) {
                throw new QueryParseException("Cannot sort by ecm:fulltextScore and other criteria");
            }
        }
    }

    protected void walkProjection() {
        this.projection = new Document();
        boolean projectionOnFulltextScore = false;
        for (Operand op : this.selectClause.getSelectList().values()) {
            if (!(op instanceof Reference)) {
                throw new QueryParseException("Projection not supported: " + op);
            }
            FieldInfo fieldInfo = this.walkReference((Reference)op);
            String propertyField = fieldInfo.prop;
            if (!(propertyField.equals("ecm:uuid") || propertyField.equals(fieldInfo.projectionField) || propertyField.contains("/"))) {
                this.propertyKeys.put(fieldInfo.projectionField, propertyField);
            }
            this.projection.put(fieldInfo.projectionField, (Object)ONE);
            if (propertyField.contains("*")) {
                this.projectionHasWildcard = true;
            }
            if (!fieldInfo.projectionField.equals("ecm:fulltextScore")) continue;
            projectionOnFulltextScore = true;
        }
        if (projectionOnFulltextScore || this.sortOnFulltextScore) {
            if (!this.hasFulltext) {
                throw new QueryParseException("ecm:fulltextScore cannot be used without ecm:fulltext");
            }
            this.projection.put("ecm:fulltextScore", (Object)new Document("$meta", (Object)"textScore"));
        }
    }

    public Document walkExpression(Expression expr) {
        String cast;
        Operator op = expr.operator;
        Operand lvalue = expr.lvalue;
        Operand rvalue = expr.rvalue;
        Reference ref = lvalue instanceof Reference ? (Reference)lvalue : null;
        String name = ref != null ? ref.name : null;
        String string = cast = ref != null ? ref.cast : null;
        if (DATE_CAST.equals(cast)) {
            this.checkDateLiteralForCast(op, rvalue, name);
        }
        if (op == Operator.STARTSWITH) {
            return this.walkStartsWith(lvalue, rvalue);
        }
        if ("ecm:path".equals(name)) {
            return this.walkEcmPath(op, rvalue);
        }
        if ("ecm:ancestorId".equals(name)) {
            return this.walkAncestorId(op, rvalue);
        }
        if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
            return this.walkEcmFulltext(name, op, rvalue);
        }
        if (op == Operator.SUM) {
            throw new UnsupportedOperationException("SUM");
        }
        if (op == Operator.SUB) {
            throw new UnsupportedOperationException("SUB");
        }
        if (op == Operator.MUL) {
            throw new UnsupportedOperationException("MUL");
        }
        if (op == Operator.DIV) {
            throw new UnsupportedOperationException("DIV");
        }
        if (op == Operator.LT) {
            return this.walkLt(lvalue, rvalue);
        }
        if (op == Operator.GT) {
            return this.walkGt(lvalue, rvalue);
        }
        if (op == Operator.EQ) {
            return this.walkEq(lvalue, rvalue);
        }
        if (op == Operator.NOTEQ) {
            return this.walkNotEq(lvalue, rvalue);
        }
        if (op == Operator.LTEQ) {
            return this.walkLtEq(lvalue, rvalue);
        }
        if (op == Operator.GTEQ) {
            return this.walkGtEq(lvalue, rvalue);
        }
        if (op == Operator.AND) {
            if (expr instanceof MultiExpression) {
                return this.walkAndMultiExpression((MultiExpression)expr);
            }
            return this.walkAnd(expr);
        }
        if (op == Operator.NOT) {
            return this.walkNot(lvalue);
        }
        if (op == Operator.OR) {
            return this.walkOr(lvalue, rvalue);
        }
        if (op == Operator.LIKE) {
            return this.walkLike(lvalue, rvalue, true, false);
        }
        if (op == Operator.ILIKE) {
            return this.walkLike(lvalue, rvalue, true, true);
        }
        if (op == Operator.NOTLIKE) {
            return this.walkLike(lvalue, rvalue, false, false);
        }
        if (op == Operator.NOTILIKE) {
            return this.walkLike(lvalue, rvalue, false, true);
        }
        if (op == Operator.IN) {
            return this.walkIn(lvalue, rvalue, true);
        }
        if (op == Operator.NOTIN) {
            return this.walkIn(lvalue, rvalue, false);
        }
        if (op == Operator.ISNULL) {
            return this.walkIsNull(lvalue);
        }
        if (op == Operator.ISNOTNULL) {
            return this.walkIsNotNull(lvalue);
        }
        if (op == Operator.BETWEEN) {
            return this.walkBetween(lvalue, rvalue, true);
        }
        if (op == Operator.NOTBETWEEN) {
            return this.walkBetween(lvalue, rvalue, false);
        }
        throw new QueryParseException("Unknown operator: " + op);
    }

    protected void checkDateLiteralForCast(Operator op, Operand value, String name) {
        if (op == Operator.BETWEEN || op == Operator.NOTBETWEEN) {
            LiteralList l = (LiteralList)value;
            this.checkDateLiteralForCast((Operand)l.get(0), name);
            this.checkDateLiteralForCast((Operand)l.get(1), name);
        } else {
            this.checkDateLiteralForCast(value, name);
        }
    }

    protected void checkDateLiteralForCast(Operand value, String name) {
        if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
            throw new QueryParseException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + name);
        }
    }

    protected Document walkEcmPath(Operator op, Operand rvalue) {
        String id;
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:path requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:path requires literal path as right argument");
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((id = this.pathResolver.getIdForPath(path)) == null) {
            return new Document("_id", (Object)"__nosuchid__");
        }
        if (op == Operator.EQ) {
            return new Document(this.idKey, (Object)id);
        }
        return new Document(this.idKey, (Object)new Document("$ne", (Object)id));
    }

    protected Document walkAncestorId(Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:ancestorId requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:ancestorId requires literal id as right argument");
        }
        String ancestorId = ((StringLiteral)rvalue).value;
        if (op == Operator.EQ) {
            return new Document("ecm:ancestorIds", (Object)ancestorId);
        }
        return new Document("ecm:ancestorIds", (Object)new Document("$ne", (Object)ancestorId));
    }

    protected Document walkEcmFulltext(String name, Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.LIKE) {
            throw new QueryParseException("ecm:fulltext requires = or LIKE operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:fulltext requires literal string as right argument");
        }
        if (this.fulltextSearchDisabled) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        String fulltextQuery = ((StringLiteral)rvalue).value;
        if (name.equals("ecm:fulltext")) {
            this.hasFulltext = true;
            String ft = MongoDBQueryBuilder.getMongoDBFulltextQuery(fulltextQuery);
            if (ft == null) {
                return new Document("_id", (Object)"__nosuchid__");
            }
            Document textSearch = new Document();
            textSearch.put("$search", (Object)ft);
            return new Document("$text", (Object)textSearch);
        }
        if (name.charAt("ecm:fulltext".length()) != '.') {
            throw new QueryParseException(name + " has incorrect syntax" + " for a secondary fulltext index");
        }
        String prop = name.substring("ecm:fulltext".length() + 1);
        String ft = fulltextQuery.replace(" ", "%");
        rvalue = new StringLiteral(ft);
        return this.walkLike((Operand)new Reference(prop), rvalue, true, true);
    }

    public static String getMongoDBFulltextQuery(String query) {
        FulltextQueryAnalyzer.FulltextQuery ft = FulltextQueryAnalyzer.analyzeFulltextQuery((String)query);
        if (ft == null) {
            return null;
        }
        return MongoDBQueryBuilder.translateFulltext(ft, false);
    }

    protected static String translateFulltext(FulltextQueryAnalyzer.FulltextQuery ft, boolean and) {
        ArrayList<String> buf = new ArrayList<String>();
        MongoDBQueryBuilder.translateFulltext(ft, buf, and);
        return StringUtils.join(buf, (char)' ');
    }

    protected static void translateFulltext(FulltextQueryAnalyzer.FulltextQuery ft, List<String> buf, boolean and) {
        if (ft.op == FulltextQueryAnalyzer.Op.OR) {
            for (FulltextQueryAnalyzer.FulltextQuery term : ft.terms) {
                MongoDBQueryBuilder.translateFulltext(term, buf, false);
            }
        } else if (ft.op == FulltextQueryAnalyzer.Op.AND) {
            for (FulltextQueryAnalyzer.FulltextQuery term : ft.terms) {
                MongoDBQueryBuilder.translateFulltext(term, buf, true);
            }
        } else {
            String neg = ft.op == FulltextQueryAnalyzer.Op.NOTWORD ? "-" : "";
            String word = ft.word.toLowerCase();
            if (ft.isPhrase() || and) {
                buf.add(neg + '\"' + word + '\"');
            } else {
                buf.add(neg + word);
            }
        }
    }

    public Document walkNot(Operand value) {
        Object val = this.walkOperand(value);
        Object not = this.pushDownNot(val);
        if (!(not instanceof Document)) {
            throw new QueryParseException("Cannot do NOT on: " + val);
        }
        return (Document)not;
    }

    protected Object pushDownNot(Object object) {
        if (!(object instanceof Document)) {
            throw new QueryParseException("Cannot do NOT on: " + object);
        }
        Document ob = (Document)object;
        Set keySet = ob.keySet();
        if (keySet.size() != 1) {
            throw new QueryParseException("Cannot do NOT on: " + ob);
        }
        String key = (String)keySet.iterator().next();
        Object value = ob.get((Object)key);
        if (!key.startsWith("$")) {
            if (value instanceof Document) {
                return new Document(key, this.pushDownNot(value));
            }
            return new Document(key, (Object)new Document("$ne", value));
        }
        if ("$ne".equals(key)) {
            return value;
        }
        if ("$not".equals(key)) {
            return value;
        }
        if ("$and".equals(key) || "$or".equals(key)) {
            String op = "$and".equals(key) ? "$or" : "$and";
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.pushDownNot(list.get(i)));
            }
            return new Document(op, (Object)list);
        }
        if ("$in".equals(key) || "$nin".equals(key)) {
            String op = "$in".equals(key) ? "$nin" : "$in";
            return new Document(op, value);
        }
        if ("$lt".equals(key) || "$gt".equals(key) || "$lte".equals(key) || "$gte".equals(key)) {
            return new Document("$not", (Object)ob);
        }
        throw new QueryParseException("Unknown operator for NOT: " + key);
    }

    protected Document newDocumentWithField(FieldInfo fieldInfo, Object value) {
        return new Document(fieldInfo.queryField, value);
    }

    public Document walkIsNull(Operand value) {
        FieldInfo fieldInfo = this.walkReference(value);
        return this.newDocumentWithField(fieldInfo, null);
    }

    public Document walkIsNotNull(Operand value) {
        FieldInfo fieldInfo = this.walkReference(value);
        return this.newDocumentWithField(fieldInfo, new Document("$ne", null));
    }

    public Document walkAndMultiExpression(MultiExpression expr) {
        return this.walkAnd((Expression)expr, expr.values);
    }

    public Document walkAnd(Expression expr) {
        return this.walkAnd(expr, Arrays.asList(expr.lvalue, expr.rvalue));
    }

    protected Document walkAnd(Expression expr, List<Operand> values) {
        if (values.size() == 1) {
            return (Document)this.walkOperand(values.get(0));
        }
        QueryOptimizer.PrefixInfo info = (QueryOptimizer.PrefixInfo)expr.getInfo();
        if (info == null || info.count < 2) {
            List<Object> list = this.walkOperandList(values);
            return new Document("$and", list);
        }
        String prefix = SLASH_WILDCARD_SLASH.matcher(info.prefix).replaceAll(".");
        String fieldBase = this.stripElemMatchPrefix(prefix.substring(0, prefix.length() - 1));
        String previousElemMatchPrefix = this.elemMatchPrefix;
        this.elemMatchPrefix = prefix;
        List<Object> list = this.walkOperandList(values);
        this.elemMatchPrefix = previousElemMatchPrefix;
        return new Document(fieldBase, (Object)new Document("$elemMatch", (Object)new Document("$and", list)));
    }

    protected String stripElemMatchPrefix(String field) {
        if (this.elemMatchPrefix != null && field.startsWith(this.elemMatchPrefix)) {
            field = field.substring(this.elemMatchPrefix.length());
        }
        return field;
    }

    public Document walkOr(Operand lvalue, Operand rvalue) {
        Object left = this.walkOperand(lvalue);
        Object right = this.walkOperand(rvalue);
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(left, right));
        return new Document("$or", list);
    }

    protected Object checkBoolean(FieldInfo fieldInfo, Object right) {
        if (fieldInfo.isBoolean() && right instanceof Long) {
            if (LONG_ZERO.equals(right)) {
                right = fieldInfo.isTrueOrNullBoolean ? null : Boolean.FALSE;
            } else if (LONG_ONE.equals(right)) {
                right = Boolean.TRUE;
            } else {
                throw new QueryParseException("Invalid boolean: " + right);
            }
        }
        return right;
    }

    public Document walkEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        if (this.isMixinTypes(fieldInfo)) {
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid EQ rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), true);
        }
        right = this.checkBoolean(fieldInfo, right);
        return this.newDocumentWithField(fieldInfo, right);
    }

    public Document walkNotEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        if (this.isMixinTypes(fieldInfo)) {
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid NE rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), false);
        }
        right = this.checkBoolean(fieldInfo, right);
        return this.newDocumentWithField(fieldInfo, new Document("$ne", right));
    }

    public Document walkLt(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$lt", right));
    }

    public Document walkGt(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$gt", right));
    }

    public Document walkLtEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$lte", right));
    }

    public Document walkGtEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$gte", right));
    }

    public Document walkBetween(Operand lvalue, Operand rvalue, boolean positive) {
        LiteralList l = (LiteralList)rvalue;
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object left = this.walkOperand((Operand)l.get(0));
        Object right = this.walkOperand((Operand)l.get(1));
        if (positive) {
            Document range = new Document();
            range.put("$gte", left);
            range.put("$lte", right);
            return this.newDocumentWithField(fieldInfo, range);
        }
        Document a = this.newDocumentWithField(fieldInfo, new Document("$lt", left));
        Document b = this.newDocumentWithField(fieldInfo, new Document("$gt", right));
        return new Document("$or", Arrays.asList(a, b));
    }

    public Document walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        if (!(right instanceof List)) {
            throw new QueryParseException("Invalid IN, right hand side must be a list: " + rvalue);
        }
        if (this.isMixinTypes(fieldInfo)) {
            return this.walkMixinTypes((List)right, positive);
        }
        List list = (List)right;
        return this.newDocumentWithField(fieldInfo, new Document(positive ? "$in" : "$nin", (Object)list));
    }

    public Document walkLike(Operand lvalue, Operand rvalue, boolean positive, boolean caseInsensitive) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid LIKE/ILIKE, right hand side must be a string: " + rvalue);
        }
        String like = this.walkStringLiteral((StringLiteral)rvalue);
        String regex = ExpressionEvaluator.likeToRegex((String)like);
        int flags = caseInsensitive ? 2 : 0;
        Pattern pattern = Pattern.compile(regex, flags);
        Pattern value = positive ? pattern : new Document("$not", (Object)pattern);
        return this.newDocumentWithField(fieldInfo, value);
    }

    public Object walkOperand(Operand op) {
        if (op instanceof Literal) {
            return this.walkLiteral((Literal)op);
        }
        if (op instanceof LiteralList) {
            return this.walkLiteralList((LiteralList)op);
        }
        if (op instanceof Function) {
            return this.walkFunction((Function)op);
        }
        if (op instanceof Expression) {
            return this.walkExpression((Expression)op);
        }
        if (op instanceof Reference) {
            return this.walkReference((Reference)op);
        }
        throw new QueryParseException("Unknown operand: " + op);
    }

    public Object walkLiteral(Literal lit) {
        if (lit instanceof BooleanLiteral) {
            return this.walkBooleanLiteral((BooleanLiteral)lit);
        }
        if (lit instanceof DateLiteral) {
            return this.walkDateLiteral((DateLiteral)lit);
        }
        if (lit instanceof DoubleLiteral) {
            return this.walkDoubleLiteral((DoubleLiteral)lit);
        }
        if (lit instanceof IntegerLiteral) {
            return this.walkIntegerLiteral((IntegerLiteral)lit);
        }
        if (lit instanceof StringLiteral) {
            return this.walkStringLiteral((StringLiteral)lit);
        }
        throw new QueryParseException("Unknown literal: " + lit);
    }

    public Object walkBooleanLiteral(BooleanLiteral lit) {
        return lit.value;
    }

    public Date walkDateLiteral(DateLiteral lit) {
        return lit.value.toDate();
    }

    public Double walkDoubleLiteral(DoubleLiteral lit) {
        return lit.value;
    }

    public Long walkIntegerLiteral(IntegerLiteral lit) {
        return lit.value;
    }

    public String walkStringLiteral(StringLiteral lit) {
        return lit.value;
    }

    public List<Object> walkLiteralList(LiteralList litList) {
        ArrayList<Object> list = new ArrayList<Object>(litList.size());
        for (Literal lit : litList) {
            list.add(this.walkLiteral(lit));
        }
        return list;
    }

    protected List<Object> walkOperandList(List<Operand> values) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Operand value : values) {
            list.add(this.walkOperand(value));
        }
        return list;
    }

    public Object walkFunction(Function func) {
        throw new UnsupportedOperationException(func.name);
    }

    public Document walkStartsWith(Operand lvalue, Operand rvalue) {
        if (!(lvalue instanceof Reference)) {
            throw new QueryParseException("Invalid STARTSWITH query, left hand side must be a property: " + lvalue);
        }
        String name = ((Reference)lvalue).name;
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid STARTSWITH query, right hand side must be a literal path: " + rvalue);
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("ecm:path".equals(name)) {
            return this.walkStartsWithPath(path);
        }
        return this.walkStartsWithNonPath(lvalue, path);
    }

    protected Document walkStartsWithPath(String path) {
        String ancestorId = this.pathResolver.getIdForPath(path);
        if (ancestorId == null) {
            return new Document("_id", (Object)"__nosuchid__");
        }
        return new Document("ecm:ancestorIds", (Object)ancestorId);
    }

    protected Document walkStartsWithNonPath(Operand lvalue, String path) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Document eq = this.newDocumentWithField(fieldInfo, path);
        String regex = path.replaceAll("([^a-zA-Z0-9 /])", "\\\\$1");
        Pattern pattern = Pattern.compile(regex + "/.*");
        Document like = this.newDocumentWithField(fieldInfo, pattern);
        return new Document("$or", Arrays.asList(eq, like));
    }

    protected FieldInfo walkReference(Operand value) {
        if (!(value instanceof Reference)) {
            throw new QueryParseException("Invalid query, left hand side must be a property: " + value);
        }
        return this.walkReference((Reference)value);
    }

    public static String canonicalXPath(String xpath) {
        while (xpath.length() > 0 && xpath.charAt(0) == '/') {
            xpath = xpath.substring(1);
        }
        if (xpath.indexOf(91) == -1) {
            return xpath;
        }
        return NON_CANON_INDEX.matcher(xpath).replaceAll("$1");
    }

    public FieldInfo walkReference(Reference ref) {
        Type type;
        FieldInfo fieldInfo = this.walkReference(ref.name);
        if (!(!DATE_CAST.equals(ref.cast) || (type = fieldInfo.type) instanceof DateType || type instanceof ListType && ((ListType)type).getFieldType() instanceof DateType)) {
            throw new QueryParseException("Cannot cast to " + ref.cast + ": " + ref.name);
        }
        return fieldInfo;
    }

    protected FieldInfo walkReference(String name) {
        String prop = MongoDBQueryBuilder.canonicalXPath(name);
        String[] parts = prop.split("/");
        if (prop.startsWith("ecm:")) {
            if (prop.startsWith("ecm:acl/")) {
                return this.parseACP(prop, parts);
            }
            if (prop.startsWith("ecm:tag")) {
                String queryField = "nxtag:tags.label";
                queryField = this.stripElemMatchPrefix(queryField);
                return new FieldInfo(prop, queryField, queryField, (Type)StringType.INSTANCE, true);
            }
            String field = DBSSession.convToInternal((String)prop);
            Type type = DBSSession.getType((String)field);
            String queryField = this.converter.keyToBson(field);
            queryField = this.stripElemMatchPrefix(queryField);
            return new FieldInfo(prop, queryField, field, type, true);
        }
        String first = parts[0];
        Field field = this.schemaManager.getField(first);
        if (field == null) {
            if (first.indexOf(58) > -1) {
                throw new QueryParseException("No such property: " + name);
            }
            for (Schema schema : this.schemaManager.getSchemas()) {
                if (StringUtils.isBlank((String)schema.getNamespace().prefix) && schema != null && (field = schema.getField(first)) != null) break;
            }
            if (field == null) {
                throw new QueryParseException("No such property: " + name);
            }
        }
        Type type = field.getType();
        if ("uid:major_version".equals(prop) || "uid:minor_version".equals(prop) || "major_version".equals(prop) || "minor_version".equals(prop)) {
            String fieldName = DBSSession.convToInternal((String)prop);
            return new FieldInfo(prop, fieldName, fieldName, type, true);
        }
        parts[0] = field.getName().getPrefixedName();
        LinkedList<String> queryFieldParts = new LinkedList<String>();
        LinkedList<String> projectionFieldParts = new LinkedList<String>();
        boolean firstPart = true;
        for (String part : parts) {
            if (NumberUtils.isDigits((String)part)) {
                queryFieldParts.add(part);
                type = ((ListType)type).getFieldType();
            } else if (!part.startsWith("*")) {
                queryFieldParts.add(part);
                projectionFieldParts.add(part);
                if (!firstPart) {
                    field = ((ComplexType)type).getField(part);
                    if (field == null) {
                        throw new QueryParseException("No such property: " + name);
                    }
                    type = field.getType();
                }
            } else {
                type = ((ListType)type).getFieldType();
            }
            firstPart = false;
        }
        String queryField = StringUtils.join(queryFieldParts, (char)'.');
        String projectionField = StringUtils.join(projectionFieldParts, (char)'.');
        queryField = this.stripElemMatchPrefix(queryField);
        return new FieldInfo(prop, queryField, projectionField, type, false);
    }

    protected FieldInfo parseACP(String prop, String[] parts) {
        String queryField;
        if (parts.length != 3) {
            throw new QueryParseException("No such property: " + prop);
        }
        String wildcard = parts[1];
        if (NumberUtils.isDigits((String)wildcard)) {
            throw new QueryParseException("Cannot use explicit index in ACLs: " + prop);
        }
        String last = parts[2];
        if ("name".equals(last)) {
            queryField = "ecm:acp.name";
        } else {
            String fieldLast = DBSSession.convToInternalAce((String)last);
            if (fieldLast == null) {
                throw new QueryParseException("No such property: " + prop);
            }
            queryField = "ecm:acp.acl." + fieldLast;
        }
        Type type = DBSSession.getType((String)last);
        queryField = this.stripElemMatchPrefix(queryField);
        return new FieldInfo(prop, queryField, queryField, type, false);
    }

    protected boolean isMixinTypes(FieldInfo fieldInfo) {
        return fieldInfo.queryField.equals("ecm:mixinTypes");
    }

    protected Set<String> getMixinDocumentTypes(String mixin) {
        Set types = this.schemaManager.getDocumentTypeNamesForFacet(mixin);
        return types == null ? Collections.emptySet() : types;
    }

    protected List<String> getDocumentTypes() {
        if (this.documentTypes == null) {
            this.documentTypes = new ArrayList<String>();
            for (DocumentType docType : this.schemaManager.getDocumentTypes()) {
                this.documentTypes.add(docType.getName());
            }
        }
        return this.documentTypes;
    }

    protected boolean isNeverPerInstanceMixin(String mixin) {
        return this.schemaManager.getNoPerDocumentQueryFacets().contains(mixin);
    }

    public Document walkMixinTypes(List<String> mixins, boolean include) {
        HashSet<Object> matchPrimaryTypes;
        if (include) {
            matchPrimaryTypes = new HashSet();
            for (String string : mixins) {
                matchPrimaryTypes.addAll(this.getMixinDocumentTypes(string));
            }
        } else {
            matchPrimaryTypes = new HashSet<String>(this.getDocumentTypes());
            for (String string : mixins) {
                matchPrimaryTypes.removeAll(this.getMixinDocumentTypes(string));
            }
        }
        HashSet<String> matchMixinTypes = new HashSet<String>();
        for (String mixin : mixins) {
            if (this.isNeverPerInstanceMixin(mixin)) continue;
            matchMixinTypes.add(mixin);
        }
        Document document = new Document("ecm:primaryType", (Object)new Document("$in", matchPrimaryTypes));
        String innin = include ? "$in" : "$nin";
        Document m = new Document("ecm:mixinTypes", (Object)new Document(innin, matchMixinTypes));
        String op = include ? "$or" : "$and";
        return new Document(op, Arrays.asList(document, m));
    }

    protected static class FieldInfo {
        protected final String prop;
        protected final String queryField;
        protected final String projectionField;
        protected final Type type;
        protected final boolean isTrueOrNullBoolean;

        protected FieldInfo(String prop, String queryField, String projectionField, Type type, boolean isTrueOrNullBoolean) {
            this.prop = prop;
            this.queryField = queryField;
            this.projectionField = projectionField;
            this.type = type;
            this.isTrueOrNullBoolean = isTrueOrNullBoolean;
        }

        protected boolean isBoolean() {
            return this.type instanceof BooleanType;
        }
    }
}

