/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryService;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;

public class MongoDBRepositoryService
extends DefaultComponent {
    public static final String DB_DEFAULT = "nuxeo";
    private static final String XP_REPOSITORY = "repository";

    public void registerContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.addContribution((MongoDBRepositoryDescriptor)((Object)contrib));
        this.handleConnectionContribution((MongoDBRepositoryDescriptor)((Object)contrib), (c, d) -> c.registerContribution(d, "connection", contributor));
    }

    public void unregisterContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.removeContribution((MongoDBRepositoryDescriptor)((Object)contrib));
        this.handleConnectionContribution((MongoDBRepositoryDescriptor)((Object)contrib), (c, d) -> c.unregisterContribution(d, "connection", contributor));
    }

    protected void addContribution(MongoDBRepositoryDescriptor descriptor) {
        ((DBSRepositoryService)Framework.getService(DBSRepositoryService.class)).addContribution((DBSRepositoryDescriptor)descriptor, MongoDBRepositoryFactory.class);
    }

    protected void removeContribution(MongoDBRepositoryDescriptor descriptor) {
        ((DBSRepositoryService)Framework.getService(DBSRepositoryService.class)).removeContribution((DBSRepositoryDescriptor)descriptor, MongoDBRepositoryFactory.class);
    }

    @Deprecated
    protected void handleConnectionContribution(MongoDBRepositoryDescriptor descriptor, BiConsumer<DefaultComponent, MongoDBConnectionConfig> consumer) {
        if (StringUtils.isNotBlank((String)descriptor.server)) {
            String id = "repository/" + descriptor.name;
            String server = descriptor.server;
            String dbName = StringUtils.defaultIfBlank((String)descriptor.dbname, (String)DB_DEFAULT);
            MongoDBConnectionConfig connection = new MongoDBConnectionConfig(id, server, dbName);
            DefaultComponent component = (DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.runtime.mongodb.MongoDBComponent");
            consumer.accept(component, connection);
        }
    }
}

