/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodWriterInterceptor;
import net.openhft.chronicle.wire.MethodWriterInvocationHandler;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMethodWriterInvocationHandler
extends AbstractInvocationHandler
implements MethodWriterInvocationHandler {
    private final Map<Method, ParameterHolderSequenceWriter> parameterMap = new ConcurrentHashMap<Method, ParameterHolderSequenceWriter>();
    protected boolean recordHistory;
    protected String genericEvent = "";
    private MethodWriterInterceptor methodWriterInterceptor;
    private BiConsumer<Method, Object[]> handleInvoke = this::handleInvoke;

    public AbstractMethodWriterInvocationHandler() {
        super(HashMap::new);
    }

    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (this.methodWriterInterceptor != null) {
            this.methodWriterInterceptor.intercept(method, args, this.handleInvoke);
        } else {
            this.handleInvoke(method, args);
        }
        return ObjectUtils.defaultValue(method.getReturnType());
    }

    @Override
    public void genericEvent(String genericEvent) {
        this.genericEvent = genericEvent;
    }

    protected abstract void handleInvoke(Method var1, Object[] var2);

    protected void handleInvoke(@NotNull Method method, Object[] args, Wire wire) {
        String methodName;
        if (this.recordHistory) {
            wire.write("history").marshallable(MessageHistory.get());
        }
        if ((methodName = method.getName()).equals(this.genericEvent)) {
            this.writeGenericEvent(wire, method, args);
            return;
        }
        this.writeEvent(wire, method, methodName, args);
    }

    private void writeEvent(Wire wire, @NotNull Method method, String methodName, Object[] args) {
        ValueOut valueOut = wire.writeEventName(methodName);
        ParameterHolderSequenceWriter phsw = this.parameterMap.computeIfAbsent(method, x$0 -> new ParameterHolderSequenceWriter((Method)x$0));
        switch (args.length) {
            case 0: {
                valueOut.text("");
                break;
            }
            case 1: {
                valueOut.object(phsw.parameterTypes[0], args[0]);
                break;
            }
            default: {
                valueOut.sequence(args, phsw.from0);
            }
        }
    }

    private void writeGenericEvent(Wire wire, @NotNull Method method, Object[] args) {
        ValueOut valueOut = wire.writeEventName(args[0].toString());
        ParameterHolderSequenceWriter phsw = this.parameterMap.computeIfAbsent(method, x$0 -> new ParameterHolderSequenceWriter((Method)x$0));
        switch (args.length) {
            case 1: {
                valueOut.text("");
                break;
            }
            case 2: {
                valueOut.object(phsw.parameterTypes[1], args[1]);
                break;
            }
            default: {
                valueOut.sequence(args, phsw.from1);
            }
        }
    }

    @Override
    public void recordHistory(boolean recordHistory) {
        this.recordHistory = recordHistory;
    }

    @Override
    public void methodWriterInterceptor(MethodWriterInterceptor methodWriterInterceptor) {
        this.methodWriterInterceptor = methodWriterInterceptor;
    }

    private static class ParameterHolderSequenceWriter {
        final Class[] parameterTypes;
        final BiConsumer<Object[], ValueOut> from0;
        final BiConsumer<Object[], ValueOut> from1;

        private ParameterHolderSequenceWriter(Method method) {
            this.parameterTypes = method.getParameterTypes();
            this.from0 = (a, v) -> {
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    v.object(this.parameterTypes[i], a[i]);
                }
            };
            this.from1 = (a, v) -> {
                for (int i = 1; i < this.parameterTypes.length; ++i) {
                    v.object(this.parameterTypes[i], a[i]);
                }
            };
        }
    }
}

