/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.client.MongoCollection;
import java.util.Arrays;
import java.util.HashMap;
import org.bson.Document;
import org.nuxeo.directory.mongodb.MongoDBDirectoryDescriptor;
import org.nuxeo.directory.mongodb.MongoDBReference;
import org.nuxeo.directory.mongodb.MongoDBReferenceDescriptor;
import org.nuxeo.directory.mongodb.MongoDBSerializationHelper;
import org.nuxeo.directory.mongodb.MongoDBSession;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryCSVLoader;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.runtime.api.Framework;

public class MongoDBDirectory
extends AbstractDirectory {
    protected String countersCollectionName;
    protected volatile boolean initialized;

    public MongoDBDirectory(MongoDBDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor, MongoDBReference.class);
        this.addMongoDBReferences(descriptor.getMongoDBReferences());
        this.fallbackOnDefaultCache();
        this.countersCollectionName = this.getName() + ".counters";
    }

    public MongoDBDirectoryDescriptor getDescriptor() {
        return (MongoDBDirectoryDescriptor)this.descriptor;
    }

    public Session getSession() throws DirectoryException {
        MongoDBSession session = new MongoDBSession(this);
        this.addSession((Session)session);
        this.initializeIfNeeded(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeIfNeeded(MongoDBSession session) {
        if (!this.initialized) {
            MongoDBDirectory mongoDBDirectory = this;
            synchronized (mongoDBDirectory) {
                if (!this.initialized) {
                    this.initialize(session);
                    this.initialized = true;
                }
            }
        }
    }

    protected void initialize(MongoDBSession session) {
        this.initSchemaFieldMap();
        if (this.descriptor.isAutoincrementIdField() && !session.hasCollection(this.countersCollectionName)) {
            HashMap<String, Object> seq = new HashMap<String, Object>();
            seq.put("_id", this.getName());
            seq.put("seq", 0L);
            session.getCollection(this.countersCollectionName).insertOne((Object)MongoDBSerializationHelper.fieldMapToBson(seq));
        }
        String policy = this.descriptor.getCreateTablePolicy();
        MongoCollection<Document> collection = session.getCollection(this.getName());
        boolean dropCollection = false;
        boolean loadData = false;
        switch (policy) {
            case "always": {
                dropCollection = true;
                loadData = true;
                break;
            }
            case "on_missing_columns": {
                if (session.hasCollection(this.getName())) break;
                loadData = true;
            }
        }
        if (dropCollection) {
            collection.drop();
        }
        if (loadData) {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            Schema schema = schemaManager.getSchema(this.getSchema());
            this.loadData(schema, (Session)session);
        }
    }

    protected void loadData(Schema schema, Session session) {
        if (this.descriptor.getDataFileName() != null) {
            Framework.doPrivileged(() -> DirectoryCSVLoader.loadData((String)this.descriptor.getDataFileName(), (char)this.descriptor.getDataFileCharacterSeparator(), (Schema)schema, arg_0 -> ((Session)session).createEntry(arg_0)));
        }
    }

    protected void addMongoDBReferences(MongoDBReferenceDescriptor[] mongodbReferences) {
        if (mongodbReferences != null) {
            Arrays.stream(mongodbReferences).map(MongoDBReference::new).forEach(arg_0 -> ((MongoDBDirectory)this).addReference(arg_0));
        }
    }

    public String getCountersCollectionName() {
        return this.countersCollectionName;
    }

    public void shutdown() {
        super.shutdown();
    }
}

