/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.directory.mongodb.MongoDBReferenceDescriptor;
import org.nuxeo.directory.mongodb.MongoDBSerializationHelper;
import org.nuxeo.directory.mongodb.MongoDBSession;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.DirectoryCSVLoader;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.ReferenceDescriptor;
import org.nuxeo.ecm.directory.Session;

public class MongoDBReference
extends AbstractReference {
    protected String collection;
    protected String sourceField;
    protected String targetField;
    protected String dataFileName;
    private boolean initialized;

    public MongoDBReference(String field, String directory, String collection, String sourceField, String targetField, String dataFileName) {
        super(field, directory);
        this.collection = collection;
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.dataFileName = dataFileName;
    }

    public MongoDBReference(MongoDBReferenceDescriptor descriptor) {
        this(descriptor.getFieldName(), descriptor.getTargetDirectoryName(), descriptor.getCollection(), descriptor.getSourceField(), descriptor.getTargetField(), descriptor.getDataFileName());
    }

    public MongoDBReference(ReferenceDescriptor descriptor) {
        this(descriptor.getFieldName(), descriptor.getDirectory(), descriptor.getReferenceName(), descriptor.getSource(), descriptor.getTarget(), descriptor.getDataFileName());
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.addLinks(sourceId, targetIds, (Session)session);
        }
    }

    public void addLinks(String sourceId, List<String> targetIds, Session session) throws DirectoryException {
        MongoDBSession mongoSession = (MongoDBSession)session;
        if (!this.initialized) {
            if (this.dataFileName != null) {
                this.initializeSession(mongoSession);
            }
            this.initialized = true;
        }
        if (targetIds == null || targetIds.isEmpty()) {
            return;
        }
        try {
            MongoCollection<Document> coll = mongoSession.getCollection(this.collection);
            List newDocs = targetIds.stream().map(targetId -> this.buildDoc(sourceId, (String)targetId)).filter(doc -> coll.count((Bson)doc) == 0L).collect(Collectors.toList());
            if (!newDocs.isEmpty()) {
                coll.insertMany(newDocs);
            }
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId, Session session) throws DirectoryException {
        MongoDBSession mongodbSession = (MongoDBSession)session;
        MongoCollection<Document> coll = mongodbSession.getCollection(this.collection);
        List newDocs = sourceIds.stream().map(sourceId -> this.buildDoc((String)sourceId, targetId)).filter(doc -> coll.count((Bson)doc) == 0L).collect(Collectors.toList());
        if (!newDocs.isEmpty()) {
            coll.insertMany(newDocs);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        if (sourceIds == null || sourceIds.isEmpty()) {
            return;
        }
        try (MongoDBSession session = this.getMongoDBSession();){
            this.addLinks(sourceIds, targetId, (Session)session);
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.removeLinksForSource(sourceId, (Session)session);
        }
    }

    public void removeLinksForSource(String sourceId, Session session) {
        this.removeLinksFor(this.sourceField, sourceId, (MongoDBSession)session);
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.removeLinksFor(this.targetField, targetId, session);
        }
    }

    public void removeLinksForTarget(String targetId, Session session) throws DirectoryException {
        this.removeLinksFor(this.targetField, targetId, (MongoDBSession)session);
    }

    private void removeLinksFor(String field, String value, MongoDBSession session) {
        try {
            DeleteResult result = session.getCollection(this.collection).deleteMany((Bson)MongoDBSerializationHelper.fieldMapToBson(field, value));
            if (!result.wasAcknowledged()) {
                throw new DirectoryException("Error while deleting the entry, the request has not been acknowledged by the server");
            }
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            List<String> list = this.getIdsFor(this.sourceField, sourceId, this.targetField, session);
            return list;
        }
    }

    public List<String> getTargetIdsForSource(String sourceId, MongoDBSession session) throws DirectoryException {
        return this.getIdsFor(this.sourceField, sourceId, this.targetField, session);
    }

    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            List<String> list = this.getIdsFor(this.targetField, targetId, this.sourceField, session);
            return list;
        }
    }

    private List<String> getIdsFor(String queryField, String value, String resultField, MongoDBSession session) {
        FindIterable docs = session.getCollection(this.collection).find((Bson)MongoDBSerializationHelper.fieldMapToBson(queryField, value));
        return StreamSupport.stream(docs.spliterator(), false).map(doc -> doc.getString((Object)resultField)).collect(Collectors.toList());
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.setTargetIdsForSource(sourceId, targetIds, (Session)session);
        }
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, Session session) throws DirectoryException {
        this.setIdsFor(this.sourceField, sourceId, this.targetField, targetIds, (MongoDBSession)session);
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.setIdsFor(this.targetField, targetId, this.sourceField, sourceIds, session);
        }
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds, Session session) throws DirectoryException {
        this.setIdsFor(this.targetField, targetId, this.sourceField, sourceIds, (MongoDBSession)session);
    }

    private void setIdsFor(String field, String value, String fieldToUpdate, List<String> ids, MongoDBSession session) {
        Object list;
        HashSet<String> idsToAdd = new HashSet<String>();
        if (ids != null) {
            idsToAdd.addAll(ids);
        }
        ArrayList<String> idsToDelete = new ArrayList<String>();
        List<String> existingIds = this.getIdsFor(field, value, fieldToUpdate, session);
        for (String id2 : existingIds) {
            if (idsToAdd.remove(id2)) continue;
            idsToDelete.add(id2);
        }
        if (!idsToDelete.isEmpty()) {
            list = new BasicDBList();
            if (this.sourceField.equals(field)) {
                list.addAll((Collection)idsToDelete.stream().map(id -> this.buildDoc(value, (String)id)).collect(Collectors.toList()));
            } else {
                list.addAll((Collection)idsToDelete.stream().map(id -> this.buildDoc((String)id, value)).collect(Collectors.toList()));
            }
            BasicDBObject deleteDoc = new BasicDBObject("$or", list);
            session.getCollection(this.collection).deleteMany((Bson)deleteDoc);
        }
        if (!idsToAdd.isEmpty()) {
            list = this.sourceField.equals(field) ? idsToAdd.stream().map(id -> this.buildDoc(value, (String)id)).collect(Collectors.toList()) : idsToAdd.stream().map(id -> this.buildDoc((String)id, value)).collect(Collectors.toList());
            session.getCollection(this.collection).insertMany((List)list);
        }
    }

    private Document buildDoc(String sourceId, String targetId) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put(this.sourceField, sourceId);
        fieldMap.put(this.targetField, targetId);
        return MongoDBSerializationHelper.fieldMapToBson(fieldMap);
    }

    protected void initializeSession(MongoDBSession session) {
        SchemaImpl schema = new SchemaImpl(this.collection, null);
        schema.addField(this.sourceField, (Type)StringType.INSTANCE, null, 0, Collections.emptySet());
        schema.addField(this.targetField, (Type)StringType.INSTANCE, null, 0, Collections.emptySet());
        Consumer<Map> loader = map -> {
            Document doc = MongoDBSerializationHelper.fieldMapToBson(map);
            MongoCollection<Document> coll = session.getCollection(this.collection);
            if (coll.count((Bson)doc) == 0L) {
                coll.insertOne((Object)doc);
            }
        };
        DirectoryCSVLoader.loadData((String)this.dataFileName, (char)',', (Schema)schema, loader);
    }

    protected MongoDBSession getMongoDBSession() throws DirectoryException {
        if (!this.initialized) {
            if (this.dataFileName != null) {
                try (MongoDBSession session = (MongoDBSession)this.getSourceDirectory().getSession();){
                    this.initializeSession(session);
                }
            }
            this.initialized = true;
        }
        return (MongoDBSession)this.getSourceDirectory().getSession();
    }
}

