/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class StreamAuditWriter
implements StreamProcessorTopology {
    private static final Log log = LogFactory.getLog(StreamAuditWriter.class);
    public static final String COMPUTATION_NAME = "AuditLogWriter";
    public static final String BATCH_SIZE_OPT = "batchSize";
    public static final String BATCH_THRESHOLD_MS_OPT = "batchThresholdMs";
    public static final int DEFAULT_BATCH_SIZE = 10;
    public static final int DEFAULT_BATCH_THRESHOLD_MS = 200;

    public Topology getTopology(Map<String, String> options) {
        int batchSize = this.getOptionAsInteger(options, BATCH_SIZE_OPT, 10);
        int batchThresholdMs = this.getOptionAsInteger(options, BATCH_THRESHOLD_MS_OPT, 200);
        return Topology.builder().addComputation(() -> new AuditLogWriterComputation(COMPUTATION_NAME, batchSize, batchThresholdMs), Collections.singletonList("i1:audit")).build();
    }

    protected int getOptionAsInteger(Map<String, String> options, String option, int defaultValue) {
        String value = options.get(option);
        return value == null ? defaultValue : Integer.valueOf(value);
    }

    public static class AuditLogWriterComputation
    extends AbstractComputation {
        protected final int batchSize;
        protected final int batchThresholdMs;
        protected final List<LogEntry> logEntries;

        public AuditLogWriterComputation(String name, int batchSize, int batchThresholdMs) {
            super(name, 1, 0);
            this.batchSize = batchSize;
            this.batchThresholdMs = batchThresholdMs;
            this.logEntries = new ArrayList<LogEntry>(batchSize);
        }

        public void init(ComputationContext context) {
            log.debug((Object)String.format("Starting computation: %s reading on: %s, batch size: %d, threshold: %dms", StreamAuditWriter.COMPUTATION_NAME, "audit", this.batchSize, this.batchThresholdMs));
            context.setTimer("batch", System.currentTimeMillis() + (long)this.batchThresholdMs);
        }

        public void processTimer(ComputationContext context, String key, long timestamp) {
            this.writeEntriesToAudit(context);
            context.setTimer("batch", System.currentTimeMillis() + (long)this.batchThresholdMs);
        }

        public void processRecord(ComputationContext context, String inputStreamName, Record record) {
            try {
                this.logEntries.add(this.getLogEntryFromJson(record.data));
            }
            catch (NuxeoException e) {
                log.error((Object)("Discard invalid record: " + record), (Throwable)e);
                return;
            }
            if (this.logEntries.size() >= this.batchSize) {
                this.writeEntriesToAudit(context);
            }
        }

        public void destroy() {
            log.debug((Object)String.format("Destroy computation: %s, pending entries: %d", StreamAuditWriter.COMPUTATION_NAME, this.logEntries.size()));
        }

        protected void writeEntriesToAudit(ComputationContext context) {
            if (this.logEntries.isEmpty()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Writing %d log entries to audit backend.", this.logEntries.size()));
            }
            AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
            logger.addLogEntries(this.logEntries);
            this.logEntries.clear();
            context.askForCheckpoint();
        }

        protected LogEntry getLogEntryFromJson(byte[] data) {
            String json = "";
            try {
                json = new String(data, "UTF-8");
                ObjectMapper mapper = new ObjectMapper();
                return (LogEntry)mapper.readValue(json, LogEntryImpl.class);
            }
            catch (UnsupportedEncodingException e) {
                throw new NuxeoException("Discard log entry, invalid byte array", (Throwable)e);
            }
            catch (IOException e) {
                throw new NuxeoException("Invalid json logEntry" + json, (Throwable)e);
            }
        }
    }
}

