/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.SerializationUtils;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;

public class ExtendedInfoSerializer
extends JsonSerializer<ExtendedInfo> {
    public void serialize(ExtendedInfo info, JsonGenerator jg, SerializerProvider provider) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        jg.setCodec((ObjectCodec)mapper);
        if (info instanceof ExtendedInfoImpl.DateInfo) {
            ExtendedInfoImpl.DateInfo dateInfo = (ExtendedInfoImpl.DateInfo)info;
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();
            Instant instant = dateInfo.getDateValue().toInstant();
            jg.writeObject((Object)formatter.format(instant));
        } else if (info instanceof ExtendedInfoImpl.BlobInfo) {
            Serializable value = ((ExtendedInfoImpl.BlobInfo)info).getBlobValue();
            jg.writeObject((Object)Base64.encodeBase64((byte[])SerializationUtils.serialize((Serializable)value)));
        } else if (info instanceof ExtendedInfoImpl.StringInfo) {
            String stringValue = ((ExtendedInfoImpl.StringInfo)info).getStringValue().trim();
            if (stringValue.startsWith("{") && stringValue.endsWith("}") || stringValue.startsWith("[") && stringValue.endsWith("]")) {
                try {
                    mapper.readTree(stringValue);
                    jg.writeRawValue(stringValue);
                }
                catch (IOException e) {
                    jg.writeObject(null);
                }
            } else {
                jg.writeString(stringValue);
            }
        } else {
            jg.writeObject((Object)info.getSerializableValue());
        }
    }
}

