/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.nuxeo.automation.scripting.internals.DocumentScriptingWrapper;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.automation.context.ContextService;
import org.nuxeo.ecm.automation.core.scripting.DateWrapper;
import org.nuxeo.ecm.automation.core.scripting.PrincipalWrapper;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class AutomationMapper
implements Bindings {
    protected final OperationContext ctx;
    protected final Map<String, Supplier<Object>> automatic = new HashMap<String, Supplier<Object>>();
    protected final Bindings bindings = new SimpleBindings();
    protected final Map<String, Object> wrapped = new HashMap<String, Object>();

    public static CompiledScript compile(Compilable compilable) {
        try {
            return new ScriptBuilder().build(compilable);
        }
        catch (ScriptException cause) {
            throw new NuxeoException("Cannot compile mapper initialization script", (Throwable)cause);
        }
    }

    public AutomationMapper(OperationContext ctx) {
        this.ctx = ctx;
        this.automatic.put("Session", () -> ctx.getCoreSession());
        this.automatic.put("ctx", () -> ctx.getVars());
        this.automatic.put("automation", () -> this);
        this.automatic.put("CurrentUser", () -> new PrincipalWrapper((NuxeoPrincipal)ctx.getPrincipal()));
        this.automatic.put("currentUser", () -> new PrincipalWrapper((NuxeoPrincipal)ctx.getPrincipal()));
        this.automatic.put("Env", () -> Framework.getProperties());
        this.automatic.put("CurrentDate", () -> new DateWrapper());
        ContextService contextService = (ContextService)Framework.getService(ContextService.class);
        Map helperFunctions = contextService.getHelperFunctions();
        for (String helperFunctionsId : helperFunctions.keySet()) {
            this.automatic.put(helperFunctionsId, () -> (ContextHelper)helperFunctions.get(helperFunctionsId));
        }
    }

    public void flush() {
        this.wrapped.forEach((? super K k, ? super V v) -> this.ctx.put(k, this.unwrap(v)));
        this.wrapped.clear();
    }

    public Object unwrap(Object wrapped) {
        return DocumentScriptingWrapper.unwrap(wrapped);
    }

    public Object wrap(Object unwrapped) {
        return DocumentScriptingWrapper.wrap(unwrapped, this);
    }

    public Object executeOperation(String opId, Object input, ScriptObjectMirror parameters) throws Exception {
        this.flush();
        input = DocumentScriptingWrapper.unwrap(input);
        this.ctx.setInput(input);
        AutomationService automation = (AutomationService)Framework.getService(AutomationService.class);
        Class<Void> typeof = input == null ? Void.TYPE : input.getClass();
        OperationParameters args = new OperationParameters(opId, DocumentScriptingWrapper.unwrap((Map<String, Object>)parameters));
        Object output = automation.compileChain(typeof, new OperationParameters[]{args}).invoke(this.ctx);
        return this.wrap(output);
    }

    @Override
    public int size() {
        return Stream.concat(this.automatic.keySet().stream(), Stream.concat(this.bindings.keySet().stream(), this.ctx.keySet().stream())).distinct().collect(Collectors.counting()).intValue();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.automatic.containsKey(key) || this.bindings.containsKey(key) || this.ctx.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.automatic.containsValue(value) || this.bindings.containsValue(value) || this.ctx.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.automatic.getOrDefault(key, () -> this.bindings.computeIfAbsent((String)key, (? super K k) -> this.wrap(this.ctx.get(k)))).get();
    }

    @Override
    public Object put(String key, Object value) {
        this.bindings.put(key, value);
        this.wrapped.put(key, value);
        return value;
    }

    @Override
    public Object remove(Object key) {
        Object wrapped = this.bindings.remove(key);
        Object unwrapped = this.ctx.remove(key);
        if (wrapped == null) {
            wrapped = this.wrap(unwrapped);
        }
        return wrapped;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.bindings.putAll(m);
        this.wrapped.putAll(m);
    }

    @Override
    public void clear() {
        this.bindings.clear();
        this.wrapped.clear();
        this.ctx.clear();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return Optional.ofNullable(this.get(key)).orElse(defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ? extends Object> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ? extends Object> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public static class ScriptBuilder {
        public CompiledScript build(Compilable compilable) throws ScriptException {
            return compilable.compile(this.source());
        }

        public String source() {
            StringBuffer sb = new StringBuffer();
            AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
            HashMap<String, List<String>> opMap = new HashMap<String, List<String>>();
            ArrayList<String> flatOps = new ArrayList<String>();
            ArrayList<String> ids = new ArrayList<String>();
            for (OperationType op : as.getOperations()) {
                ids.add(op.getId());
                if (op.getAliases() == null) continue;
                Collections.addAll(ids, op.getAliases());
            }
            for (String id : ids) {
                this.parseAutomationIDSForScripting(opMap, flatOps, id);
            }
            for (String obName : opMap.keySet()) {
                List ops = (List)opMap.get(obName);
                sb.append("\nvar ").append(obName).append("={};");
                for (String opId : ops) {
                    this.generateFunction(sb, opId);
                }
            }
            for (String opId : flatOps) {
                this.generateFlatFunction(sb, opId);
            }
            return sb.toString();
        }

        protected void parseAutomationIDSForScripting(Map<String, List<String>> opMap, List<String> flatOps, String id) {
            if (id.split("\\.").length > 2) {
                return;
            }
            int idx = id.indexOf(".");
            if (idx > 0) {
                String obName = id.substring(0, idx);
                List<String> ops = opMap.get(obName);
                if (ops == null) {
                    ops = new ArrayList<String>();
                }
                ops.add(id);
                opMap.put(obName, ops);
            } else {
                flatOps.add(id);
            }
        }

        protected void generateFunction(StringBuffer sb, String opId) {
            sb.append("\n" + this.replaceDashByUnderscore(opId) + " = function(input,params) {");
            sb.append("\nreturn automation.executeOperation('" + opId + "', input , params);");
            sb.append("\n};");
        }

        protected void generateFlatFunction(StringBuffer sb, String opId) {
            sb.append("\nvar " + this.replaceDashByUnderscore(opId) + " = function(input,params) {");
            sb.append("\nreturn automation.executeOperation('" + opId + "', input , params);");
            sb.append("\n};");
        }

        protected String replaceDashByUnderscore(String id) {
            return id.replaceAll("[\\s\\-()]", "_");
        }
    }
}

