/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.automation.scripting.api.AutomationScriptingService;
import org.nuxeo.automation.scripting.internals.AutomationMapper;
import org.nuxeo.automation.scripting.internals.AutomationScriptingParamsInjector;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.api.Framework;

public class AutomationScriptingServiceImpl
implements AutomationScriptingService {
    private final Supplier<ScriptEngine> supplier;
    protected AutomationScriptingParamsInjector paramsInjector;
    final ScriptEngine engine;

    public AutomationScriptingServiceImpl() {
        this.supplier = (AutomationScriptingServiceImpl)this.new Factory().supplier;
        this.engine = this.supplier.get();
    }

    @Override
    public AutomationScriptingService.Session get(CoreSession session) {
        return this.get(new OperationContext(session));
    }

    @Override
    public AutomationScriptingService.Session get(OperationContext context) {
        return new Bridge(context);
    }

    class Factory {
        final NashornScriptEngineFactory nashorn = new NashornScriptEngineFactory();
        final Supplier<ScriptEngine> supplier = this.supplier();

        Factory() {
        }

        Supplier<ScriptEngine> supplier() {
            Log log = LogFactory.getLog(AutomationScriptingServiceImpl.class);
            String version = Framework.getProperty((String)"java.version");
            if (!ConfigurationGenerator.checkJavaVersion((String)version, (String)"1.8.0_1")) {
                throw new UnsupportedOperationException("1.8.0_1");
            }
            if (!ConfigurationGenerator.checkJavaVersion((String)version, (String)"1.8.0_25")) {
                log.warn((Object)"Nashorn cache is not available. jdk8u25 is required to optimize Automation Javascript performances.");
                return this.noCache();
            }
            if (!ConfigurationGenerator.checkJavaVersion((String)version, (String)"1.8.0_40")) {
                if (Boolean.parseBoolean(Framework.getProperty((String)"automation.scripting.precompile.enable", (String)"true"))) {
                    log.warn((Object)"Class Filter is not available. jdk8u40 is required to activate Automation Javascript imports security.");
                    return this.cache();
                }
                log.warn((Object)"Class Filter is not available. jdk8u40 is required to activate Automation Javascript imports security.");
                return this.noCache();
            }
            try {
                if (Boolean.parseBoolean(Framework.getProperty((String)"automation.scripting.precompile.enable", (String)"true"))) {
                    return this.cacheAndClassFilter();
                }
                return this.noCacheAndClassFilter();
            }
            catch (NoClassDefFoundError cause) {
                log.warn((Object)"Class Filter is not available. jdk8u40 is required to activate Automation Javascript imports security.");
                return this.cache();
            }
        }

        Supplier<ScriptEngine> noCache() {
            return () -> this.nashorn.getScriptEngine(new String[]{"-strict"});
        }

        Supplier<ScriptEngine> cache() {
            return () -> this.nashorn.getScriptEngine(new String[]{"-strict", "--optimistic-types=true", "--persistent-code-cache", "--class-cache-size=50"}, Thread.currentThread().getContextClassLoader());
        }

        Supplier<ScriptEngine> cacheAndClassFilter() {
            return () -> this.nashorn.getScriptEngine(new String[]{"-strict", "--optimistic-types=true", "--persistent-code-cache", "--class-cache-size=50"}, Thread.currentThread().getContextClassLoader(), new ClassFilter(){

                public boolean exposeToScripts(String className) {
                    return false;
                }
            });
        }

        Supplier<ScriptEngine> noCacheAndClassFilter() {
            return () -> this.nashorn.getScriptEngine(new String[]{"-strict"}, Thread.currentThread().getContextClassLoader(), new ClassFilter(){

                public boolean exposeToScripts(String className) {
                    return false;
                }
            });
        }
    }

    class Bridge
    implements AutomationScriptingService.Session {
        final CompiledScript mapperScript;
        final Compilable compilable;
        final Invocable invocable;
        final ScriptContext scriptContext;
        final AutomationMapper mapper;
        final ScriptObjectMirror global;

        Bridge(OperationContext operationContext) {
            this.mapperScript = AutomationMapper.compile((Compilable)((Object)AutomationScriptingServiceImpl.this.engine));
            this.compilable = (Compilable)((Object)AutomationScriptingServiceImpl.this.engine);
            this.invocable = (Invocable)((Object)AutomationScriptingServiceImpl.this.engine);
            this.scriptContext = AutomationScriptingServiceImpl.this.engine.getContext();
            this.mapper = new AutomationMapper(operationContext);
            try {
                this.mapperScript.eval(this.mapper);
            }
            catch (ScriptException cause) {
                throw new NuxeoException("Cannot execute mapper " + this.mapperScript, (Throwable)cause);
            }
            this.global = (ScriptObjectMirror)this.mapper.get("nashorn.global");
            this.scriptContext.setBindings(this.mapper, 100);
        }

        @Override
        public <T> T handleof(InputStream input, Class<T> typeof) {
            this.run(input);
            final T handle = this.invocable.getInterface(this.global, typeof);
            if (handle == null) {
                throw new NuxeoException("Script doesn't implements " + typeof.getName());
            }
            return typeof.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{typeof}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return Bridge.this.mapper.unwrap(method.invoke(handle, Bridge.this.mapper.wrap(args[0]), Bridge.this.mapper.wrap(args[1])));
                }
            }));
        }

        @Override
        public Object run(InputStream input) {
            try {
                return this.mapper.unwrap(AutomationScriptingServiceImpl.this.engine.eval((Reader)new InputStreamReader(input), (Bindings)this.mapper));
            }
            catch (ScriptException cause) {
                throw new NuxeoException("Cannot evaluate automation script", (Throwable)cause);
            }
        }

        <T> T handleof(Class<T> typeof) {
            return this.invocable.getInterface(this.global, typeof);
        }

        @Override
        public <T> T adapt(Class<T> typeof) {
            if (typeof.isAssignableFrom(AutomationScriptingServiceImpl.this.engine.getClass())) {
                return typeof.cast(AutomationScriptingServiceImpl.this.engine);
            }
            if (typeof.isAssignableFrom(AutomationMapper.class)) {
                return typeof.cast(this.mapper);
            }
            if (typeof.isAssignableFrom(this.scriptContext.getClass())) {
                return typeof.cast(this.scriptContext);
            }
            throw new IllegalArgumentException("Cannot adapt scripting context to " + typeof.getName());
        }

        @Override
        public void close() throws Exception {
            this.mapper.flush();
        }
    }
}

