/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.config;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.writer.JsonXmlStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamWriter;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.tools.report.ReportWriter;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.connect.ConnectBroker;
import org.nuxeo.launcher.info.ConfigurationInfo;
import org.nuxeo.launcher.info.DistributionInfo;
import org.nuxeo.launcher.info.InstanceInfo;
import org.nuxeo.launcher.info.KeyValueInfo;
import org.nuxeo.launcher.info.PackageInfo;

public class ConfigReport
implements ReportWriter {
    @Override
    public void write(OutputStream output) throws IOException {
        try {
            ConfigurationGenerator configurationGenerator = new ConfigurationGenerator();
            configurationGenerator.init();
            ConnectBroker connectBroker = new ConnectBroker(configurationGenerator.getEnv());
            InstanceInfo info = configurationGenerator.getServerConfigurator().getInfo(this.getCLID(connectBroker), connectBroker.getPkgList());
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{InstanceInfo.class, DistributionInfo.class, PackageInfo.class, ConfigurationInfo.class, KeyValueInfo.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)info, this.jsonWriter(context, output));
        }
        catch (JAXBException | PackageException cause) {
            throw new IOException("Cannot write runtime configuration", cause);
        }
    }

    protected String getCLID(ConnectBroker connectBroker) {
        try {
            return connectBroker.getCLID();
        }
        catch (LogicalInstanceIdentifier.NoCLID cause) {
            return "no-clid";
        }
    }

    protected XMLStreamWriter jsonWriter(JAXBContext context, OutputStream out) {
        JSONConfiguration config = JSONConfiguration.mapped().rootUnwrapping(true).attributeAsElement(new String[]{"key", "value"}).build();
        config = JSONConfiguration.createJSONConfigurationWithFormatted((JSONConfiguration)config, (boolean)true);
        return JsonXmlStreamWriter.createWriter((Writer)new OutputStreamWriter(out), (JSONConfiguration)config, (String)"");
    }
}

