/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kv;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.kv.KeyValueStoreDescriptor;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;
import org.nuxeo.runtime.kv.KeyValueStoreRegistry;
import org.nuxeo.runtime.kv.MemKeyValueStore;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class KeyValueServiceImpl
extends DefaultComponent
implements KeyValueService {
    private static final Log log = LogFactory.getLog(KeyValueServiceImpl.class);
    public static final int APPLICATION_STARTED_ORDER = -500;
    public static final String CONFIG_XP = "configuration";
    public static final String DEFAULT_STORE_ID = "default";
    protected final KeyValueStoreRegistry registry = new KeyValueStoreRegistry();
    protected Map<String, KeyValueStoreProvider> providers = new ConcurrentHashMap<String, KeyValueStoreProvider>();
    protected KeyValueStore defaultStore = new MemKeyValueStore();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "configuration": {
                this.registerKeyValueStore((KeyValueStoreDescriptor)contribution);
                break;
            }
            default: {
                throw new RuntimeException("Unknown extension point: " + extensionPoint);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "configuration": {
                this.unregisterKeyValueStore((KeyValueStoreDescriptor)contribution);
            }
        }
    }

    public void registerKeyValueStore(KeyValueStoreDescriptor descriptor) {
        this.registry.addContribution(descriptor);
        this.descriptorChanged(descriptor.name);
        log.info((Object)("Registered key/value store: " + descriptor.name));
    }

    public void unregisterKeyValueStore(KeyValueStoreDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
        this.descriptorChanged(descriptor.name);
        log.info((Object)("Unregistered key/value store: " + descriptor.name));
    }

    public int getApplicationStartedOrder() {
        return -500;
    }

    @Override
    public synchronized KeyValueStore getKeyValueStore(String name) {
        KeyValueStoreProvider provider = this.providers.get(name);
        if (provider == null) {
            KeyValueStoreDescriptor descriptor = this.registry.getKeyValueStoreDescriptor(name);
            if (descriptor == null && (descriptor = this.registry.getKeyValueStoreDescriptor(DEFAULT_STORE_ID)) == null) {
                return this.defaultStore;
            }
            try {
                provider = descriptor.getKlass().newInstance();
                provider.initialize(descriptor);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.providers.put(name, provider);
        }
        return provider;
    }

    protected synchronized void descriptorChanged(String name) {
        KeyValueStoreProvider provider = this.providers.remove(name);
        if (provider != null) {
            provider.close();
        }
    }
}

