/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import javax.servlet.ServletException;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationManager;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FilterSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ResourceExtension;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ResourcesDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.service.http.NamespaceException;

public class ServletRegistryComponent
extends DefaultComponent {
    public static final String XP_SERVLETS = "servlets";
    public static final String XP_FILTERS = "filters";
    public static final String XP_RESOURCES = "resources";
    public static final String XP_SUBRESOURCES = "subresources";
    protected ServletRegistry registry;

    public void activate(ComponentContext context) {
        this.registry = ServletRegistry.getInstance();
    }

    public void deactivate(ComponentContext context) {
        ServletRegistry.dispose();
        this.registry = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_SERVLETS.equals(extensionPoint)) {
            ((ServletDescriptor)contribution).setBundle(contributor.getContext().getBundle());
            try {
                this.registry.addServlet((ServletDescriptor)contribution);
            }
            catch (ServletException | NamespaceException e) {
                throw new RuntimeException(e);
            }
        } else if (XP_FILTERS.equals(extensionPoint)) {
            this.registry.addFilterSet((FilterSetDescriptor)contribution);
        } else if (XP_RESOURCES.equals(extensionPoint)) {
            ResourcesDescriptor rd = (ResourcesDescriptor)contribution;
            rd.setBundle(contributor.getContext().getBundle());
            this.registry.addResources(rd);
        } else if (XP_SUBRESOURCES.equals(extensionPoint)) {
            ResourceExtension rxt = (ResourceExtension)contribution;
            rxt.setBundle(contributor.getContext().getBundle());
            ApplicationManager.getInstance().getOrCreateApplication(rxt.getApplication()).addExtension(rxt);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_SERVLETS.equals(extensionPoint)) {
            this.registry.removeServlet((ServletDescriptor)contribution);
        } else if (XP_FILTERS.equals(extensionPoint)) {
            this.registry.removeFilterSet((FilterSetDescriptor)contribution);
        } else if (XP_RESOURCES.equals(extensionPoint)) {
            ResourcesDescriptor rd = (ResourcesDescriptor)contribution;
            rd.setBundle(contributor.getContext().getBundle());
            this.registry.removeResources(rd);
        } else if (XP_SUBRESOURCES.equals(extensionPoint)) {
            ResourceExtension rxt = (ResourceExtension)contribution;
            rxt.setBundle(contributor.getContext().getBundle());
            ApplicationManager.getInstance().getOrCreateApplication(rxt.getApplication()).removeExtension(rxt);
        }
    }
}

