/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.impl.blob.AsyncBlob;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.ecm.core.io.download.DefaultRedirectResolver;
import org.nuxeo.ecm.core.io.download.DownloadBlobInfo;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadPermissionDescriptor;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.download.RedirectResolver;
import org.nuxeo.ecm.core.io.download.RedirectResolverDescriptor;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DownloadServiceImpl
extends DefaultComponent
implements DownloadService {
    private static final Log log = LogFactory.getLog(DownloadServiceImpl.class);
    protected static final int DOWNLOAD_BUFFER_SIZE = 524288;
    private static final String NUXEO_VIRTUAL_HOST = "nuxeo-virtual-host";
    private static final String VH_PARAM = "nuxeo.virtual.host";
    private static final String FORCE_NO_CACHE_ON_MSIE = "org.nuxeo.download.force.nocache.msie";
    private static final String XP = "permissions";
    private static final String REDIRECT_RESOLVER = "redirectResolver";
    private static final String RUN_FUNCTION = "run";
    private DownloadPermissionRegistry registry = new DownloadPermissionRegistry();
    private ScriptEngineManager scriptEngineManager;
    protected RedirectResolver redirectResolver = new DefaultRedirectResolver();
    protected List<RedirectResolverDescriptor> redirectResolverContributions = new ArrayList<RedirectResolverDescriptor>();

    public DownloadServiceImpl() {
        this.scriptEngineManager = new ScriptEngineManager();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            DownloadPermissionDescriptor descriptor = (DownloadPermissionDescriptor)contribution;
            this.registry.addContribution(descriptor);
        } else if (REDIRECT_RESOLVER.equals(extensionPoint)) {
            this.redirectResolver = ((RedirectResolverDescriptor)contribution).getObject();
            this.redirectResolverContributions.add((RedirectResolverDescriptor)contribution);
        } else {
            throw new UnsupportedOperationException(extensionPoint);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            DownloadPermissionDescriptor descriptor = (DownloadPermissionDescriptor)contribution;
            this.registry.removeContribution(descriptor);
        } else if (REDIRECT_RESOLVER.equals(extensionPoint)) {
            this.redirectResolverContributions.remove(contribution);
            this.redirectResolver = this.redirectResolverContributions.size() == 0 ? new DefaultRedirectResolver() : this.redirectResolverContributions.get(this.redirectResolverContributions.size() - 1).getObject();
        } else {
            throw new UnsupportedOperationException(extensionPoint);
        }
    }

    @Override
    public String storeBlobs(List<Blob> blobs) {
        if (blobs.size() > 1) {
            throw new IllegalArgumentException("multipart download not yet implemented");
        }
        TransientStore ts = ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore("download");
        String storeKey = UUID.randomUUID().toString();
        ts.putBlobs(storeKey, blobs);
        ts.setCompleted(storeKey, true);
        return storeKey;
    }

    @Override
    public String getDownloadUrl(DocumentModel doc, String xpath, String filename) {
        return this.getDownloadUrl(doc.getRepositoryName(), doc.getId(), xpath, filename);
    }

    @Override
    public String getDownloadUrl(String repositoryName, String docId, String xpath, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append("nxfile");
        sb.append("/").append(repositoryName);
        sb.append("/").append(docId);
        if (xpath != null) {
            sb.append("/").append(xpath);
            if (filename != null) {
                filename = this.getFilenameWithoutPath(filename);
                sb.append("/").append(URIUtils.quoteURIPathComponent((String)filename, (boolean)true));
            }
        }
        return sb.toString();
    }

    protected String getFilenameWithoutPath(String filename) {
        int sep = Math.max(filename.lastIndexOf(92), filename.lastIndexOf(47));
        if (sep != -1) {
            filename = filename.substring(sep + 1);
        }
        return filename;
    }

    @Override
    public String getDownloadUrl(String storeKey) {
        return "nxbigblob/" + storeKey;
    }

    protected Pair<String, Action> getDownloadPathAndAction(String path) {
        int slash;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((slash = path.indexOf(47)) < 0) {
            return null;
        }
        String type = path.substring(0, slash);
        String downloadPath = path.substring(slash + 1);
        switch (type) {
            case "nxdownloadinfo": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.INFO));
            }
            case "nxfile": 
            case "nxbigfile": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.DOWNLOAD_FROM_DOC));
            }
            case "nxbigzipfile": 
            case "nxbigblob": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.DOWNLOAD));
            }
            case "nxblobstatus": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.BLOBSTATUS));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob resolveBlobFromDownloadUrl(String url) {
        String nuxeoUrl = Framework.getProperty((String)"nuxeo.url");
        if (!url.startsWith(nuxeoUrl)) {
            return null;
        }
        String path = url.substring(nuxeoUrl.length() + 1);
        Pair<String, Action> pair = this.getDownloadPathAndAction(path);
        if (pair == null) {
            return null;
        }
        String downloadPath = (String)pair.getLeft();
        try {
            DownloadBlobInfo downloadBlobInfo = new DownloadBlobInfo(downloadPath);
            try (CoreSession session = CoreInstance.openCoreSession((String)downloadBlobInfo.repository);){
                IdRef docRef = new IdRef(downloadBlobInfo.docId);
                if (!session.exists((DocumentRef)docRef)) {
                    Blob blob2 = null;
                    return blob2;
                }
                DocumentModel doc = session.getDocument((DocumentRef)docRef);
                Blob blob = this.resolveBlob(doc, downloadBlobInfo.xpath);
                return blob;
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void handleDownload(HttpServletRequest req, HttpServletResponse resp, String baseUrl, String path) throws IOException {
        Pair<String, Action> pair = this.getDownloadPathAndAction(path);
        if (pair == null) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        String downloadPath = (String)pair.getLeft();
        Action action = (Action)((Object)pair.getRight());
        switch (action) {
            case INFO: {
                this.handleDownload(req, resp, downloadPath, baseUrl, true);
                break;
            }
            case DOWNLOAD_FROM_DOC: {
                this.handleDownload(req, resp, downloadPath, baseUrl, false);
                break;
            }
            case DOWNLOAD: {
                this.downloadBlob(req, resp, downloadPath, "download");
                break;
            }
            case BLOBSTATUS: {
                this.downloadBlobStatus(req, resp, downloadPath, "download");
                break;
            }
            default: {
                resp.sendError(404, "Invalid URL syntax");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleDownload(HttpServletRequest req, HttpServletResponse resp, String downloadPath, String baseUrl, boolean info) throws IOException {
        DownloadBlobInfo downloadBlobInfo;
        boolean tx = false;
        try {
            downloadBlobInfo = new DownloadBlobInfo(downloadPath);
        }
        catch (IllegalArgumentException e) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        try {
            if (!TransactionHelper.isTransactionActive()) {
                tx = TransactionHelper.startTransaction();
            }
            String xpath = downloadBlobInfo.xpath;
            String filename = downloadBlobInfo.filename;
            try (CoreSession session = CoreInstance.openCoreSession((String)downloadBlobInfo.repository);){
                IdRef docRef = new IdRef(downloadBlobInfo.docId);
                if (!session.exists((DocumentRef)docRef)) {
                    NuxeoPrincipal nuxeoPrincipal;
                    Principal principal = req.getUserPrincipal();
                    if (principal instanceof NuxeoPrincipal && (nuxeoPrincipal = (NuxeoPrincipal)principal).isAnonymous()) {
                        throw new DocumentSecurityException("Authentication is needed for downloading the blob");
                    }
                    resp.sendError(404, "No document found");
                    return;
                }
                DocumentModel doc = session.getDocument((DocumentRef)docRef);
                if (info) {
                    Blob blob = this.resolveBlob(doc, xpath);
                    if (blob == null) {
                        resp.sendError(404, "No blob found");
                        return;
                    }
                    String downloadUrl = baseUrl + this.getDownloadUrl(doc, xpath, filename);
                    String result = blob.getMimeType() + ':' + URLEncoder.encode(blob.getFilename(), "UTF-8") + ':' + downloadUrl;
                    resp.setContentType("text/plain");
                    resp.getWriter().write(result);
                    resp.getWriter().flush();
                    return;
                }
                this.downloadBlob(req, resp, doc, xpath, null, filename, "download");
                return;
            }
        }
        catch (NuxeoException e) {
            if (!tx) throw new IOException(e);
            TransactionHelper.setTransactionRollbackOnly();
            throw new IOException(e);
        }
        finally {
            if (tx) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    @Override
    public void downloadBlobStatus(HttpServletRequest request, HttpServletResponse response, String key, String reason) throws IOException {
        this.downloadBlob(request, response, key, reason, true);
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, String key, String reason) throws IOException {
        this.downloadBlob(request, response, key, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadBlob(HttpServletRequest request, HttpServletResponse response, String key, String reason, boolean status) throws IOException {
        TransientStore ts = ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore("download");
        if (!ts.exists(key)) {
            response.sendError(404);
            return;
        }
        List blobs = ts.getBlobs(key);
        if (blobs == null || blobs.isEmpty()) {
            response.sendError(404);
            return;
        }
        if (blobs.size() > 1) {
            throw new IllegalArgumentException("multipart download not yet implemented");
        }
        if (ts.getParameter(key, "error") != null) {
            response.sendError(500, (String)((Object)ts.getParameter(key, "error")));
        } else {
            Serializable progress;
            boolean isCompleted = ts.isCompleted(key);
            if (!status && !isCompleted) {
                response.setStatus(202);
                return;
            }
            Object blob = status ? new AsyncBlob(key, isCompleted, (progress = ts.getParameter(key, "progress")) != null ? (Integer)progress : -1) : (Blob)blobs.get(0);
            try {
                this.downloadBlob(request, response, null, null, (Blob)blob, blob.getFilename(), reason);
            }
            finally {
                if (!status) {
                    ts.remove(key);
                }
            }
        }
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason) throws IOException {
        this.downloadBlob(request, response, doc, xpath, blob, filename, reason, Collections.emptyMap());
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos) throws IOException {
        this.downloadBlob(request, response, doc, xpath, blob, filename, reason, extendedInfos, null);
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos, Boolean inline) throws IOException {
        if (blob == null) {
            if (doc == null) {
                throw new NuxeoException("No doc specified");
            }
            blob = this.resolveBlob(doc, xpath);
            if (blob == null) {
                response.sendError(404, "No blob found");
                return;
            }
        }
        Blob fblob = blob;
        this.downloadBlob(request, response, doc, xpath, blob, filename, reason, extendedInfos, inline, byteRange -> this.transferBlobWithByteRange(fblob, (DownloadService.ByteRange)byteRange, response));
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos, Boolean inline, Consumer<DownloadService.ByteRange> blobTransferer) throws IOException {
        Objects.requireNonNull(blob);
        if (!this.checkPermission(doc, xpath, blob, reason, extendedInfos)) {
            response.sendError(403, "Permission denied");
            return;
        }
        URI uri = this.redirectResolver.getURI(blob, BlobManager.UsageHint.DOWNLOAD, request);
        if (uri != null) {
            try {
                HashMap<String, Serializable> ei = new HashMap<String, Serializable>();
                if (extendedInfos != null) {
                    ei.putAll(extendedInfos);
                }
                ei.put("redirect", (Serializable)((Object)uri.toString()));
                this.logDownload(doc, xpath, filename, reason, ei);
                response.sendRedirect(uri.toString());
            }
            catch (IOException ioe) {
                DownloadHelper.handleClientDisconnect(ioe);
            }
            return;
        }
        try {
            long contentLength;
            DownloadService.ByteRange byteRange;
            String digest = blob.getDigest();
            if (digest == null) {
                digest = DigestUtils.md5Hex((InputStream)blob.getStream());
            }
            String etag = '\"' + digest + '\"';
            response.setHeader("ETag", etag);
            this.addCacheControlHeaders(request, response);
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null) {
                boolean match = false;
                if (ifNoneMatch.equals("*")) {
                    match = true;
                } else {
                    for (String previousEtag : StringUtils.split((String)ifNoneMatch, (String)", ")) {
                        if (!previousEtag.equals(etag)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) {
                    String method = request.getMethod();
                    if (method.equals("GET") || method.equals("HEAD")) {
                        response.sendError(304);
                    } else {
                        response.sendError(412);
                    }
                    return;
                }
            }
            if (StringUtils.isBlank((String)filename)) {
                filename = StringUtils.defaultIfBlank((String)blob.getFilename(), (String)"file");
            }
            String contentDisposition = DownloadHelper.getRFC2231ContentDisposition(request, filename, inline);
            response.setHeader("Content-Disposition", contentDisposition);
            response.setContentType(blob.getMimeType());
            if (StringUtils.isNotBlank((String)blob.getEncoding())) {
                try {
                    response.setCharacterEncoding(blob.getEncoding());
                }
                catch (IllegalArgumentException method) {
                    // empty catch block
                }
            }
            long length = blob.getLength();
            response.setHeader("Accept-Ranges", "bytes");
            String range = request.getHeader("Range");
            if (StringUtils.isBlank((String)range)) {
                byteRange = null;
            } else {
                byteRange = DownloadHelper.parseRange(range, length);
                if (byteRange == null) {
                    log.error((Object)("Invalid byte range received: " + range));
                } else {
                    response.setHeader("Content-Range", "bytes " + byteRange.getStart() + "-" + byteRange.getEnd() + "/" + length);
                    response.setStatus(206);
                }
            }
            long l = contentLength = byteRange == null ? length : byteRange.getLength();
            if (contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)contentLength);
            }
            this.logDownload(doc, xpath, filename, reason, extendedInfos);
            blobTransferer.accept(byteRange);
        }
        catch (UncheckedIOException e) {
            DownloadHelper.handleClientDisconnect(e.getCause());
        }
        catch (IOException ioe) {
            DownloadHelper.handleClientDisconnect(ioe);
        }
    }

    protected void transferBlobWithByteRange(Blob blob, DownloadService.ByteRange byteRange, HttpServletResponse response) throws UncheckedIOException {
        this.transferBlobWithByteRange(blob, byteRange, () -> {
            try {
                return response.getOutputStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void transferBlobWithByteRange(Blob blob, DownloadService.ByteRange byteRange, Supplier<OutputStream> outputStreamSupplier) throws UncheckedIOException {
        try (InputStream in = blob.getStream();){
            OutputStream out = outputStreamSupplier.get();
            BufferingServletOutputStream.stopBuffering(out);
            if (byteRange == null) {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            } else {
                IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)byteRange.getStart(), (long)byteRange.getLength());
            }
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String fixXPath(String xpath) {
        return xpath == null ? null : xpath.replace(';', ':');
    }

    @Override
    public Blob resolveBlob(DocumentModel doc) {
        BlobHolderAdapterService blobHolderAdapterService = (BlobHolderAdapterService)Framework.getService(BlobHolderAdapterService.class);
        return blobHolderAdapterService.getBlobHolderAdapter(doc, "download").getBlob();
    }

    @Override
    public Blob resolveBlob(DocumentModel doc, String xpath) {
        Blob blob;
        if (xpath == null) {
            return this.resolveBlob(doc);
        }
        if ((xpath = this.fixXPath(xpath)).startsWith("blobholder:")) {
            int index;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                log.debug((Object)"Not a BlobHolder");
                return null;
            }
            String suffix = xpath.substring("blobholder:".length());
            try {
                index = Integer.parseInt(suffix);
            }
            catch (NumberFormatException e) {
                log.debug((Object)e.getMessage());
                return null;
            }
            if (!suffix.equals(Integer.toString(index))) {
                log.debug((Object)("Non-canonical index: " + suffix));
                return null;
            }
            blob = index == 0 ? bh.getBlob() : (Blob)bh.getBlobs().get(index);
        } else {
            if (!xpath.contains(":")) {
                log.debug((Object)("Non-canonical xpath: " + xpath));
                return null;
            }
            try {
                blob = (Blob)doc.getPropertyValue(xpath);
            }
            catch (PropertyNotFoundException e) {
                log.debug((Object)e.getMessage());
                return null;
            }
        }
        return blob;
    }

    @Override
    public boolean checkPermission(DocumentModel doc, String xpath, Blob blob, String reason, Map<String, Serializable> extendedInfos) {
        List<DownloadPermissionDescriptor> descriptors = this.registry.getDownloadPermissionDescriptors();
        if (descriptors.isEmpty()) {
            return true;
        }
        xpath = this.fixXPath(xpath);
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<Object, Object> ei = extendedInfos == null ? Collections.emptyMap() : extendedInfos;
        NuxeoPrincipal currentUser = ClientLoginModule.getCurrentPrincipal();
        context.put("Document", doc);
        context.put("XPath", xpath);
        context.put("Blob", blob);
        context.put("Reason", reason);
        context.put("Infos", ei);
        context.put("Rendition", ei.get("rendition"));
        context.put("CurrentUser", currentUser);
        for (DownloadPermissionDescriptor descriptor : descriptors) {
            Object result;
            ScriptEngine engine = this.scriptEngineManager.getEngineByName(descriptor.getScriptLanguage());
            if (engine == null) {
                throw new NuxeoException("Engine not found for language: " + descriptor.getScriptLanguage() + " in permission: " + descriptor.getName());
            }
            if (!(engine instanceof Invocable)) {
                throw new NuxeoException("Engine " + engine.getClass().getName() + " not Invocable for language: " + descriptor.getScriptLanguage() + " in permission: " + descriptor.getName());
            }
            try {
                engine.eval(descriptor.getScript());
                engine.getBindings(100).putAll((Map<? extends String, ? extends Object>)context);
                result = ((Invocable)((Object)engine)).invokeFunction(RUN_FUNCTION, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new NuxeoException("Script does not contain function: run() in permission: " + descriptor.getName(), (Throwable)e);
            }
            catch (ScriptException e) {
                log.error((Object)("Failed to evaluate script: " + descriptor.getName()), (Throwable)e);
                continue;
            }
            if (!(result instanceof Boolean)) {
                log.error((Object)("Failed to get boolean result from permission: " + descriptor.getName() + " (" + result + ")"));
                continue;
            }
            boolean allow = (Boolean)result;
            if (allow) continue;
            return false;
        }
        return true;
    }

    protected void addCacheControlHeaders(HttpServletRequest request, HttpServletResponse response) {
        String userAgent = request.getHeader("User-Agent");
        boolean secure = request.isSecure();
        if (!secure) {
            String nvh = request.getHeader(NUXEO_VIRTUAL_HOST);
            if (nvh == null) {
                nvh = Framework.getProperty((String)VH_PARAM);
            }
            if (nvh != null) {
                secure = nvh.startsWith("https");
            }
        }
        if (userAgent != null && userAgent.contains("MSIE") && (secure || DownloadServiceImpl.forceNoCacheOnMSIE())) {
            String cacheControl = "max-age=15, must-revalidate";
            log.debug((Object)("Setting Cache-Control: " + cacheControl));
            response.setHeader("Cache-Control", cacheControl);
        }
    }

    protected static boolean forceNoCacheOnMSIE() {
        return Framework.isBooleanPropertyTrue((String)FORCE_NO_CACHE_ON_MSIE);
    }

    @Override
    public void logDownload(DocumentModel doc, String xpath, String filename, String reason, Map<String, Serializable> extendedInfos) {
        EventContextImpl ctx;
        if ("webengine".equals(reason)) {
            return;
        }
        EventService eventService = (EventService)Framework.getService(EventService.class);
        if (eventService == null) {
            return;
        }
        if (doc != null) {
            CoreSession session = doc.getCoreSession();
            Object principal = session == null ? DownloadServiceImpl.getPrincipal() : session.getPrincipal();
            ctx = new DocumentEventContext(session, (Principal)principal, doc);
            ctx.setProperty("repositoryName", (Serializable)((Object)doc.getRepositoryName()));
            ctx.setProperty("sessionId", (Serializable)((Object)doc.getSessionId()));
        } else {
            ctx = new EventContextImpl(null, (Principal)DownloadServiceImpl.getPrincipal());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blobXPath", xpath);
        map.put("blobFilename", filename);
        map.put("downloadReason", reason);
        if (extendedInfos != null) {
            map.putAll(extendedInfos);
        }
        ctx.setProperty("extendedInfos", (Serializable)map);
        ctx.setProperty("comment", (Serializable)((Object)filename));
        Event event = ctx.newEvent("download");
        eventService.fireEvent(event);
    }

    protected static NuxeoPrincipal getPrincipal() {
        return ClientLoginModule.getCurrentPrincipal();
    }

    public static class DownloadPermissionRegistry
    extends SimpleContributionRegistry<DownloadPermissionDescriptor> {
        public String getContributionId(DownloadPermissionDescriptor contrib) {
            return contrib.getName();
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public DownloadPermissionDescriptor clone(DownloadPermissionDescriptor orig) {
            return new DownloadPermissionDescriptor(orig);
        }

        public void merge(DownloadPermissionDescriptor src, DownloadPermissionDescriptor dst) {
            dst.merge(src);
        }

        public DownloadPermissionDescriptor getDownloadPermissionDescriptor(String id) {
            return (DownloadPermissionDescriptor)this.getCurrentContribution(id);
        }

        public List<DownloadPermissionDescriptor> getDownloadPermissionDescriptors() {
            ArrayList<DownloadPermissionDescriptor> descriptors = new ArrayList<DownloadPermissionDescriptor>(this.currentContribs.values());
            Collections.sort(descriptors);
            return descriptors;
        }
    }

    protected static enum Action {
        DOWNLOAD,
        DOWNLOAD_FROM_DOC,
        INFO,
        BLOBSTATUS;

    }
}

