/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.MaxDepthReachedException;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelJsonWriter
extends ExtensibleEntityJsonWriter<DocumentModel> {
    public static final String ENTITY_TYPE = "document";
    public static final String DOCUMENT_JSON_FETCH_HEAVY_KEY = "nuxeo.document.json.fetch.heavy";
    private static Boolean FETCH_HEAVY_VALUES = null;
    @Inject
    private SchemaManager schemaManager;

    private static boolean fetchHeavy() {
        if (FETCH_HEAVY_VALUES == null) {
            try {
                FETCH_HEAVY_VALUES = Framework.isBooleanPropertyTrue((String)DOCUMENT_JSON_FETCH_HEAVY_KEY);
            }
            catch (Exception e) {
                FETCH_HEAVY_VALUES = false;
            }
        }
        return FETCH_HEAVY_VALUES;
    }

    private boolean mustFetch(String name) {
        return this.ctx.getFetched(ENTITY_TYPE).contains(name) || DocumentModelJsonWriter.fetchHeavy();
    }

    public DocumentModelJsonWriter() {
        super(ENTITY_TYPE, DocumentModel.class);
    }

    @Override
    protected void writeEntityBody(DocumentModel doc, JsonGenerator jg) throws IOException {
        block22: {
            Calendar cal;
            Lock lock;
            jg.writeStringField("repository", doc.getRepositoryName());
            jg.writeStringField("uid", doc.getId());
            jg.writeStringField("path", doc.getPathAsString());
            jg.writeStringField("type", doc.getType());
            jg.writeStringField("state", doc.getRef() != null ? doc.getCurrentLifeCycleState() : null);
            jg.writeStringField("parentRef", doc.getParentRef() != null ? doc.getParentRef().toString() : null);
            jg.writeBooleanField("isCheckedOut", doc.isCheckedOut());
            jg.writeBooleanField("isVersion", doc.isVersion());
            jg.writeBooleanField("isProxy", doc.isProxy());
            jg.writeStringField("changeToken", doc.getChangeToken());
            jg.writeStringField("title", doc.getTitle());
            if (this.mustFetch("versionLabel")) {
                String versionLabel = doc.getVersionLabel();
                jg.writeStringField("versionLabel", versionLabel != null ? versionLabel : "");
            }
            if (this.mustFetch("lock") && (lock = doc.getLockInfo()) != null) {
                jg.writeStringField("lockOwner", lock.getOwner());
                jg.writeStringField("lockCreated", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)lock.getCreated())));
            }
            if (doc.hasSchema("dublincore") && (cal = (Calendar)doc.getPropertyValue("dc:modified")) != null) {
                jg.writeStringField("lastModified", DateParser.formatW3CDateTime((Date)cal.getTime()));
            }
            try (Closeable resource = this.ctx.wrap().controlDepth().open();){
                Set<String> schemas = this.ctx.getProperties();
                if (schemas.size() <= 0) break block22;
                jg.writeObjectFieldStart("properties");
                if (schemas.contains("*")) {
                    for (String schema : doc.getSchemas()) {
                        this.writeSchemaProperties(jg, doc, schema);
                    }
                } else {
                    for (String schema : schemas) {
                        if (!doc.hasSchema(schema)) continue;
                        this.writeSchemaProperties(jg, doc, schema);
                    }
                }
                jg.writeEndObject();
            }
            catch (MaxDepthReachedException maxDepthReachedException) {
                // empty catch block
            }
        }
        jg.writeArrayFieldStart("facets");
        for (String facet : doc.getFacets()) {
            jg.writeString(facet);
        }
        jg.writeEndArray();
    }

    private void writeSchemaProperties(JsonGenerator jg, DocumentModel doc, String schemaName) throws IOException {
        Writer<Property> propertyWriter = this.registry.getWriter(this.ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
        try (Closeable resource = this.ctx.wrap().with(ENTITY_TYPE, doc).open();){
            Schema schema = this.schemaManager.getSchema(schemaName);
            String prefix = schema.getNamespace().prefix;
            if (prefix == null || prefix.length() == 0) {
                prefix = schemaName;
            }
            prefix = prefix + ":";
            for (Field field : schema.getFields()) {
                String prefixedName = prefix + field.getName().getLocalName();
                jg.writeFieldName(prefixedName);
                Property property = doc.getProperty(prefixedName);
                OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                propertyWriter.write(property, Property.class, (Type)((Object)Property.class), MediaType.APPLICATION_JSON_TYPE, out);
            }
        }
    }
}

