/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;

@XObject(value="renditionDefinition")
public class RenditionDefinition {
    public static final String DEFAULT_SOURCE_DOCUMENT_MODIFICATION_DATE_PROPERTY_NAME = "dc:modified";
    @XNode(value="@name")
    protected String name;
    @XNode(value="@cmisName")
    protected String cmisName;
    @XNode(value="@enabled")
    protected Boolean enabled;
    @XNode(value="label")
    protected String label;
    @XNode(value="icon")
    protected String icon;
    @XNode(value="kind")
    protected String kind;
    @XNode(value="operationChain")
    protected String operationChain;
    @XNode(value="allowEmptyBlob")
    protected Boolean allowEmptyBlob;
    @XNode(value="@visible")
    protected Boolean visible;
    @XNode(value="@class")
    protected Class<? extends RenditionProvider> providerClass;
    protected RenditionProvider provider;
    @XNode(value="contentType")
    protected String contentType;
    @XNodeList(value="filters/filter-id", type=ArrayList.class, componentType=String.class)
    protected List<String> filterIds;
    @XNode(value="sourceDocumentModificationDatePropertyName")
    protected String sourceDocumentModificationDatePropertyName;
    @XNode(value="storeByDefault")
    protected Boolean storeByDefault;
    @XNode(value="variantPolicy")
    protected String variantPolicy;

    private static boolean defaultTrue(Boolean bool) {
        return !Boolean.FALSE.equals(bool);
    }

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCmisName() {
        return this.cmisName;
    }

    public void setCmisName(String cmisName) {
        this.cmisName = cmisName;
    }

    public boolean isEnabled() {
        return RenditionDefinition.defaultTrue(this.enabled);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getOperationChain() {
        return this.operationChain;
    }

    public void setOperationChain(String operationChain) {
        this.operationChain = operationChain;
    }

    public boolean isEmptyBlobAllowed() {
        return RenditionDefinition.defaultFalse(this.allowEmptyBlob);
    }

    public void setAllowEmptyBlob(boolean allowEmptyBlob) {
        this.allowEmptyBlob = allowEmptyBlob;
    }

    public boolean isVisible() {
        return RenditionDefinition.defaultTrue(this.visible);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Class<? extends RenditionProvider> getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(Class<? extends RenditionProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public RenditionProvider getProvider() {
        return this.provider;
    }

    public String getProviderType() {
        RenditionProvider provider = this.getProvider();
        if (provider == null) {
            return null;
        }
        return provider.getClass().getSimpleName();
    }

    public void setProvider(RenditionProvider provider) {
        this.provider = provider;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<String> getFilterIds() {
        return this.filterIds;
    }

    public void setFilterIds(List<String> filterIds) {
        this.filterIds = filterIds;
    }

    public String getSourceDocumentModificationDatePropertyName() {
        return StringUtils.defaultString((String)this.sourceDocumentModificationDatePropertyName, (String)DEFAULT_SOURCE_DOCUMENT_MODIFICATION_DATE_PROPERTY_NAME);
    }

    public void setSourceDocumentModificationDatePropertyName(String sourceDocumentModificationDatePropertyName) {
        this.sourceDocumentModificationDatePropertyName = sourceDocumentModificationDatePropertyName;
    }

    public boolean isStoreByDefault() {
        return RenditionDefinition.defaultFalse(this.storeByDefault);
    }

    public void setStoreByDefault(boolean storeByDefault) {
        this.storeByDefault = storeByDefault;
    }

    public String getVariantPolicy() {
        return this.variantPolicy;
    }

    public RenditionDefinition() {
    }

    public RenditionDefinition(RenditionDefinition other) {
        this.name = other.name;
        this.cmisName = other.cmisName;
        this.enabled = other.enabled;
        this.label = other.label;
        this.icon = other.icon;
        this.kind = other.kind;
        this.operationChain = other.operationChain;
        this.allowEmptyBlob = other.allowEmptyBlob;
        this.visible = other.visible;
        this.providerClass = other.providerClass;
        this.contentType = other.contentType;
        this.filterIds = other.filterIds == null ? null : new ArrayList<String>(other.filterIds);
        this.sourceDocumentModificationDatePropertyName = other.sourceDocumentModificationDatePropertyName;
        this.storeByDefault = other.storeByDefault;
        this.variantPolicy = other.variantPolicy;
    }

    public void merge(RenditionDefinition other) {
        if (other.cmisName != null) {
            this.cmisName = other.cmisName;
        }
        if (other.enabled != null) {
            this.enabled = other.enabled;
        }
        if (other.label != null) {
            this.label = other.label;
        }
        if (other.icon != null) {
            this.icon = other.icon;
        }
        if (other.operationChain != null) {
            this.operationChain = other.operationChain;
        }
        if (other.allowEmptyBlob != null) {
            this.allowEmptyBlob = other.allowEmptyBlob;
        }
        if (other.visible != null) {
            this.visible = other.visible;
        }
        if (other.providerClass != null) {
            this.providerClass = other.providerClass;
        }
        if (other.contentType != null) {
            this.contentType = other.contentType;
        }
        if (other.filterIds != null) {
            if (this.filterIds == null) {
                this.filterIds = new ArrayList<String>();
            }
            this.filterIds.addAll(other.filterIds);
        }
        if (other.sourceDocumentModificationDatePropertyName != null) {
            this.sourceDocumentModificationDatePropertyName = other.sourceDocumentModificationDatePropertyName;
        }
        if (other.storeByDefault != null) {
            this.storeByDefault = other.storeByDefault;
        }
        if (other.variantPolicy != null) {
            this.variantPolicy = other.variantPolicy;
        }
    }
}

