/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.security.Principal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public abstract class UnrestrictedSessionRunner {
    protected String originatingUsername;
    protected CoreSession session;
    protected final boolean sessionIsAlreadyUnrestricted;
    protected final String repositoryName;
    public boolean isUnrestricted;

    protected UnrestrictedSessionRunner(CoreSession session) {
        this.session = session;
        this.sessionIsAlreadyUnrestricted = this.isUnrestricted(session);
        this.repositoryName = this.sessionIsAlreadyUnrestricted ? null : session.getRepositoryName();
        Principal pal = session.getPrincipal();
        if (pal != null) {
            this.originatingUsername = pal.getName();
        }
    }

    protected UnrestrictedSessionRunner(String repositoryName) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
    }

    protected UnrestrictedSessionRunner(String repositoryName, String originatingUser) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
        this.originatingUsername = originatingUser;
    }

    public String getOriginatingUsername() {
        return this.originatingUsername;
    }

    public void setOriginatingUsername(String originatingUsername) {
        this.originatingUsername = originatingUsername;
    }

    protected boolean isUnrestricted(CoreSession session) {
        return "system".equals(session.getPrincipal().getName()) || session.getPrincipal() instanceof NuxeoPrincipal && ((NuxeoPrincipal)session.getPrincipal()).isAdministrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnrestricted() {
        this.isUnrestricted = true;
        try {
            LoginContext loginContext;
            if (this.sessionIsAlreadyUnrestricted) {
                this.run();
                return;
            }
            try {
                loginContext = Framework.loginAs((String)this.originatingUsername);
            }
            catch (LoginException e) {
                throw new NuxeoException(e);
            }
            try {
                CoreSession baseSession = this.session;
                this.session = CoreInstance.openCoreSession(this.repositoryName);
                try {
                    this.run();
                }
                finally {
                    try {
                        this.session.close();
                    }
                    finally {
                        this.session = baseSession;
                    }
                }
            }
            finally {
                try {
                    if (loginContext != null) {
                        loginContext.logout();
                    }
                }
                catch (LoginException e) {
                    throw new NuxeoException(e);
                }
            }
        }
        finally {
            this.isUnrestricted = false;
        }
    }

    public abstract void run();
}

