/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;

public class BinaryBlobProvider
implements BlobProvider {
    private static final Log log = LogFactory.getLog(BinaryBlobProvider.class);
    protected final BinaryManager binaryManager;
    protected boolean supportsUserUpdate;

    public BinaryBlobProvider(BinaryManager binaryManager) {
        this.binaryManager = binaryManager;
    }

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        this.binaryManager.initialize(blobProviderId, properties);
        this.supportsUserUpdate = this.supportsUserUpdateDefaultTrue(properties);
    }

    @Override
    public boolean supportsUserUpdate() {
        return this.supportsUserUpdate;
    }

    protected boolean supportsUserUpdateDefaultTrue(Map<String, String> properties) {
        return !Boolean.parseBoolean(properties.get("preventUserUpdate"));
    }

    @Override
    public void close() {
        this.binaryManager.close();
    }

    @Override
    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    @Override
    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        long length;
        Binary binary;
        String digest = blobInfo.key;
        int colon = digest.indexOf(58);
        if (colon >= 0) {
            digest = digest.substring(colon + 1);
        }
        if ((binary = this.binaryManager.getBinary(digest)) == null) {
            throw new IOException("Unknown binary: " + digest);
        }
        if (blobInfo.length == null) {
            log.debug((Object)("Missing blob length for: " + blobInfo.key));
            File file = binary.getFile();
            length = file == null ? -1L : file.length();
        } else {
            length = blobInfo.length;
        }
        return new BinaryBlob(binary, blobInfo.key, blobInfo.filename, blobInfo.mimeType, blobInfo.encoding, blobInfo.digest, length);
    }

    @Override
    public String writeBlob(Blob blob) throws IOException {
        return this.binaryManager.getBinary(blob).getDigest();
    }
}

