/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoGroupJsonWriter
extends ExtensibleEntityJsonWriter<NuxeoGroup> {
    public static final String ENTITY_TYPE = "group";
    public static final String MEMBER_USERS_FETCH_PROPERTY = "memberUsers";
    public static final String MEMBER_GROUPS_FETCH_PROPERTY = "memberGroups";
    public static final String PARENT_GROUPS_FETCH_PROPERTY = "parentGroups";
    public static final String GROUP_NAME_COMPATIBILITY_FIELD = "groupname";
    public static final String GROUP_LABEL_COMPATIBILITY_FIELD = "grouplabel";
    @Inject
    private UserManager userManager;

    public NuxeoGroupJsonWriter() {
        super(ENTITY_TYPE, NuxeoGroup.class);
    }

    protected void writeEntityBody(NuxeoGroup group, JsonGenerator jg) throws IOException {
        jg.writeStringField(GROUP_NAME_COMPATIBILITY_FIELD, group.getName());
        jg.writeStringField(GROUP_LABEL_COMPATIBILITY_FIELD, group.getLabel());
        jg.writeStringField("id", group.getName());
        this.writeProperties(group, jg);
        this.writeMemberUsers(group, jg);
        this.writeMemberGroups(group, jg);
        this.writeParentGroups(group, jg);
    }

    protected void writeProperties(NuxeoGroup group, JsonGenerator jg) throws IOException {
        DocumentModel doc = group.getModel();
        if (doc == null) {
            return;
        }
        String groupSchema = this.userManager.getGroupSchemaName();
        Collection properties = doc.getPropertyObjects(groupSchema);
        if (properties.isEmpty()) {
            return;
        }
        List<String> excludedProperties = Arrays.asList(this.userManager.getGroupMembersField(), this.userManager.getGroupSubGroupsField(), this.userManager.getGroupParentGroupsField());
        Writer propertyWriter = this.registry.getWriter(this.ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
        jg.writeObjectFieldStart("properties");
        for (Property property : properties) {
            String localName = property.getField().getName().getLocalName();
            if (excludedProperties.contains(localName)) continue;
            jg.writeFieldName(localName);
            OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
            propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
        }
        jg.writeEndObject();
    }

    protected void writeMemberUsers(NuxeoGroup group, JsonGenerator jg) throws IOException {
        if (this.ctx.getFetched(ENTITY_TYPE).contains(MEMBER_USERS_FETCH_PROPERTY)) {
            jg.writeArrayFieldStart(MEMBER_USERS_FETCH_PROPERTY);
            for (String user : group.getMemberUsers()) {
                jg.writeString(user);
            }
            jg.writeEndArray();
        }
    }

    protected void writeMemberGroups(NuxeoGroup group, JsonGenerator jg) throws IOException {
        if (this.ctx.getFetched(ENTITY_TYPE).contains(MEMBER_GROUPS_FETCH_PROPERTY)) {
            jg.writeArrayFieldStart(MEMBER_GROUPS_FETCH_PROPERTY);
            for (String user : group.getMemberGroups()) {
                jg.writeString(user);
            }
            jg.writeEndArray();
        }
    }

    protected void writeParentGroups(NuxeoGroup group, JsonGenerator jg) throws IOException {
        if (this.ctx.getFetched(ENTITY_TYPE).contains(PARENT_GROUPS_FETCH_PROPERTY)) {
            jg.writeArrayFieldStart(PARENT_GROUPS_FETCH_PROPERTY);
            for (String user : group.getParentGroups()) {
                jg.writeString(user);
            }
            jg.writeEndArray();
        }
    }
}

