/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;

public class ElasticSearchFilter
implements Filter {
    public static final String ES_SYNC_FLAG = "nx_es_sync";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean esSync = Boolean.parseBoolean(httpRequest.getHeader(ES_SYNC_FLAG));
        if (!esSync) {
            chain.doFilter(request, response);
            return;
        }
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        try {
            chain.doFilter(request, response);
        }
        finally {
            ElasticSearchInlineListener.useSyncIndexing.set(false);
        }
    }

    public void destroy() {
    }
}

