/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.range.date.DateRangeAggregationBuilder;
import org.joda.time.DateTime;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRangeDate;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class DateRangeAggregate
extends AggregateEsBase<BucketRangeDate> {
    public DateRangeAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public DateRangeAggregationBuilder getEsAggregate() {
        DateRangeAggregationBuilder ret = (DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)this.getId()).field(this.getField());
        for (AggregateRangeDateDefinition range : this.getDateRanges()) {
            if (range.getFromAsString() != null) {
                if (range.getToAsString() != null) {
                    ret.addRange(range.getKey(), range.getFromAsString(), range.getToAsString());
                    continue;
                }
                ret.addUnboundedFrom(range.getKey(), range.getFromAsString());
                continue;
            }
            if (range.getToAsString() == null) continue;
            ret.addUnboundedTo(range.getKey(), range.getToAsString());
        }
        Map props = this.getProperties();
        if (props.containsKey("format")) {
            ret.format((String)props.get("format"));
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        BoolQueryBuilder ret = QueryBuilders.boolQuery();
        for (AggregateRangeDateDefinition range : this.getDateRanges()) {
            if (!this.getSelection().contains(range.getKey())) continue;
            RangeQueryBuilder rangeFilter = QueryBuilders.rangeQuery((String)this.getField());
            if (range.getFromAsString() != null) {
                rangeFilter.gte((Object)range.getFromAsString());
            }
            if (range.getToAsString() != null) {
                rangeFilter.lt((Object)range.getToAsString());
            }
            ret.should((QueryBuilder)rangeFilter);
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketRangeDate> nxBuckets = new ArrayList<BucketRangeDate>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            Range.Bucket rangeBucket = (Range.Bucket)bucket;
            nxBuckets.add(new BucketRangeDate(bucket.getKeyAsString(), (DateTime)rangeBucket.getFrom(), (DateTime)rangeBucket.getTo(), rangeBucket.getDocCount()));
        }
        nxBuckets.sort(new BucketRangeDateComparator());
        this.buckets = nxBuckets;
    }

    protected class BucketRangeDateComparator
    implements Comparator<BucketRangeDate> {
        protected BucketRangeDateComparator() {
        }

        @Override
        public int compare(BucketRangeDate arg0, BucketRangeDate arg1) {
            return ((Integer)DateRangeAggregate.this.definition.getAggregateDateRangeDefinitionOrderMap().get(arg0.getKey())).compareTo((Integer)DateRangeAggregate.this.definition.getAggregateDateRangeDefinitionOrderMap().get(arg1.getKey()));
        }
    }
}

