/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketTerm;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class TermAggregate
extends AggregateEsBase<BucketTerm> {
    public TermAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public TermsAggregationBuilder getEsAggregate() {
        TermsAggregationBuilder ret = (TermsAggregationBuilder)AggregationBuilders.terms((String)this.getId()).field(this.getField());
        Map props = this.getProperties();
        if (props.containsKey("size")) {
            ret.size(this.getAggSize((String)props.get("size")));
        }
        if (props.containsKey("minDocCount")) {
            ret.minDocCount(Long.parseLong((String)props.get("minDocCount")));
        }
        if (props.containsKey("exclude") || props.containsKey("include")) {
            String include = (String)props.get("include");
            String exclude = (String)props.get("exclude");
            ret.includeExclude(new IncludeExclude(include, exclude));
        }
        if (props.containsKey("order")) {
            switch (((String)props.get("order")).toLowerCase()) {
                case "count desc": {
                    ret.order(Terms.Order.count((boolean)false));
                    break;
                }
                case "count asc": {
                    ret.order(Terms.Order.count((boolean)true));
                    break;
                }
                case "term desc": {
                    ret.order(Terms.Order.term((boolean)false));
                    break;
                }
                case "term asc": {
                    ret.order(Terms.Order.term((boolean)true));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid order: " + (String)props.get("order"));
                }
            }
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return QueryBuilders.termsQuery((String)this.getField(), (Collection)this.getSelection());
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketTerm> nxBuckets = new ArrayList<BucketTerm>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            nxBuckets.add(new BucketTerm(bucket.getKeyAsString(), bucket.getDocCount()));
        }
        this.buckets = nxBuckets;
    }
}

