/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESClient;

public class ESRestClient
implements ESClient {
    private static final Log log = LogFactory.getLog(ESRestClient.class);
    protected RestClient lowLevelClient;
    protected RestHighLevelClient client;

    public ESRestClient(RestClient lowLevelRestClient, RestHighLevelClient client) {
        this.lowLevelClient = lowLevelRestClient;
        this.client = client;
    }

    @Override
    public boolean waitForYellowStatus(String[] indexNames, int timeoutSecond) {
        ClusterHealthStatus healthStatus;
        Response response;
        try {
            response = this.lowLevelClient.performRequest("GET", String.format("/_cluster/health/%s?wait_for_status=yellow&timeout=%ds", this.getIndexesAsString(indexNames), timeoutSecond), new Header[0]);
            try (InputStream is = response.getEntity().getContent();){
                Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
                healthStatus = ClusterHealthStatus.fromString((String)((String)map.get("status")));
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        switch (healthStatus) {
            case GREEN: {
                log.info((Object)("Elasticsearch Cluster ready: " + response));
                return true;
            }
            case YELLOW: {
                log.warn((Object)("Elasticsearch Cluster ready but not GREEN: " + response));
                return false;
            }
        }
        String error = "Elasticsearch Cluster health status: " + healthStatus + ", not Yellow after " + timeoutSecond + " give up: " + response;
        throw new IllegalStateException(error);
    }

    protected String getIndexesAsString(String[] indexNames) {
        return indexNames == null ? "" : String.join((CharSequence)",", indexNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClusterHealthStatus getHealthStatus(String[] indexNames) {
        try {
            Response response = this.lowLevelClient.performRequest("GET", String.format("/_cluster/health/%s", this.getIndexesAsString(indexNames)), new Header[0]);
            try (InputStream is = response.getEntity().getContent();){
                Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
                ClusterHealthStatus clusterHealthStatus = ClusterHealthStatus.fromString((String)((String)map.get("status")));
                return clusterHealthStatus;
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void refresh(String indexName) {
        try {
            this.lowLevelClient.performRequest("POST", "/" + indexName + "/_refresh", new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void flush(String indexName) {
        try {
            this.lowLevelClient.performRequest("POST", "/" + indexName + "/_flush?wait_if_ongoing=true", new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void optimize(String indexName) {
        try {
            this.lowLevelClient.performRequest("POST", "/" + indexName + "/_forcemerge?max_num_segments=1", new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public boolean indexExists(String indexName) {
        Response response;
        try {
            response = this.lowLevelClient.performRequest("HEAD", "/" + indexName, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        int code = response.getStatusLine().getStatusCode();
        if (code == 200) {
            return true;
        }
        if (code == 404) {
            return false;
        }
        throw new IllegalStateException(String.format("Checking index %s returns: %s", indexName, response));
    }

    @Override
    public boolean mappingExists(String indexName, String type) {
        Response response;
        try {
            response = this.lowLevelClient.performRequest("HEAD", String.format("/%s/_mapping/%s", indexName, type), new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        int code = response.getStatusLine().getStatusCode();
        if (code == 200) {
            return true;
        }
        if (code == 404) {
            return false;
        }
        throw new IllegalStateException(String.format("Checking mapping %s returns: %s", indexName, response));
    }

    @Override
    public void deleteIndex(String indexName, int timeoutSecond) {
        Response response;
        try {
            response = this.lowLevelClient.performRequest("DELETE", String.format("/%s?master_timeout=%ds", indexName, timeoutSecond), new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IllegalStateException(String.format("Deleting %s returns: %s", indexName, response));
        }
    }

    @Override
    public void createIndex(String indexName, String jsonSettings) {
        Response response;
        NStringEntity entity = new NStringEntity(jsonSettings, ContentType.APPLICATION_JSON);
        try {
            response = this.lowLevelClient.performRequest("PUT", "/" + indexName, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NuxeoException("Fail to create index: " + indexName + " :" + response);
        }
    }

    @Override
    public void createMapping(String indexName, String type, String jsonMapping) {
        Response response;
        NStringEntity entity = new NStringEntity(jsonMapping, ContentType.APPLICATION_JSON);
        try {
            response = this.lowLevelClient.performRequest("PUT", String.format("/%s/%s/_mapping", indexName, type), Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NuxeoException(String.format("Fail to create mapping on %s/%s: %s", indexName, type, response));
        }
    }

    @Override
    public String getNodesInfo() {
        try {
            Response response = this.lowLevelClient.performRequest("GET", "/_nodes/_all", new Header[0]);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public String getNodesStats() {
        try {
            Response response = this.lowLevelClient.performRequest("GET", "/_nodes/stats", new Header[0]);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public boolean aliasExists(String aliasName) {
        Response response;
        try {
            response = this.lowLevelClient.performRequest("HEAD", String.format("/_alias/%s", aliasName), new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        int code = response.getStatusLine().getStatusCode();
        if (code == 200) {
            return true;
        }
        if (code == 404) {
            return false;
        }
        throw new IllegalStateException(String.format("Checking alias %s returns: %s", aliasName, response));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getFirstIndexForAlias(String aliasName) {
        if (!this.aliasExists(aliasName)) {
            return null;
        }
        try {
            Response response = this.lowLevelClient.performRequest("GET", String.format("/_alias/%s", aliasName), new Header[0]);
            try (InputStream is = response.getEntity().getContent();){
                Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
                if (map.size() != 1) {
                    throw new NuxeoException(String.format("Expecting alias that point to a single index, alias: %s, got: %s", aliasName, response));
                }
                String string = (String)map.keySet().iterator().next();
                return string;
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void updateAlias(String aliasName, String indexName) {
        if (this.aliasExists(aliasName)) {
            this.deleteAlias(aliasName);
        }
        if (this.indexExists(aliasName)) {
            throw new NuxeoException("Can create an alias because an index with the same name exists: " + aliasName);
        }
        this.createAlias(aliasName, indexName);
    }

    protected void deleteAlias(String aliasName) {
        Response response;
        try {
            response = this.lowLevelClient.performRequest("DELETE", String.format("/_all/_alias/%s", aliasName), new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IllegalStateException(String.format("Deleting %s alias: %s", aliasName, response));
        }
    }

    protected void createAlias(String aliasName, String indexName) {
        Response response;
        try {
            response = this.lowLevelClient.performRequest("PUT", String.format("/%s/_alias/%s", indexName, aliasName), Collections.emptyMap(), new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NuxeoException("Fail to create alias: " + indexName + " :" + response);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest request) {
        try {
            return this.client.bulk(request, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public DeleteResponse delete(DeleteRequest request) {
        try {
            return this.client.delete(request, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        try {
            return this.client.search(request, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public SearchResponse searchScroll(SearchScrollRequest request) {
        try {
            return this.client.searchScroll(request, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public GetResponse get(GetRequest request) {
        try {
            return this.client.get(request, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public IndexResponse index(IndexRequest request) {
        try {
            return this.client.index(request, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public ClearScrollResponse clearScroll(ClearScrollRequest request) {
        try {
            return this.client.clearScroll(request, new Header[0]);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.lowLevelClient != null) {
            try {
                this.lowLevelClient.close();
            }
            catch (IOException e) {
                log.warn((Object)("Fail to close the Elasticsearch low level RestClient: " + e.getMessage()), (Throwable)e);
            }
            this.lowLevelClient = null;
        }
        this.client = null;
    }
}

