/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ESClientFactory;
import org.nuxeo.elasticsearch.client.ESRestClient;
import org.nuxeo.elasticsearch.config.ElasticSearchClientConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchEmbeddedServerConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchEmbeddedNode;

public class ESRestClientFactory
implements ESClientFactory {
    private static final Log log = LogFactory.getLog(ESRestClientFactory.class);
    public static final String DEFAULT_CONNECT_TIMEOUT_MS = "5000";
    public static final String DEFAULT_SOCKET_TIMEOUT_MS = "20000";
    public static final String CONNECTION_TIMEOUT_MS_OPT = "connection.timeout.ms";
    public static final String SOCKET_TIMEOUT_MS_OPT = "socket.timeout.ms";
    public static final String AUTH_USER_OPT = "username";
    public static final String AUTH_PASSWORD_OPT = "password";
    public static final String KEYSTORE_PATH_OPT = "keystore.path";
    public static final String KEYSTORE_PASSWORD_OPT = "keystore.password";

    @Override
    public ESClient create(ElasticSearchEmbeddedNode node, ElasticSearchClientConfig config) {
        if (node != null) {
            return this.createLocalRestClient(node.getConfig());
        }
        return this.createRestClient(config);
    }

    protected ESClient createLocalRestClient(ElasticSearchEmbeddedServerConfig serverConfig) {
        if (!serverConfig.httpEnabled()) {
            throw new IllegalArgumentException("Embedded configuration has no HTTP port enable, use TransportClient instead of Rest");
        }
        RestClient lowLevelRestClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("localhost", Integer.parseInt(serverConfig.getHttpPort()))}).build();
        RestHighLevelClient client = new RestHighLevelClient(lowLevelRestClient);
        return new ESRestClient(lowLevelRestClient, client);
    }

    protected ESClient createRestClient(ElasticSearchClientConfig config) {
        String addressList = config.getOption("addressList", "");
        if (addressList.isEmpty()) {
            throw new IllegalArgumentException("No addressList option provided cannot connect RestClient");
        }
        String[] hosts = addressList.split(",");
        HttpHost[] httpHosts = new HttpHost[hosts.length];
        int i = 0;
        for (String host : hosts) {
            httpHosts[i++] = HttpHost.create((String)host);
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.getConnectTimeoutMs(config)).setSocketTimeout(this.getSocketTimeoutMs(config))).setMaxRetryTimeoutMillis(this.getConnectTimeoutMs(config));
        if (StringUtils.isNotBlank((String)config.getOption(AUTH_USER_OPT)) || StringUtils.isNotBlank((String)config.getOption(KEYSTORE_PATH_OPT))) {
            this.addClientCallback(config, builder);
        }
        RestClient lowLevelRestClient = builder.build();
        RestHighLevelClient client = new RestHighLevelClient(lowLevelRestClient);
        return new ESRestClient(lowLevelRestClient, client);
    }

    private void addClientCallback(ElasticSearchClientConfig config, RestClientBuilder builder) {
        BasicCredentialsProvider credentialProvider = this.getCredentialProvider(config);
        SSLContext sslContext = this.getSslContext(config);
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (sslContext != null) {
                httpClientBuilder.setSSLContext(sslContext);
            }
            if (credentialProvider != null) {
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialProvider);
            }
            return httpClientBuilder;
        });
    }

    protected BasicCredentialsProvider getCredentialProvider(ElasticSearchClientConfig config) {
        if (StringUtils.isBlank((String)config.getOption(AUTH_USER_OPT))) {
            return null;
        }
        String user = config.getOption(AUTH_USER_OPT);
        String password = config.getOption(AUTH_PASSWORD_OPT);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        return credentialsProvider;
    }

    protected SSLContext getSslContext(ElasticSearchClientConfig config) {
        if (StringUtils.isBlank((String)config.getOption(KEYSTORE_PATH_OPT))) {
            return null;
        }
        try {
            Path keyStorePath = Paths.get(config.getOption(KEYSTORE_PATH_OPT), new String[0]);
            String keyStorePass = config.getOption(KEYSTORE_PASSWORD_OPT);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (InputStream is = Files.newInputStream(keyStorePath, new OpenOption[0]);){
                keyStore.load(is, keyStorePass.toCharArray());
            }
            SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(keyStore, null);
            return sslBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new NuxeoException("Cannot setup SSL for RestClient: " + config, (Throwable)e);
        }
    }

    protected int getConnectTimeoutMs(ElasticSearchClientConfig config) {
        return Integer.parseInt(config.getOption(CONNECTION_TIMEOUT_MS_OPT, DEFAULT_CONNECT_TIMEOUT_MS));
    }

    protected int getSocketTimeoutMs(ElasticSearchClientConfig config) {
        return Integer.parseInt(config.getOption(SOCKET_TIMEOUT_MS_OPT, DEFAULT_SOCKET_TIMEOUT_MS));
    }

    protected void checkConnection(RestHighLevelClient client) {
        boolean ping = false;
        try {
            ping = client.ping(new Header[0]);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!ping) {
            throw new IllegalStateException("Fail to ping rest node");
        }
    }
}

