/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ESClientFactory;
import org.nuxeo.elasticsearch.client.ESTransportClient;
import org.nuxeo.elasticsearch.config.ElasticSearchClientConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchEmbeddedNode;

public class ESTransportClientFactory
implements ESClientFactory {
    private static final Log log = LogFactory.getLog(ESTransportClientFactory.class);

    public Settings.Builder getSetting(ElasticSearchClientConfig config) {
        return Settings.builder().put("cluster.name", config.getOption("clusterName", "elasticsearch")).put("client.transport.nodes_sampler_interval", config.getOption("clientTransportNodesSamplerInterval", "5s")).put("client.transport.ping_timeout", config.getOption("clientTransportPingTimeout", "5s")).put("client.transport.ignore_cluster_name", config.getOption("clientTransportIgnoreClusterName", "false")).put("client.transport.sniff", config.getOption("clientTransportSniff", "true"));
    }

    @Override
    public ESClient create(ElasticSearchEmbeddedNode node, ElasticSearchClientConfig config) {
        log.info((Object)"Creating an Elasticsearch TransportClient");
        if (node == null) {
            return this.createRemoteClient(config);
        }
        return this.createLocalClient(node);
    }

    protected ESClient createRemoteClient(ElasticSearchClientConfig config) {
        Settings settings = this.getSetting(config).build();
        log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
        PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
        String[] addresses = config.getOption("addressList", "").split(",");
        if (addresses.length == 0) {
            throw new IllegalArgumentException("No addressList option provided cannot connect TransportClient");
        }
        for (String item : addresses) {
            String[] address = item.split(":");
            log.debug((Object)("Add transport address: " + item));
            try {
                InetAddress inet = InetAddress.getByName(address[0]);
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(inet, Integer.parseInt(address[1])));
            }
            catch (UnknownHostException e) {
                log.error((Object)("Unable to resolve host " + address[0]), (Throwable)e);
            }
        }
        return new ESTransportClient((Client)client);
    }

    protected ESClient createLocalClient(ElasticSearchEmbeddedNode node) {
        log.info((Object)"Creating a TransportClient to a local Elasticsearch");
        return new ESTransportClient(node.getNode().client());
    }
}

