/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.fetcher;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.elasticsearch.fetcher.Fetcher;
import org.nuxeo.elasticsearch.io.DocumentModelReaders;

public class EsFetcher
extends Fetcher {
    public EsFetcher(CoreSession session, SearchResponse response, Map<String, String> repoNames) {
        super(session, response, repoNames);
    }

    @Override
    public DocumentModelListImpl fetchDocuments() {
        DocumentModelListImpl ret = new DocumentModelListImpl(this.getResponse().getHits().getHits().length);
        String sid = this.getSession().getSessionId();
        for (SearchHit hit : this.getResponse().getHits()) {
            DocumentModel doc = DocumentModelReaders.fromSource(hit.getSource()).sid(sid).getDocumentModel();
            Map esHighlights = hit.getHighlightFields();
            if (!esHighlights.isEmpty()) {
                HashMap fields = new HashMap();
                for (Map.Entry entry : esHighlights.entrySet()) {
                    String field = (String)entry.getKey();
                    ArrayList<String> list = new ArrayList<String>();
                    for (Text fragment : ((HighlightField)entry.getValue()).getFragments()) {
                        list.add(fragment.toString());
                    }
                    fields.put(field, list);
                }
                doc.putContextData("highlight", (Serializable)fields);
            }
            ret.add((Object)doc);
        }
        return ret;
    }
}

