/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBComponent
extends DefaultComponent
implements MongoDBConnectionService {
    private static final Log log = LogFactory.getLog(MongoDBComponent.class);
    public static final String NAME = "org.nuxeo.runtime.mongodb.MongoDBComponent";
    private static final String EP_CONNECTION = "connection";
    private static final String DEFAULT_CONNECTION_ID = "default";
    private final MongoDBConnectionConfigRegistry registry = new MongoDBConnectionConfigRegistry();
    private final Map<String, MongoClient> clients = new ConcurrentHashMap<String, MongoClient>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "connection": {
                this.registry.addContribution((MongoDBConnectionConfig)contribution);
                log.info((Object)("Registering connection configuration: " + contribution + ", loaded from " + contributor.getName()));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid EP: " + extensionPoint);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "connection": {
                MongoDBConnectionConfig config = (MongoDBConnectionConfig)contribution;
                log.info((Object)("Unregistering connection configuration: " + config));
                this.clients.remove(config.getId()).close();
                this.registry.removeContribution(config);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid EP: " + extensionPoint);
            }
        }
    }

    public void start(ComponentContext context) {
        log.info((Object)"Activate MongoDB component");
        for (ContributionFragmentRegistry.FragmentList fragment : this.registry.getFragments()) {
            MongoDBConnectionConfig conf = (MongoDBConnectionConfig)fragment.object;
            log.debug((Object)("Initializing MongoClient with id=" + conf.getId()));
            MongoClient client = MongoDBConnectionHelper.newMongoClient(conf.getServer());
            this.clients.put(conf.getId(), client);
        }
    }

    public void stop(ComponentContext context) {
        Iterator<Map.Entry<String, MongoClient>> it = this.clients.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MongoClient> entry = it.next();
            log.debug((Object)("Closing MongoClient with id=" + entry.getKey()));
            MongoClient client = entry.getValue();
            client.close();
            it.remove();
        }
    }

    public int getApplicationStartedOrder() {
        return 99;
    }

    @Override
    public MongoDatabase getDatabase(String id) {
        MongoDBConnectionConfig config = this.registry.getCurrentContribution(id);
        MongoClient client = this.clients.get(id);
        if (client == null) {
            config = this.registry.getCurrentContribution(DEFAULT_CONNECTION_ID);
            client = this.clients.get(DEFAULT_CONNECTION_ID);
        }
        return MongoDBConnectionHelper.getDatabase(client, config.getDbname());
    }

    @Override
    public Iterable<MongoDatabase> getDatabases() {
        return () -> this.clients.entrySet().stream().map(e -> MongoDBConnectionHelper.getDatabase((MongoClient)e.getValue(), this.registry.getCurrentContribution((String)e.getKey()).getDbname())).iterator();
    }

    protected static class MongoDBConnectionConfigRegistry
    extends SimpleContributionRegistry<MongoDBConnectionConfig> {
        protected MongoDBConnectionConfigRegistry() {
        }

        public String getContributionId(MongoDBConnectionConfig contrib) {
            return contrib.getId();
        }

        public MongoDBConnectionConfig getCurrentContribution(String id) {
            return (MongoDBConnectionConfig)super.getCurrentContribution(id);
        }
    }
}

