/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoDBConnectionHelper {
    private static final Log log = LogFactory.getLog(MongoDBConnectionHelper.class);
    private static final String DB_DEFAULT = "nuxeo";
    private static final int MONGODB_OPTION_CONNECTION_TIMEOUT_MS = 30000;
    private static final int MONGODB_OPTION_SOCKET_TIMEOUT_MS = 60000;

    private MongoDBConnectionHelper() {
    }

    public static MongoClient newMongoClient(String server) {
        if (StringUtils.isBlank((CharSequence)server)) {
            throw new RuntimeException("Missing <server> in MongoDB descriptor");
        }
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder().socketKeepAlive(true).connectTimeout(30000).socketTimeout(60000).description("Nuxeo");
        MongoClient client = server.startsWith("mongodb://") ? new MongoClient(new MongoClientURI(server, optionsBuilder)) : new MongoClient(new ServerAddress(server), optionsBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoClient initialized with options: " + client.getMongoClientOptions().toString()));
        }
        return client;
    }

    public static MongoDatabase getDatabase(MongoClient mongoClient, String dbname) {
        if (StringUtils.isBlank((CharSequence)dbname)) {
            dbname = DB_DEFAULT;
        }
        return mongoClient.getDatabase(dbname);
    }

    public static boolean hasCollection(MongoDatabase mongoDatabase, String collection) {
        MongoIterable collections = mongoDatabase.listCollectionNames();
        boolean found = StreamSupport.stream(collections.spliterator(), false).anyMatch(collection::equals);
        return found && mongoDatabase.getCollection(collection).count() > 0L;
    }
}

