/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import org.nuxeo.ecm.platform.tag.BridgeTagService;
import org.nuxeo.ecm.platform.tag.FacetedTagService;
import org.nuxeo.ecm.platform.tag.RelationTagService;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class TagServiceImpl
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.tag.TagService");
    protected volatile TagService tagService;

    public int getApplicationStartedOrder() {
        Component component = (Component)Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.repository.RepositoryServiceComponent").getInstance();
        return component.getApplicationStartedOrder() - 1;
    }

    protected TagService recomputeTagService() {
        MigrationService migrationService = (MigrationService)Framework.getService(MigrationService.class);
        MigrationService.MigrationStatus status = migrationService.getStatus("tag-storage");
        if (status == null) {
            throw new IllegalStateException("Unknown migration status for: tag-storage");
        }
        if (status.isRunning()) {
            String step = status.getStep();
            if ("relations-to-facets".equals(step)) {
                return new BridgeTagService(new RelationTagService(), new FacetedTagService());
            }
            throw new IllegalStateException("Unknown migration step: " + step);
        }
        String state = status.getState();
        if ("relations".equals(state)) {
            return new RelationTagService();
        }
        if ("facets".equals(state)) {
            return new FacetedTagService();
        }
        throw new IllegalStateException("Unknown migration state: " + state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Class<T> adapter) {
        if (this.tagService == null) {
            TagServiceImpl tagServiceImpl = this;
            synchronized (tagServiceImpl) {
                if (this.tagService == null) {
                    this.tagService = this.recomputeTagService();
                }
            }
        }
        return (T)this.tagService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateTagServiceImplementation() {
        TagServiceImpl tagServiceImpl = this;
        synchronized (tagServiceImpl) {
            this.tagService = this.recomputeTagService();
        }
    }

    public static class TagServiceStatusChangeNotifier
    implements MigrationService.StatusChangeNotifier {
        public void notifyStatusChange() {
            TagServiceImpl tagService = (TagServiceImpl)((Object)Framework.getRuntime().getComponent(NAME));
            tagService.invalidateTagServiceImplementation();
        }
    }
}

