/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

public class TaggedVersionListener
implements PostCommitFilteringEventListener {
    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            if (!this.acceptEvent(event)) continue;
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            String name = event.getName();
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            CoreSession session = docCtx.getCoreSession();
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc == null) {
                return;
            }
            String docId = doc.getId();
            TagService tagService = (TagService)Framework.getService(TagService.class);
            if (doc instanceof DeletedDocumentModel && !tagService.hasFeature(TagService.Feature.TAGS_BELONG_TO_DOCUMENT)) {
                tagService.removeTags(session, docId);
                return;
            }
            switch (name) {
                case "documentProxyPublished": {
                    if (!doc.isProxy()) break;
                    DocumentModel version = session.getSourceDocument(doc.getRef());
                    tagService.copyTags(session, version.getId(), docId);
                    break;
                }
                case "documentRestored": {
                    String versionUUID = (String)((Object)ctx.getProperty("RESTORED_VERSION_UUID"));
                    tagService.replaceTags(session, versionUUID, docId);
                    break;
                }
                case "documentRemoved": {
                    if (tagService.hasFeature(TagService.Feature.TAGS_BELONG_TO_DOCUMENT)) break;
                    tagService.removeTags(session, docId);
                    break;
                }
                case "lifecycle_transition_event": {
                    tagService.removeTags(session, docId);
                    break;
                }
            }
        }
    }

    public boolean acceptEvent(Event event) {
        String name = event.getName();
        return "documentProxyPublished".equals(name) || "documentRestored".equals(name) || "documentRemoved".equals(name) || "lifecycle_transition_event".equals(name) && "deleted".equals(event.getContext().getProperty("to"));
    }
}

