/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TagsRelationsToFacetsMigrator
implements MigrationService.Migrator {
    private static final Log log = LogFactory.getLog(TagsRelationsToFacetsMigrator.class);
    protected static final int BATCH_SIZE = 50;
    protected MigrationService.MigrationContext migrationContext;

    public void run(MigrationService.MigrationContext migrationContext) {
        this.migrationContext = migrationContext;
        this.reportProgress("Initializing", 0L, -1L);
        List repositoryNames = ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
        try {
            repositoryNames.forEach(this::migrateRepository);
        }
        catch (MigrationShutdownException e) {
            return;
        }
    }

    protected void checkShutdownRequested() {
        if (this.migrationContext.isShutdownRequested()) {
            throw new MigrationShutdownException();
        }
    }

    protected void reportProgress(String message, long num, long total) {
        log.debug((Object)(message + ": " + num + "/" + total));
        this.migrationContext.reportProgress(message, num, total);
    }

    protected void migrateRepository(String repositoryName) {
        TransactionHelper.runInTransaction(() -> CoreInstance.doPrivileged((String)repositoryName, this::migrateSession));
    }

    protected void migrateSession(CoreSession session) {
        String taggingSql = "SELECT ecm:uuid, relation:source, ecm:name, dc:creator FROM Tagging WHERE ecm:isProxy = 0";
        PartialList taggingMaps = session.queryProjection(taggingSql, -1L, 0L);
        this.checkShutdownRequested();
        String tagSql = "SELECT ecm:uuid FROM Tag WHERE ecm:isProxy = 0";
        PartialList tagMaps = session.queryProjection(tagSql, -1L, 0L);
        this.checkShutdownRequested();
        HashMap<String, Set> docTags = new HashMap<String, Set>();
        for (Map map2 : taggingMaps) {
            String docId2 = (String)map2.get("relation:source");
            String label = (String)map2.get("ecm:name");
            String username = (String)map2.get("dc:creator");
            Tag tag = new Tag(label, username);
            docTags.computeIfAbsent(docId2, key -> new HashSet()).add(tag);
        }
        Set taggingIds = taggingMaps.stream().map(map -> (String)map.get("ecm:uuid")).collect(Collectors.toSet());
        Set tagIds = tagMaps.stream().map(map -> (String)map.get("ecm:uuid")).collect(Collectors.toSet());
        this.checkShutdownRequested();
        this.processBatched(docTags.entrySet(), es -> this.addTags(session, (String)es.getKey(), (Set)es.getValue()), "Creating new tags");
        this.processBatched(taggingIds, docId -> this.removeDocument(session, (String)docId), "Deleting old Tagging documents");
        this.processBatched(tagIds, docId -> this.removeDocument(session, (String)docId), "Deleting old Tag documents");
        this.reportProgress("Done", docTags.size(), docTags.size());
    }

    protected void removeDocument(CoreSession session, String docId) {
        try {
            session.removeDocument((DocumentRef)new IdRef(docId));
        }
        catch (DocumentNotFoundException e) {
            return;
        }
    }

    protected void addTags(CoreSession session, String docId, Set<Tag> tags) {
        DocumentModel doc;
        try {
            doc = session.getDocument((DocumentRef)new IdRef(docId));
        }
        catch (DocumentNotFoundException e) {
            return;
        }
        this.addTags(doc, tags);
    }

    protected void addTags(DocumentModel doc, Set<Tag> tags) {
        List tagsList;
        if (doc.isProxy()) {
            return;
        }
        try {
            tagsList = (List)((Object)doc.getPropertyValue("nxtag:tags"));
        }
        catch (PropertyNotFoundException e) {
            return;
        }
        boolean changed = false;
        for (Tag tag : tags) {
            if (!tagsList.stream().noneMatch(t -> tag.label.equals(t.get("label")))) continue;
            HashMap<String, String> tagMap = new HashMap<String, String>(2);
            tagMap.put("label", tag.label);
            tagMap.put("username", tag.username);
            tagsList.add(tagMap);
            changed = true;
        }
        if (changed) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            doc.setPropertyValue("nxtag:tags", (Serializable)((Object)tagsList));
            doc.getCoreSession().saveDocument(doc);
        }
    }

    protected <T> void processBatched(Collection<T> collection, Consumer<T> consumer, String progressMessage) {
        int size = collection.size();
        int i = -1;
        for (T element : collection) {
            consumer.accept(element);
            this.checkShutdownRequested();
            if (++i % 50 != 0 && i != size - 1) continue;
            this.reportProgress(progressMessage, i + 1, size);
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected static class MigrationShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    protected static class Tag {
        protected final String label;
        protected final String username;

        public Tag(String label, String username) {
            this.label = label;
            this.username = username;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)obj;
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            return !(this.username == null ? other.username != null : !this.username.equals(other.username));
        }

        public String toString() {
            return "Tag(" + this.label + "," + this.username + ")";
        }
    }
}

