/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.adapters.BundleGroupDocAdapter;
import org.nuxeo.apidoc.adapters.BundleInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ComponentInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ExtensionInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ExtensionPointInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ServiceInfoDocAdapter;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.api.QueryHelper;
import org.nuxeo.apidoc.repository.RepositoryDistributionSnapshot;
import org.nuxeo.apidoc.search.ArtifactSearcher;
import org.nuxeo.apidoc.search.ArtifactWithWeight;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class ArtifactSearcherImpl
implements ArtifactSearcher {
    protected static final int MAX_RESULTS = 1000;

    protected NuxeoArtifact mapDoc2Artifact(DocumentModel doc) {
        BaseNuxeoArtifactDocAdapter artifact = null;
        if (doc.getType().equals("NXBundleGroup")) {
            artifact = new BundleGroupDocAdapter(doc);
        } else if (doc.getType().equals("NXBundle")) {
            artifact = new BundleInfoDocAdapter(doc);
        } else if (doc.getType().equals("NXComponent")) {
            artifact = new ComponentInfoDocAdapter(doc);
        } else if (doc.getType().equals("NXExtensionPoint")) {
            artifact = new ExtensionPointInfoDocAdapter(doc);
        } else if (doc.getType().equals("NXContribution")) {
            artifact = new ExtensionInfoDocAdapter(doc);
        } else if (doc.getType().equals("NXDistribution")) {
            artifact = new RepositoryDistributionSnapshot(doc);
        } else if (doc.getType().equals("NXService")) {
            artifact = new ServiceInfoDocAdapter(doc);
        }
        return artifact;
    }

    @Override
    public List<NuxeoArtifact> searchArtifact(CoreSession session, String distribId, String fulltext) {
        ArrayList<NuxeoArtifact> result = new ArrayList<NuxeoArtifact>();
        DistributionSnapshot snap = ((SnapshotManager)Framework.getService(SnapshotManager.class)).getSnapshot(distribId, session);
        if (!(snap instanceof RepositoryDistributionSnapshot)) {
            return Collections.emptyList();
        }
        DocumentModel dist = ((RepositoryDistributionSnapshot)snap).getDoc();
        StrBuilder q = new StrBuilder("SELECT * FROM Document WHERE ");
        q.append("ecm:path STARTSWITH '").append(dist.getPathAsString()).append("'");
        String query = q.toString();
        if (fulltext != null) {
            query = query + " AND ecm:fulltext = " + NXQL.escapeString((String)fulltext);
        }
        ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        DocumentModelList docs = ess.query(new NxQueryBuilder(session).nxql(query).limit(1000));
        for (DocumentModel doc : docs) {
            NuxeoArtifact artifact = this.mapDoc2Artifact(doc);
            if (artifact == null) continue;
            result.add(artifact);
        }
        return result;
    }

    @Override
    public List<DocumentationItem> searchDocumentation(CoreSession session, String distribId, String fulltext, String targetType) {
        DistributionSnapshot snap = ((SnapshotManager)Framework.getService(SnapshotManager.class)).getSnapshot(distribId, session);
        DocumentModel dist = ((RepositoryDistributionSnapshot)snap).getDoc();
        String query = QueryHelper.select("NXDocumentation", dist, "ecm:fulltext", fulltext);
        if (targetType != null) {
            query = query + " AND nxdoc:targetType = " + NXQL.escapeString((String)targetType);
        }
        ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        DocumentModelList docs = ess.query(new NxQueryBuilder(session).nxql(query).limit(1000));
        ArrayList<DocumentationItem> result = new ArrayList<DocumentationItem>();
        for (DocumentModel doc : docs) {
            DocumentationItem docItem = (DocumentationItem)doc.getAdapter(DocumentationItem.class);
            if (docItem == null) continue;
            result.add(docItem);
        }
        return result;
    }

    @Override
    public List<NuxeoArtifact> filterArtifact(CoreSession session, String distribId, String type, String fulltext) {
        ArrayList<NuxeoArtifact> result = new ArrayList<NuxeoArtifact>();
        List<NuxeoArtifact> matchingArtifacts = this.searchArtifact(session, distribId, fulltext);
        List<DocumentationItem> matchingDocumentationItems = this.searchDocumentation(session, distribId, fulltext, null);
        HashMap<String, ArtifactWithWeight> sortMap = new HashMap<String, ArtifactWithWeight>();
        for (NuxeoArtifact matchingArtifact : matchingArtifacts) {
            ArtifactWithWeight artifactWithWeight;
            NuxeoArtifact matchingParentArtifact = this.resolveInTree(session, distribId, matchingArtifact, type);
            if (matchingParentArtifact != null) {
                artifactWithWeight = new ArtifactWithWeight(matchingParentArtifact);
            } else {
                if (!matchingArtifact.getArtifactType().equals(type)) continue;
                artifactWithWeight = new ArtifactWithWeight(matchingArtifact);
            }
            String id = artifactWithWeight.getArtifact().getId();
            if (sortMap.containsKey(id)) {
                ((ArtifactWithWeight)sortMap.get(id)).addHit();
                continue;
            }
            sortMap.put(id, new ArtifactWithWeight(matchingParentArtifact));
        }
        for (DocumentationItem matchingDocumentationItem : matchingDocumentationItems) {
            NuxeoArtifact resultArtifact = this.resolveInTree(session, distribId, matchingDocumentationItem, type);
            if (resultArtifact == null) continue;
            if (sortMap.containsKey(resultArtifact.getId())) {
                ((ArtifactWithWeight)sortMap.get(resultArtifact.getId())).addHit();
                continue;
            }
            sortMap.put(resultArtifact.getId(), new ArtifactWithWeight(resultArtifact));
        }
        ArrayList artifacts = new ArrayList(sortMap.values());
        Collections.sort(artifacts);
        for (ArtifactWithWeight item : artifacts) {
            result.add(item.getArtifact());
        }
        return result;
    }

    protected NuxeoArtifact resolveInTree(CoreSession session, String distribId, NuxeoArtifact matchingArtifact, String searchedType) {
        String cType = matchingArtifact.getArtifactType();
        if (cType.equals(searchedType)) {
            return matchingArtifact;
        }
        BaseNuxeoArtifactDocAdapter docAdapter = (BaseNuxeoArtifactDocAdapter)matchingArtifact;
        DocumentModel doc = docAdapter.getDoc();
        List parents = session.getParentDocuments(doc.getRef());
        Collections.reverse(parents);
        for (DocumentModel parent : parents) {
            if (!parent.getType().equals(searchedType)) continue;
            return this.mapDoc2Artifact(parent);
        }
        return null;
    }

    protected NuxeoArtifact resolveInTree(CoreSession session, String distribId, DocumentationItem matchingDocumentationItem, String searchedType) {
        DistributionSnapshot snap = ((SnapshotManager)Framework.getService(SnapshotManager.class)).getSnapshot(distribId, session);
        String targetId = matchingDocumentationItem.getTarget();
        String targetType = matchingDocumentationItem.getTargetType();
        NuxeoArtifact artifact = targetType.equals("NXBundleGroup") ? snap.getBundleGroup(targetId) : (targetType.equals("NXBundle") ? snap.getBundle(targetId) : (targetType.equals("NXComponent") ? snap.getComponent(targetId) : (targetType.equals("NXExtensionPoint") ? snap.getExtensionPoint(targetId) : (targetType.equals("NXContribution") ? snap.getContribution(targetId) : (targetType.equals("NXService") ? snap.getService(targetId) : null)))));
        return this.resolveInTree(session, distribId, artifact, searchedType);
    }
}

