/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.operations.document.AbstractOperationMultiValuedProperty;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.Type;

@Operation(id="Document.RemoveEntryOfMultivaluedProperty", category="Document", label="Remove Entry Of Multivalued Property", description="Remove the first entry of the giving value in the multivalued xpath, does nothing if does not exist: <ul<li>if 'is Remove All' is check, all entry instance in the list.</li><li>if not will remove just the first one found</li><ul>", aliases={"RemoveEntryOfMultivaluedProperty"})
public class RemoveEntryOfMultiValuedProperty
extends AbstractOperationMultiValuedProperty {
    public static final String ID = "Document.RemoveEntryOfMultivaluedProperty";
    public static final Log log = LogFactory.getLog(RemoveEntryOfMultiValuedProperty.class);
    @Context
    protected CoreSession session;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="value")
    protected Serializable value;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;
    @Param(name="is Remove All", required=false, values={"true"})
    protected boolean isRemoveAll = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws OperationException {
        Property p = doc.getProperty(this.xpath);
        Type type = p.getType();
        this.checkFieldType(type, this.value);
        List<Serializable> array = Arrays.asList((Serializable[])p.getValue());
        if (array == null) {
            log.info((Object)String.format("Value \"%s\" not found in %s, can't remove it", this.value, doc.getPathAsString()));
            return doc;
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>(array);
        if (!list.contains(this.value)) {
            log.info((Object)String.format("Value \"%s\" not found in %s, can't remove it", this.value, doc.getPathAsString()));
            return doc;
        }
        do {
            list.remove(this.value);
            p.setValue(list);
        } while (list.contains(this.value) && this.isRemoveAll);
        if (this.save) {
            doc = this.session.saveDocument(doc);
            this.session.save();
        }
        return doc;
    }
}

