/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.rendition.extension.DefaultAutomationRenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractLazyCachableRenditionProvider
extends DefaultAutomationRenditionProvider {
    public static final String SOURCE_DOCUMENT_MODIFICATION_DATE_KEY = "sourceDocumentModificationDate";
    public static final String CACHE_NAME = "LazyRenditionCache";
    protected static Log log = LogFactory.getLog(AbstractLazyCachableRenditionProvider.class);
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    @Override
    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Asking \"%s\" rendition lazy rendering for document %s (id=%s).", definition.getName(), doc.getPathAsString(), doc.getId()));
        }
        String key = this.buildRenditionKey(doc, definition);
        String sourceDocumentModificationDate = this.getSourceDocumentModificationDate(doc, definition);
        List blobs = null;
        TransientStore ts = this.getTransientStore();
        if (!ts.exists(key)) {
            blobs = this.handleNewRendition(key, doc, definition, sourceDocumentModificationDate);
        } else {
            String storedSourceDocumentModificationDate = (String)((Object)ts.getParameter(key, SOURCE_DOCUMENT_MODIFICATION_DATE_KEY));
            blobs = ts.getBlobs(key);
            if (ts.isCompleted(key)) {
                this.handleCompletedRendition(key, doc, definition, sourceDocumentModificationDate, storedSourceDocumentModificationDate, blobs);
            } else {
                this.handleIncompleteRendition(key, doc, definition, sourceDocumentModificationDate, storedSourceDocumentModificationDate);
            }
        }
        if (log.isDebugEnabled()) {
            String blobInfo = null;
            if (blobs != null) {
                blobInfo = blobs.stream().map(blob -> String.format("{filename=%s, MIME type=%s}", blob.getFilename(), blob.getMimeType())).collect(Collectors.joining(",", "[", "]"));
            }
            log.debug((Object)String.format("Returning blobs: %s.", blobInfo));
        }
        return blobs;
    }

    public String buildRenditionKey(DocumentModel doc, RenditionDefinition def) {
        StringBuilder sb = new StringBuilder(doc.getId());
        sb.append("::");
        String variant = this.getVariant(doc, def);
        if (variant != null) {
            sb.append(variant);
            sb.append("::");
        }
        sb.append(def.getName());
        String key = this.getDigest(sb.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Built rendition key for document %s (id=%s): %s.", doc.getPathAsString(), doc.getId(), key));
        }
        return key;
    }

    public String getSourceDocumentModificationDate(DocumentModel doc, RenditionDefinition definition) {
        String modificationDatePropertyName = definition.getSourceDocumentModificationDatePropertyName();
        Calendar modificationDate = (Calendar)doc.getPropertyValue(modificationDatePropertyName);
        if (modificationDate == null) {
            return null;
        }
        long millis = modificationDate.getTimeInMillis();
        millis -= millis % 1000L;
        return String.valueOf(millis);
    }

    protected String getDigest(String key) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return key;
        }
        byte[] buf = digest.digest(key.getBytes());
        return this.toHexString(buf);
    }

    protected String toHexString(byte[] data) {
        StringBuilder buf = new StringBuilder(2 * data.length);
        for (byte b : data) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    protected TransientStore getTransientStore() {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(CACHE_NAME);
        if (ts == null) {
            throw new NuxeoException("Unable to find Transient Store  LazyRenditionCache");
        }
        return ts;
    }

    protected List<Blob> handleNewRendition(String key, DocumentModel doc, RenditionDefinition definition, String sourceDocumentModificationDate) {
        Work work = this.getRenditionWork(key, doc, definition);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("No entry found for key %s in the %s transient store, scheduling rendition work with id %s and storing an empty blob for now.", key, CACHE_NAME, work.getId()));
        }
        if (sourceDocumentModificationDate != null) {
            this.getTransientStore().putParameter(key, SOURCE_DOCUMENT_MODIFICATION_DATE_KEY, (Serializable)((Object)sourceDocumentModificationDate));
        }
        StringBlob emptyBlob = new StringBlob("");
        emptyBlob.setFilename("inprogress");
        emptyBlob.setMimeType("text/plain;empty=true");
        this.getTransientStore().putBlobs(key, Collections.singletonList(emptyBlob));
        ((WorkManager)Framework.getService(WorkManager.class)).schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED);
        return Collections.singletonList(emptyBlob);
    }

    protected void handleCompletedRendition(String key, DocumentModel doc, RenditionDefinition definition, String sourceDocumentModificationDate, String storedSourceDocumentModificationDate, List<Blob> blobs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Completed entry found for key %s in the %s transient store.", key, CACHE_NAME));
        }
        if (blobs == null || blobs.size() != 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No (or more than one) rendition blob for key %s, releasing entry from the transient store.", key));
            }
            this.getTransientStore().release(key);
            return;
        }
        Blob blob = blobs.get(0);
        String mimeType = blob.getMimeType();
        if (mimeType != null && mimeType.contains("error=true")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Rendition blob is in error for key %s.", key));
            }
            if (Objects.equals(storedSourceDocumentModificationDate, sourceDocumentModificationDate)) {
                log.debug((Object)"Removing entry from the transient store.");
                this.getTransientStore().remove(key);
                return;
            }
            Work work = this.getRenditionWork(key, doc, definition);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Source document modification date %s is different from the stored one %s, scheduling rendition work with id %s and returning an error/stale rendition.", sourceDocumentModificationDate, storedSourceDocumentModificationDate, work.getId()));
            }
            if (sourceDocumentModificationDate != null) {
                this.getTransientStore().putParameter(key, SOURCE_DOCUMENT_MODIFICATION_DATE_KEY, (Serializable)((Object)sourceDocumentModificationDate));
            }
            ((WorkManager)Framework.getService(WorkManager.class)).schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED);
            blob.setMimeType(blob.getMimeType() + ";" + "stale=true");
            return;
        }
        if (Objects.equals(storedSourceDocumentModificationDate, sourceDocumentModificationDate)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Rendition blob is up-to-date for key %s, returning it and releasing entry from the transient store.", key));
            }
            this.getTransientStore().release(key);
            return;
        }
        Work work = this.getRenditionWork(key, doc, definition);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Source document modification date %s is different from the stored one %s, scheduling rendition work with id %s and returning a stale rendition.", sourceDocumentModificationDate, storedSourceDocumentModificationDate, work.getId()));
        }
        if (sourceDocumentModificationDate != null) {
            this.getTransientStore().putParameter(key, SOURCE_DOCUMENT_MODIFICATION_DATE_KEY, (Serializable)((Object)sourceDocumentModificationDate));
        }
        ((WorkManager)Framework.getService(WorkManager.class)).schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED);
        blob.setMimeType(blob.getMimeType() + ";" + "stale=true");
    }

    protected void handleIncompleteRendition(String key, DocumentModel doc, RenditionDefinition definition, String sourceDocumentModificationDate, String storedSourceDocumentModificationDate) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Incomplete entry found for key %s in the %s transient store.", key, CACHE_NAME));
        }
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        Work work = this.getRenditionWork(key, doc, definition);
        String workId = work.getId();
        boolean scheduleWork = false;
        if (Objects.equals(storedSourceDocumentModificationDate, sourceDocumentModificationDate)) {
            Work existingWork = workManager.find(workId, null);
            if (existingWork == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found no existing work with id %s.", workId));
                }
                scheduleWork = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found an existing work with id %s in sate %s.", workId, existingWork.getWorkInstanceState()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Source document modification date %s is different from the stored one %s.", sourceDocumentModificationDate, storedSourceDocumentModificationDate));
            }
            if (sourceDocumentModificationDate != null) {
                this.getTransientStore().putParameter(key, SOURCE_DOCUMENT_MODIFICATION_DATE_KEY, (Serializable)((Object)sourceDocumentModificationDate));
            }
            scheduleWork = true;
        }
        if (scheduleWork) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Scheduling rendition work with id %s.", workId));
            }
            workManager.schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED);
        }
    }

    protected abstract Work getRenditionWork(String var1, DocumentModel var2, RenditionDefinition var3);
}

