/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.operation;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.core.adapter.Collection;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.utils.BlobUtils;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;

@Operation(id="Document.GetContainerRendition", category="Files", label="Gets the folder's children or the collection's members default renditions", description="Gets the list of blob of the folder's children or the collection's members default renditions. Returns a blob list file containing all the default rendition blobs.")
public class GetContainerRendition {
    private static final Log log = LogFactory.getLog(GetContainerRendition.class);
    public static final String ID = "Document.GetContainerRendition";
    @Context
    protected RenditionService renditionService;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="reason", required=false)
    protected String reason;
    @Param(name="limit", description="Limit of members to be returned. Default is 100.", required=false)
    protected int limit = 100;
    @Param(name="maxDepth", description="Depth of the hierarchy to be explored. Default is 1.", required=false)
    protected int maxDepth = 1;
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;

    protected BlobList getCollectionBlobs(Collection collection, int currentDepth) throws IOException {
        BlobList blobs = new BlobList();
        int added = 0;
        for (String memberId : collection.getCollectedDocumentIds()) {
            DocumentModel member;
            Blob blob;
            IdRef memberRef = new IdRef(memberId);
            if (!this.session.exists((DocumentRef)memberRef) || "deleted".equals(this.session.getCurrentLifeCycleState((DocumentRef)memberRef)) || (blob = this.getDefaultRendition(member = this.session.getDocument((DocumentRef)memberRef), currentDepth + 1)) == null) continue;
            blobs.add((Object)blob);
            if (this.limit <= -1 || ++added < this.limit) continue;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)String.format("Limit of %s reached, increase the limit parameter to get more results.", this.limit));
            break;
        }
        return blobs;
    }

    protected Blob getDefaultRendition(DocumentModel doc, int currentDepth) throws IOException {
        Blob blob = null;
        if (this.collectionManager.isCollection(doc) || doc.hasFacet("Folderish")) {
            if (currentDepth >= this.maxDepth) {
                return null;
            }
            blob = this.processContainer(doc, currentDepth + 1);
        } else {
            Rendition rendition = this.renditionService.getDefaultRendition(doc, this.reason, null);
            if (rendition != null && (blob = rendition.getBlob()) == null && log.isDebugEnabled()) {
                log.debug((Object)String.format("Default rendition '%s' has an null Blob for document '%s'", rendition.getName(), doc.getPathAsString()));
            }
        }
        return blob;
    }

    protected BlobList getFolderishBlobs(DocumentModel parent, int currentDepth) throws IOException {
        BlobList blobs = new BlobList();
        int added = 0;
        DocumentModelIterator it = this.session.getChildrenIterator(parent.getRef());
        while (it.hasNext()) {
            Blob blob;
            DocumentModel child = (DocumentModel)it.next();
            if ("deleted".equals(this.session.getCurrentLifeCycleState(child.getRef())) || (blob = this.getDefaultRendition(child, currentDepth)) == null) continue;
            blobs.add((Object)blob);
            if (this.limit <= -1 || ++added < this.limit) continue;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)String.format("Limit of %s reached, increase the limit parameter to get more results.", this.limit));
            break;
        }
        return blobs;
    }

    protected Blob processContainer(DocumentModel doc, int currentDepth) throws IOException {
        BlobList blobs = null;
        if (this.collectionManager.isCollection(doc)) {
            blobs = this.getCollectionBlobs((Collection)doc.getAdapter(Collection.class), currentDepth);
        } else if (doc.hasFacet("Folderish")) {
            blobs = this.getFolderishBlobs(doc, currentDepth + 1);
        } else {
            throw new NuxeoException("The operation only accepts folderish document or collection");
        }
        return BlobUtils.zip((List)blobs, (String)(doc.getName() + ".zip"));
    }

    @OperationMethod
    public Blob run(DocumentModel doc) throws IOException {
        if (this.maxDepth <= 0) {
            throw new NuxeoException("Maximum depth must greater or equal to 1.");
        }
        return this.processContainer(doc, 0);
    }
}

