/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.standalone.UninstallTask;
import org.nuxeo.connect.update.task.standalone.commands.AbstractCommand;
import org.nuxeo.connect.update.task.standalone.commands.Append;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Element;

public class UnAppend
extends AbstractCommand {
    public static final String ID = "unappend";
    private static final String newLine = System.getProperty("line.separator");
    private File contentToRemove;
    private File fromFile;

    public UnAppend() {
        this(ID);
    }

    protected UnAppend(String id) {
        super(id);
    }

    public UnAppend(File contentToRemove, File fromFile) {
        this(ID);
        this.contentToRemove = contentToRemove;
        this.fromFile = fromFile;
    }

    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.contentToRemove != null) {
            writer.attr("contentToRemove", this.contentToRemove.getAbsolutePath());
        }
        if (this.fromFile != null) {
            writer.attr("fromFile", this.fromFile.getAbsolutePath());
        }
        writer.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        BufferedReader brToRemove = null;
        BufferedReader brFromFile = null;
        StringBuilder linesToKeep = new StringBuilder();
        StringBuilder linesToRemove = new StringBuilder();
        try {
            try {
                String lineToCheck;
                brToRemove = new BufferedReader(new FileReader(this.contentToRemove));
                String lineToRemove = brToRemove.readLine();
                brFromFile = new BufferedReader(new FileReader(this.fromFile));
                boolean found = false;
                while ((lineToCheck = brFromFile.readLine()) != null) {
                    if (lineToCheck.equals(lineToRemove)) {
                        found = true;
                        linesToRemove.append(lineToCheck).append(newLine);
                        lineToRemove = brToRemove.readLine();
                        continue;
                    }
                    if (lineToRemove != null && found) {
                        found = false;
                        linesToKeep.append(linesToRemove.toString());
                        linesToRemove = new StringBuilder();
                        IOUtils.closeQuietly((Reader)brToRemove);
                        brToRemove = new BufferedReader(new FileReader(this.contentToRemove));
                    }
                    linesToKeep.append(lineToCheck).append(newLine);
                }
                if (lineToRemove != null) {
                    throw new PackageException("All lines to remove were not found.");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(brToRemove);
                IOUtils.closeQuietly(brFromFile);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)brToRemove);
            IOUtils.closeQuietly((Reader)brFromFile);
            File bak = task instanceof UninstallTask ? null : org.nuxeo.connect.update.util.IOUtils.backup(task.getPackage(), this.contentToRemove);
            FileUtils.writeStringToFile((File)this.fromFile, (String)linesToKeep.toString());
            return new Append(bak, this.fromFile);
        }
        catch (PackageException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PackageException((Throwable)e);
        }
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.contentToRemove == null || this.fromFile == null) {
            status.addError("Cannot execute command in installer. Invalid unappend syntax: contentToRemove or fromFile was not specified.");
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("contentToRemove");
        if (v.length() > 0) {
            this.contentToRemove = new File(v);
        }
        if ((v = element.getAttribute("fromFile")).length() > 0) {
            this.fromFile = new File(v);
        }
    }
}

