/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.documents;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.core.util.JSONPropertyWriter;
import org.nuxeo.ecm.automation.jaxrs.io.JsonHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

@Provider
@Produces(value={"application/json+esentity"})
public class JsonESDocumentWriter
implements MessageBodyWriter<DocumentModel> {
    public static final String MIME_TYPE = "application/json+esentity";
    public static final String DOCUMENT_PROPERTIES_HEADER = "X-NXDocumentProperties";
    @Context
    protected HttpHeaders headers;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentModel.class.isAssignableFrom(type) && MIME_TYPE.equals(mediaType.toString());
    }

    public long getSize(DocumentModel arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public void writeTo(DocumentModel doc, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        List props = this.headers.getRequestHeader(DOCUMENT_PROPERTIES_HEADER);
        String[] schemas = null;
        if (props != null && !props.isEmpty()) {
            schemas = StringUtils.split((String)((String)props.get(0)), (String)", ");
        }
        this.writeDocument(entityStream, doc, schemas, null);
    }

    public void writeDoc(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters, HttpHeaders headers) throws IOException {
        jg.writeStartObject();
        this.writeSystemProperties(jg, doc);
        this.writeSchemas(jg, doc, schemas);
        this.writeContextParameters(jg, doc, contextParameters);
        jg.writeEndObject();
        jg.flush();
    }

    protected void writeSystemProperties(JsonGenerator jg, DocumentModel doc) throws IOException {
        String docId = doc.getId();
        CoreSession session = doc.getCoreSession();
        jg.writeStringField("ecm:repository", doc.getRepositoryName());
        jg.writeStringField("ecm:uuid", docId);
        jg.writeStringField("ecm:name", doc.getName());
        jg.writeStringField("ecm:title", doc.getTitle());
        String pathAsString = doc.getPathAsString();
        jg.writeStringField("ecm:path", pathAsString);
        if (StringUtils.isNotBlank((String)pathAsString)) {
            String[] split = pathAsString.split("/");
            if (split.length > 0) {
                for (int i = 1; i < split.length; ++i) {
                    jg.writeStringField("ecm:path@level" + i, split[i]);
                }
            }
            jg.writeNumberField("ecm:path@depth", split.length);
        }
        jg.writeStringField("ecm:primaryType", doc.getType());
        DocumentRef parentRef = doc.getParentRef();
        if (parentRef != null) {
            jg.writeStringField("ecm:parentId", parentRef.toString());
        }
        jg.writeStringField("ecm:currentLifeCycleState", doc.getCurrentLifeCycleState());
        jg.writeStringField("ecm:versionLabel", doc.getVersionLabel());
        jg.writeBooleanField("ecm:isCheckedIn", !doc.isCheckedOut());
        jg.writeBooleanField("ecm:isProxy", doc.isProxy());
        jg.writeBooleanField("ecm:isVersion", doc.isVersion());
        jg.writeBooleanField("ecm:isLatestVersion", doc.isLatestVersion());
        jg.writeBooleanField("ecm:isLatestMajorVersion", doc.isLatestMajorVersion());
        jg.writeArrayFieldStart("ecm:mixinType");
        for (Object facet : doc.getFacets()) {
            jg.writeString((String)facet);
        }
        jg.writeEndArray();
        TagService tagService = (TagService)Framework.getService(TagService.class);
        if (tagService != null && tagService.supportsTag(session, docId)) {
            jg.writeArrayFieldStart("ecm:tag");
            for (String tag : tagService.getTags(session, docId)) {
                jg.writeString(tag);
            }
            jg.writeEndArray();
        }
        jg.writeStringField("ecm:changeToken", doc.getChangeToken());
        Long pos = doc.getPos();
        if (pos != null) {
            jg.writeNumberField("ecm:pos", pos.longValue());
        }
        SecurityService securityService = (SecurityService)Framework.getService(SecurityService.class);
        ArrayList<String> browsePermissions = new ArrayList<String>(Arrays.asList(securityService.getPermissionsToCheck("Browse")));
        ACP acp = doc.getACP();
        if (acp == null) {
            acp = new ACPImpl();
        }
        jg.writeArrayFieldStart("ecm:acl");
        block3: for (ACL acl : acp.getACLs()) {
            for (ACE ace : acl.getACEs()) {
                if (ace.isGranted() && ace.isEffective() && browsePermissions.contains(ace.getPermission())) {
                    jg.writeString(ace.getUsername());
                }
                if (!ace.isDenied() || !ace.isEffective()) continue;
                if ("Everyone".equals(ace.getUsername())) break block3;
                jg.writeString("_UNSUPPORTED_ACL_");
                break block3;
            }
        }
        jg.writeEndArray();
        Map bmap = doc.getBinaryFulltext();
        if (bmap != null && !bmap.isEmpty()) {
            for (Map.Entry item : bmap.entrySet()) {
                String value = (String)item.getValue();
                if (value == null) continue;
                jg.writeStringField("ecm:" + (String)item.getKey(), value);
            }
        }
    }

    protected void writeSchemas(JsonGenerator jg, DocumentModel doc, String[] schemas) throws IOException {
        if (schemas == null || schemas.length == 1 && "*".equals(schemas[0])) {
            schemas = doc.getSchemas();
        }
        for (String schema : schemas) {
            JsonESDocumentWriter.writeProperties(jg, doc, schema, null);
        }
    }

    protected void writeContextParameters(JsonGenerator jg, DocumentModel doc, Map<String, String> contextParameters) throws IOException {
        if (contextParameters != null && !contextParameters.isEmpty()) {
            for (Map.Entry<String, String> parameter : contextParameters.entrySet()) {
                jg.writeStringField(parameter.getKey(), parameter.getValue());
            }
        }
    }

    public void writeDocument(OutputStream out, DocumentModel doc, String[] schemas, Map<String, String> contextParameters) throws IOException {
        this.writeDoc(JsonHelper.createJsonGenerator(out), doc, schemas, contextParameters, this.headers);
    }

    public void writeESDocument(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters) throws IOException {
        this.writeDoc(jg, doc, schemas, contextParameters, null);
    }

    protected static void writeProperties(JsonGenerator jg, DocumentModel doc, String schema, ServletRequest request) throws IOException {
        Collection properties = doc.getPropertyObjects(schema);
        if (properties.isEmpty()) {
            return;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        String prefix = schemaManager.getSchema((String)schema).getNamespace().prefix;
        if (prefix == null || prefix.length() == 0) {
            prefix = schema;
        }
        JSONPropertyWriter writer = JSONPropertyWriter.create().writeNull(false).writeEmpty(false).prefix(prefix);
        if (request != null) {
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            String blobUrlPrefix = VirtualHostHelper.getBaseURL((ServletRequest)request) + downloadService.getDownloadUrl(doc, null, null) + "/";
            writer.filesBaseUrl(blobUrlPrefix);
        }
        for (Property p : properties) {
            writer.writeProperty(jg, p);
        }
    }
}

