/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.RenditionImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoDocument;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoFolder;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObjectFactory;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoProperty;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoRelationship;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyData;

public abstract class NuxeoObject
implements CmisObject {
    protected static final Set<Updatability> UPDATABILITY_READWRITE = Collections.singleton(Updatability.READWRITE);
    protected final NuxeoSession session;
    protected final CmisService service;
    protected final NuxeoCmisService nuxeoCmisService;
    protected final NuxeoObjectFactory objectFactory;
    public final NuxeoObjectData data;
    protected final ObjectType type;
    protected final List<SecondaryType> secondaryTypes;
    protected final List<ObjectType> allTypes;

    public static NuxeoObject construct(NuxeoSession session, NuxeoObjectData data, ObjectType type, List<SecondaryType> secondaryTypes) {
        BaseTypeId baseTypeId = type.getBaseTypeId();
        switch (baseTypeId) {
            case CMIS_FOLDER: {
                return new NuxeoFolder(session, data, type, secondaryTypes);
            }
            case CMIS_DOCUMENT: {
                return new NuxeoDocument(session, data, type, secondaryTypes);
            }
            case CMIS_POLICY: {
                throw new UnsupportedOperationException(baseTypeId.toString());
            }
            case CMIS_RELATIONSHIP: {
                return new NuxeoRelationship(session, data, type, secondaryTypes);
            }
        }
        throw new RuntimeException(baseTypeId.toString());
    }

    public NuxeoObject(NuxeoSession session, NuxeoObjectData data, ObjectType type, List<SecondaryType> secondaryTypes) {
        this.session = session;
        this.service = session.getService();
        this.nuxeoCmisService = NuxeoCmisService.extractFromCmisService(this.service);
        this.objectFactory = session.getObjectFactory();
        this.data = data;
        this.type = type;
        this.secondaryTypes = secondaryTypes;
        this.allTypes = new ArrayList<ObjectType>(1 + secondaryTypes.size());
        this.allTypes.add(type);
        this.allTypes.addAll(secondaryTypes);
    }

    public <T> T getAdapter(Class<T> adapterInterface) {
        throw new CmisRuntimeException("Cannot adapt to " + adapterInterface.getName());
    }

    public String getRepositoryId() {
        return this.session.getRepositoryId();
    }

    public String getId() {
        return this.data.getId();
    }

    public ObjectType getType() {
        return this.type;
    }

    public BaseTypeId getBaseTypeId() {
        return this.data.getBaseTypeId();
    }

    public ObjectType getBaseType() {
        return this.session.getTypeDefinition(this.getBaseTypeId().value());
    }

    public List<SecondaryType> getSecondaryTypes() {
        return this.secondaryTypes;
    }

    public List<ObjectType> findObjectType(String id) {
        ArrayList<ObjectType> types = new ArrayList<ObjectType>(1);
        for (ObjectType t : this.allTypes) {
            if (!t.getPropertyDefinitions().containsKey(id)) continue;
            types.add(t);
        }
        return types;
    }

    public String getName() {
        return NuxeoPropertyData.NuxeoPropertyDataName.getValue(this.data.doc);
    }

    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    public String getDescription() {
        return (String)this.getPropertyValue("cmis:description");
    }

    public void delete(boolean allVersions) {
        this.service.deleteObject(this.getRepositoryId(), this.getId(), Boolean.valueOf(allVersions), null);
    }

    public void delete() {
        this.delete(true);
    }

    public CmisObject updateProperties(Map<String, ?> properties) {
        return this.updateProperties(properties, null, null);
    }

    public ObjectId updateProperties(Map<String, ?> properties, boolean refresh) {
        return this.updateProperties(properties, null, null, refresh);
    }

    public CmisObject updateProperties(Map<String, ?> properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds) {
        ObjectId objectId = this.updateProperties(properties, addSecondaryTypeIds, removeSecondaryTypeIds, true);
        return this.session.getObject(objectId);
    }

    public ObjectId updateProperties(Map<String, ?> properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, boolean refresh) {
        if (addSecondaryTypeIds != null) {
            for (String string : addSecondaryTypeIds) {
                this.data.doc.addFacet(string);
            }
        }
        if (removeSecondaryTypeIds != null) {
            for (String string : removeSecondaryTypeIds) {
                this.data.doc.removeFacet(string);
            }
        }
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                this.data.getProperty((String)entry.getKey()).setValue(entry.getValue());
            }
        }
        CoreSession coreSession = this.session.getCoreSession();
        this.data.doc = coreSession.saveDocument(this.data.doc);
        coreSession.save();
        return this;
    }

    public CmisObject rename(String newName) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("New name must not be empty!");
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("cmis:name", newName);
        return this.updateProperties(prop);
    }

    public ObjectId rename(String newName, boolean refresh) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("New name must not be empty!");
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("cmis:name", newName);
        return this.updateProperties(prop, refresh);
    }

    public <T> T getPropertyValue(String id) {
        return (T)this.data.getProperty(id).getValue();
    }

    public <T> Property<T> getProperty(String id) {
        return new NuxeoProperty(this, id);
    }

    public List<Property<?>> getProperties() {
        ArrayList list = new ArrayList();
        for (ObjectType t : this.allTypes) {
            Collection defs = t.getPropertyDefinitions().values();
            for (PropertyDefinition pd : defs) {
                list.add(new NuxeoProperty(this, pd.getId()));
            }
        }
        return list;
    }

    public Acl addAcl(List<Ace> addAces, AclPropagation aclPropagation) {
        return this.service.applyAcl(this.getRepositoryId(), this.getId(), this.objectFactory.convertAces(addAces), null, aclPropagation, null);
    }

    public Acl applyAcl(List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        return this.service.applyAcl(this.getRepositoryId(), this.getId(), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), aclPropagation, null);
    }

    public Acl setAcl(List<Ace> aces) {
        return this.service.applyAcl(this.getRepositoryId(), this.getId(), this.objectFactory.convertAces(aces), AclPropagation.REPOSITORYDETERMINED);
    }

    public Acl getAcl() {
        return this.data.getAcl();
    }

    public Acl removeAcl(List<Ace> removeAces, AclPropagation aclPropagation) {
        return this.service.applyAcl(this.getRepositoryId(), this.getId(), null, this.objectFactory.convertAces(removeAces), aclPropagation, null);
    }

    public AllowableActions getAllowableActions() {
        return NuxeoObjectData.getAllowableActions(this.data.doc, this.data.creation);
    }

    public List<Policy> getPolicies() {
        return Collections.emptyList();
    }

    public void applyPolicy(ObjectId ... policyIds) {
        throw new CmisNotSupportedException();
    }

    public void removePolicy(ObjectId ... policyIds) {
        throw new CmisNotSupportedException();
    }

    public List<Relationship> getRelationships() {
        throw new CmisNotSupportedException();
    }

    public List<Rendition> getRenditions() {
        List<RenditionData> renditions = this.data.getRenditions();
        if (renditions == null) {
            return Collections.emptyList();
        }
        ArrayList<Rendition> res = new ArrayList<Rendition>(renditions.size());
        for (RenditionData ren : renditions) {
            long length = ren.getBigLength() == null ? -1L : ren.getBigLength().longValue();
            int height = ren.getBigHeight() == null ? -1 : ren.getBigHeight().intValue();
            int width = ren.getBigWidth() == null ? -1 : ren.getBigWidth().intValue();
            RenditionImpl rendition = new RenditionImpl((Session)this.session, this.getId(), ren.getStreamId(), ren.getRenditionDocumentId(), ren.getKind(), length, ren.getMimeType(), ren.getTitle(), height, width);
            res.add((Rendition)rendition);
        }
        return res;
    }

    public void refresh() {
        this.data.doc.refresh();
    }

    public void refreshIfOld(long durationInMillis) {
        throw new UnsupportedOperationException();
    }

    public long getRefreshTimestamp() {
        throw new UnsupportedOperationException();
    }

    public List<CmisExtensionElement> getExtensions(ExtensionLevel level) {
        throw new UnsupportedOperationException();
    }

    public boolean hasAllowableAction(Action action) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPermissionsForPrincipal(String principalId) {
        throw new UnsupportedOperationException();
    }

    public void applyPolicy(ObjectId policyId, boolean refresh) {
        throw new UnsupportedOperationException();
    }

    public void removePolicy(ObjectId policyId, boolean refresh) {
        throw new UnsupportedOperationException();
    }
}

