/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.impl.Base64;

public class NuxeoPortalSSOAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    public static final String SECRET_KEY = "NUXEO_PORTAL_SSO_SECRET";

    protected String getSecretKey() {
        return (String)this.getSession().get(SECRET_KEY);
    }

    public Map<String, List<String>> getHTTPHeaders(String url) {
        byte[] hashedToken;
        long ts = new Date().getTime();
        long random = new Random(ts).nextInt();
        String secret = this.getSecretKey();
        String username = this.getUser();
        String clearToken = String.format("%d:%d:%s:%s", ts, random, secret, username);
        try {
            hashedToken = MessageDigest.getInstance("MD5").digest(clearToken.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Cannot compute token", e);
        }
        String base64HashedToken = Base64.encodeBytes((byte[])hashedToken);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("NX_USER", Collections.singletonList(username));
        headers.put("NX_TOKEN", Collections.singletonList(base64HashedToken));
        headers.put("NX_RD", Collections.singletonList(String.valueOf(random)));
        headers.put("NX_TS", Collections.singletonList(String.valueOf(ts)));
        return Collections.unmodifiableMap(headers);
    }
}

