/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyHtml;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.PropertyUri;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamHashImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.util.ComplexPropertyJSONEncoder;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoContentStream;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoTypeHelper;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.runtime.api.Framework;

public abstract class NuxeoPropertyData<T>
extends NuxeoPropertyDataBase<T> {
    private static final Log log = LogFactory.getLog(NuxeoPropertyData.class);
    protected final String name;
    protected final boolean readOnly;
    protected final CallContext callContext;

    public NuxeoPropertyData(PropertyDefinition<T> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
        super(propertyDefinition, doc);
        this.name = name;
        this.readOnly = readOnly;
        this.callContext = callContext;
    }

    public static <U> PropertyData<U> construct(NuxeoObjectData data, PropertyDefinition<U> pd, CallContext callContext) {
        DocumentModel doc = data.doc;
        String name = pd.getId();
        if ("cmis:objectId".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyIdDataFixed(pd, doc.getId());
        }
        if ("cmis:objectTypeId".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyIdDataFixed(pd, NuxeoTypeHelper.mappedId(doc.getType()));
        }
        if ("cmis:baseTypeId".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyIdDataFixed(pd, NuxeoTypeHelper.getBaseTypeId(doc).value());
        }
        if ("cmis:description".equals(name)) {
            return new NuxeoPropertyStringData((PropertyDefinition<String>)pd, doc, "dc:description", false, callContext);
        }
        if ("cmis:createdBy".equals(name)) {
            return new NuxeoPropertyStringData((PropertyDefinition<String>)pd, doc, "dc:creator", true, callContext);
        }
        if ("cmis:creationDate".equals(name)) {
            return new NuxeoPropertyDateTimeData((PropertyDefinition<GregorianCalendar>)pd, doc, "dc:created", true, callContext);
        }
        if ("cmis:lastModifiedBy".equals(name)) {
            return new NuxeoPropertyStringData((PropertyDefinition<String>)pd, doc, "dc:lastContributor", true, callContext);
        }
        if ("cmis:lastModificationDate".equals(name)) {
            return new NuxeoPropertyDateTimeData((PropertyDefinition<GregorianCalendar>)pd, doc, "dc:modified", true, callContext);
        }
        if ("cmis:changeToken".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyStringDataFixed(pd, doc.getChangeToken());
        }
        if ("cmis:name".equals(name)) {
            return new NuxeoPropertyDataName((PropertyDefinition<String>)pd, doc);
        }
        if ("cmis:isImmutable".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyBooleanDataFixed(pd, Boolean.FALSE);
        }
        if ("cmis:isLatestVersion".equals(name)) {
            return new NuxeoPropertyDataIsLatestVersion((PropertyDefinition<Boolean>)pd, doc);
        }
        if ("cmis:isLatestMajorVersion".equals(name)) {
            return new NuxeoPropertyDataIsLatestMajorVersion((PropertyDefinition<Boolean>)pd, doc);
        }
        if ("cmis:isMajorVersion".equals(name)) {
            return new NuxeoPropertyDataIsMajorVersion((PropertyDefinition<Boolean>)pd, doc);
        }
        if ("cmis:versionLabel".equals(name)) {
            return new NuxeoPropertyDataVersionLabel((PropertyDefinition<String>)pd, doc);
        }
        if ("cmis:versionSeriesId".equals(name)) {
            String versionSeriesId = doc.getVersionSeriesId();
            return new NuxeoPropertyDataBase.NuxeoPropertyIdDataFixed(pd, versionSeriesId);
        }
        if ("cmis:isVersionSeriesCheckedOut".equals(name)) {
            return new NuxeoPropertyDataIsVersionSeriesCheckedOut((PropertyDefinition<Boolean>)pd, doc);
        }
        if ("cmis:versionSeriesCheckedOutBy".equals(name)) {
            return new NuxeoPropertyDataVersionSeriesCheckedOutBy(pd, doc, callContext);
        }
        if ("cmis:versionSeriesCheckedOutId".equals(name)) {
            return new NuxeoPropertyDataVersionSeriesCheckedOutId((PropertyDefinition<String>)pd, doc);
        }
        if ("nuxeo:isVersion".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyBooleanDataFixed(pd, doc.isVersion());
        }
        if ("nuxeo:isCheckedIn".equals(name)) {
            boolean co = doc.isCheckedOut();
            return new NuxeoPropertyDataBase.NuxeoPropertyBooleanDataFixed(pd, !co);
        }
        if ("cmis:isPrivateWorkingCopy".equals(name)) {
            boolean co = doc.isCheckedOut();
            return new NuxeoPropertyDataBase.NuxeoPropertyBooleanDataFixed(pd, co);
        }
        if ("cmis:checkinComment".equals(name)) {
            return new NuxeoPropertyDataCheckInComment((PropertyDefinition<String>)pd, doc);
        }
        if ("cmis:contentStreamLength".equals(name)) {
            return new NuxeoPropertyDataContentStreamLength((PropertyDefinition<BigInteger>)pd, doc);
        }
        if ("nuxeo:contentStreamDigest".equals(name)) {
            return new NuxeoPropertyDataContentStreamDigest((PropertyDefinition<String>)pd, doc);
        }
        if ("cmis:contentStreamHash".equals(name)) {
            String digest = new NuxeoPropertyDataContentStreamDigest((PropertyDefinition<String>)pd, doc).getFirstValue();
            List<String> hashes = digest == null ? new ArrayList<String>() : Arrays.asList(new ContentStreamHashImpl("md5", digest).getPropertyValue());
            return new NuxeoPropertyDataContentStreamHash((PropertyDefinition<String>)pd, hashes);
        }
        if ("cmis:contentStreamMimeType".equals(name)) {
            return new NuxeoPropertyDataContentStreamMimeType((PropertyDefinition<String>)pd, doc);
        }
        if ("cmis:contentStreamFileName".equals(name)) {
            return new NuxeoPropertyDataContentStreamFileName((PropertyDefinition<String>)pd, doc);
        }
        if ("cmis:contentStreamId".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyIdDataFixed((PropertyDefinition<String>)pd, null);
        }
        if ("cmis:parentId".equals(name)) {
            return new NuxeoPropertyDataParentId((PropertyDefinition<String>)pd, doc);
        }
        if ("nuxeo:parentId".equals(name)) {
            return new NuxeoPropertyDataParentId((PropertyDefinition<String>)pd, doc);
        }
        if ("nuxeo:pathSegment".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyStringDataFixed(pd, doc.getName());
        }
        if ("nuxeo:pos".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyIntegerDataFixed(pd, doc.getPos());
        }
        if ("cmis:path".equals(name)) {
            return new NuxeoPropertyDataPath((PropertyDefinition<String>)pd, doc);
        }
        if ("cmis:allowedChildObjectTypeIds".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyIdMultiDataFixed((PropertyDefinition<String>)pd, Collections.emptyList());
        }
        if ("cmis:sourceId".equals(name)) {
            return new NuxeoPropertyIdData((PropertyDefinition<String>)pd, doc, "relation:source", false, callContext);
        }
        if ("cmis:targetId".equals(name)) {
            return new NuxeoPropertyIdData((PropertyDefinition<String>)pd, doc, "relation:target", false, callContext);
        }
        if ("cmis:policyText".equals(name)) {
            return new NuxeoPropertyDataBase.NuxeoPropertyStringDataFixed((PropertyDefinition<String>)pd, null);
        }
        if ("cmis:secondaryObjectTypeIds".equals(name)) {
            List<String> facets = NuxeoPropertyData.getSecondaryTypeIds(doc);
            return new NuxeoPropertyDataBase.NuxeoPropertyIdMultiDataFixed((PropertyDefinition<String>)pd, facets);
        }
        if ("nuxeo:secondaryObjectTypeIds".equals(name)) {
            List<String> facets = NuxeoPropertyData.getFacets(doc);
            return new NuxeoPropertyDataBase.NuxeoPropertyIdMultiDataFixed((PropertyDefinition<String>)pd, facets);
        }
        if ("nuxeo:lifecycleState".equals(name)) {
            String state = doc.getCurrentLifeCycleState();
            return new NuxeoPropertyDataBase.NuxeoPropertyStringDataFixed(pd, state);
        }
        boolean readOnly = pd.getUpdatability() != Updatability.READWRITE;
        switch (pd.getPropertyType()) {
            case BOOLEAN: {
                return new NuxeoPropertyBooleanData((PropertyDefinition<Boolean>)pd, doc, name, readOnly, callContext);
            }
            case DATETIME: {
                return new NuxeoPropertyDateTimeData((PropertyDefinition<GregorianCalendar>)pd, doc, name, readOnly, callContext);
            }
            case DECIMAL: {
                return new NuxeoPropertyDecimalData((PropertyDefinition<BigDecimal>)pd, doc, name, readOnly, callContext);
            }
            case HTML: {
                return new NuxeoPropertyHtmlData((PropertyDefinition<String>)pd, doc, name, readOnly, callContext);
            }
            case ID: {
                return new NuxeoPropertyIdData((PropertyDefinition<String>)pd, doc, name, readOnly, callContext);
            }
            case INTEGER: {
                return new NuxeoPropertyIntegerData((PropertyDefinition<BigInteger>)pd, doc, name, readOnly, callContext);
            }
            case STRING: {
                return new NuxeoPropertyStringData((PropertyDefinition<String>)pd, doc, name, readOnly, callContext);
            }
            case URI: {
                return new NuxeoPropertyUriData((PropertyDefinition<String>)pd, doc, name, readOnly, callContext);
            }
        }
        throw new AssertionError((Object)pd.getPropertyType().toString());
    }

    public static List<String> getFacets(DocumentModel doc) {
        ArrayList<String> facets = new ArrayList<String>();
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (String facet : doc.getFacets()) {
            if ("Immutable".equals(facet)) continue;
            CompositeType facetType = schemaManager.getFacet(facet);
            if (facetType != null) {
                facets.add(facet);
                continue;
            }
            log.warn((Object)("The document " + doc.getName() + " with id=" + doc.getId() + " and type=" + doc.getDocumentType().getName() + " contains the facet '" + facet + "', which is not registered as available in the schemaManager. This facet will be ignored."));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Available facets: " + Arrays.toString(schemaManager.getFacets())));
        }
        Collections.sort(facets);
        return facets;
    }

    public static List<String> getSecondaryTypeIds(DocumentModel doc) {
        List<String> facets = NuxeoPropertyData.getFacets(doc);
        DocumentType type = doc.getDocumentType();
        ListIterator<String> it = facets.listIterator();
        while (it.hasNext()) {
            String facet = it.next();
            if (type.hasFacet(facet)) {
                it.remove();
                continue;
            }
            it.set("facet:" + facet);
        }
        return facets;
    }

    public static ContentStream getContentStream(DocumentModel doc, HttpServletRequest request) throws CmisRuntimeException {
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (blobHolder == null) {
            throw new CmisStreamNotSupportedException();
        }
        Blob blob = blobHolder.getBlob();
        if (blob == null) {
            return null;
        }
        GregorianCalendar lastModified = (GregorianCalendar)doc.getPropertyValue("dc:modified");
        return NuxeoContentStream.create(doc, "blobholder:0", blob, "cmis", null, lastModified, request);
    }

    public static void setContentStream(DocumentModel doc, ContentStream contentStream, boolean overwrite) throws IOException, CmisContentAlreadyExistsException, CmisRuntimeException {
        Blob blob;
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (blobHolder == null) {
            throw new CmisContentAlreadyExistsException();
        }
        Blob oldBlob = blobHolder.getBlob();
        if (!overwrite && oldBlob != null) {
            throw new CmisContentAlreadyExistsException();
        }
        if (contentStream == null) {
            blob = null;
        } else {
            String filename = contentStream.getFileName();
            if (filename == null && oldBlob != null) {
                filename = oldBlob.getFilename();
            }
            if (filename == null) {
                filename = doc.getTitle();
            }
            blob = NuxeoPropertyData.getPersistentBlob(contentStream, filename);
        }
        blobHolder.setBlob(blob);
    }

    public static Blob getPersistentBlob(ContentStream contentStream, String filename) throws IOException {
        if (filename == null) {
            filename = contentStream.getFileName();
        }
        if (filename != null) {
            filename = FileManagerUtils.fetchFileName((String)filename);
        }
        File file = Framework.createTempFile((String)"NuxeoCMIS-", null);
        try (InputStream in = contentStream.getStream();
             FileOutputStream out = new FileOutputStream(file);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
            Framework.trackFile((File)file, (Object)in);
        }
        return Blobs.createBlob((File)file, (String)contentStream.getMimeType(), null, (String)filename);
    }

    public static void validateBlobDigest(DocumentModel doc, CallContext callContext) {
        Blob blob = ((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob();
        if (blob == null) {
            return;
        }
        String blobDigestAlgorithm = blob.getDigestAlgorithm();
        if (blobDigestAlgorithm == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)callContext.get("httpServletRequest");
        String reqDigest = NuxeoPropertyData.extractDigestFromRequestHeaders(request, blobDigestAlgorithm);
        if (reqDigest == null) {
            return;
        }
        String blobDigest = blob.getDigest();
        if (!blobDigest.equals(reqDigest)) {
            throw new CmisInvalidArgumentException(String.format("Content Stream Hex-encoded Digest: '%s' must equal Request Header Hex-encoded Digest: '%s'", blobDigest, reqDigest));
        }
    }

    protected static String extractDigestFromRequestHeaders(HttpServletRequest request, String digestAlgorithm) {
        if (request == null) {
            return null;
        }
        Enumeration digests = request.getHeaders("Digest");
        if (digests == null) {
            return null;
        }
        UnmodifiableIterator it = Iterators.forEnumeration((Enumeration)digests);
        while (it.hasNext()) {
            String reqDigestAlgorithm;
            String value = (String)it.next();
            int equals = value.indexOf(61);
            if (equals < 0 || !(reqDigestAlgorithm = value.substring(0, equals)).equalsIgnoreCase(digestAlgorithm)) continue;
            String digest = value.substring(equals + 1);
            digest = NuxeoPropertyData.transcodeBase64ToHex(digest);
            return digest;
        }
        return null;
    }

    public static String transcodeBase64ToHex(String base64String) {
        byte[] bytes = Base64.decodeBase64((String)base64String);
        String hexString = Hex.encodeHexString((byte[])bytes);
        return hexString;
    }

    public static String transcodeHexToBase64(String hexString) {
        byte[] bytes;
        try {
            bytes = Hex.decodeHex((char[])hexString.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
        String base64String = Base64.encodeBase64String((byte[])bytes);
        return base64String;
    }

    @Override
    public <U> U getValue() {
        Property prop = this.doc.getProperty(this.name);
        Serializable value = prop.getValue();
        if (value == null) {
            return null;
        }
        Type type = prop.getType();
        if (type.isListType()) {
            List values;
            if ((type = ((ListType)type).getFieldType()).isComplexType()) {
                values = prop.getChildren();
            } else if (value instanceof Object[]) {
                values = Arrays.asList((Object[])value);
            } else if (value instanceof List) {
                values = (List)((Object)value);
            } else {
                throw new CmisRuntimeException("Unknown value type: " + value.getClass().getName());
            }
            ArrayList<Serializable> list = new ArrayList<Serializable>(values);
            for (int i = 0; i < list.size(); ++i) {
                value = type.isComplexType() ? (Serializable)NuxeoPropertyData.convertComplexPropertyToCMIS((ComplexProperty)list.get(i), this.callContext) : (Serializable)NuxeoPropertyData.convertToCMIS(list.get(i));
                list.set(i, value);
            }
            return (U)list;
        }
        value = type.isComplexType() ? (Serializable)NuxeoPropertyData.convertComplexPropertyToCMIS((ComplexProperty)prop, this.callContext) : (Serializable)NuxeoPropertyData.convertToCMIS(value);
        return (U)NuxeoPropertyData.convertToCMIS(value);
    }

    protected static Object convertToCMIS(Object value) {
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Integer) {
            return BigInteger.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        return value;
    }

    protected static Object convertComplexPropertyToCMIS(ComplexProperty prop, CallContext callContext) {
        DateTimeFormat cmisDateTimeFormat = NuxeoPropertyData.getCMISDateTimeFormat(callContext);
        org.nuxeo.ecm.automation.core.util.DateTimeFormat nuxeoDateTimeFormat = cmisDateTimeFormat == DateTimeFormat.SIMPLE ? org.nuxeo.ecm.automation.core.util.DateTimeFormat.TIME_IN_MILLIS : org.nuxeo.ecm.automation.core.util.DateTimeFormat.W3C;
        try {
            return ComplexPropertyJSONEncoder.encode((ComplexProperty)prop, (org.nuxeo.ecm.automation.core.util.DateTimeFormat)nuxeoDateTimeFormat);
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    protected static DateTimeFormat getCMISDateTimeFormat(CallContext callContext) {
        if (callContext != null && "browser".equals(callContext.getBinding())) {
            String s;
            HttpServletRequest request = (HttpServletRequest)callContext.get("httpServletRequest");
            if (request != null && (s = HttpUtils.getStringParameter((HttpServletRequest)request, (String)"dateTimeFormat")) != null) {
                try {
                    return DateTimeFormat.fromValue((String)s.trim().toLowerCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw new CmisInvalidArgumentException("Invalid value for parameter dateTimeFormat!");
                }
            }
            return DateTimeFormat.SIMPLE;
        }
        return DateTimeFormat.EXTENDED;
    }

    protected static Object convertToNuxeo(Object value, Type type) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).longValue();
        }
        if (type.isComplexType()) {
            try {
                return ComplexTypeJSONDecoder.decode((ComplexType)((ComplexType)type), (String)value.toString());
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        return value;
    }

    public static <T> void validateCMISValue(Object value, PropertyDefinition<T> pd) {
        List<Object> values;
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new CmisInvalidArgumentException("Property is single-valued: " + pd.getId());
            }
            values = (List<Object>)value;
            if (values.isEmpty()) {
                return;
            }
        } else {
            if (pd.getCardinality() != Cardinality.SINGLE) {
                throw new CmisInvalidArgumentException("Property is multi-valued: " + pd.getId());
            }
            values = Collections.singletonList(value);
        }
        PropertyType type = pd.getPropertyType();
        for (Object v : values) {
            boolean ok;
            if (v == null) {
                throw new CmisInvalidArgumentException("Null values not allowed: " + values);
            }
            switch (type) {
                case HTML: 
                case ID: 
                case STRING: 
                case URI: {
                    ok = v instanceof String;
                    break;
                }
                case INTEGER: {
                    ok = v instanceof BigInteger || v instanceof Byte || v instanceof Short || v instanceof Integer || v instanceof Long;
                    break;
                }
                case DECIMAL: {
                    ok = v instanceof BigDecimal;
                    break;
                }
                case BOOLEAN: {
                    ok = v instanceof Boolean;
                    break;
                }
                case DATETIME: {
                    ok = v instanceof GregorianCalendar;
                    break;
                }
                default: {
                    throw new RuntimeException(type.toString());
                }
            }
            if (ok) continue;
            throw new CmisInvalidArgumentException("Value does not match property type " + type + ":  " + v);
        }
    }

    @Override
    public T getFirstValue() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return null;
            }
            return (T)list.get(0);
        }
        return (T)value;
    }

    @Override
    public List<T> getValues() {
        Object value = this.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.singletonList(value);
    }

    @Override
    public void setValue(Object value) {
        if (this.readOnly) {
            super.setValue(value);
        } else {
            ArrayList<Object> propValue;
            Type type = this.doc.getProperty(this.name).getType();
            if (type.isListType()) {
                type = ((ListType)type).getFieldType();
            }
            if (value instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>((List)value);
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, NuxeoPropertyData.convertToNuxeo(list.get(i), type));
                }
                if (list.isEmpty()) {
                    list = null;
                }
                propValue = list;
            } else {
                propValue = NuxeoPropertyData.convertToNuxeo(value, type);
            }
            this.doc.setPropertyValue(this.name, (Serializable)propValue);
        }
    }

    protected static Blob getBlob(DocumentModel doc) throws CmisRuntimeException {
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (blobHolder == null) {
            return null;
        }
        return blobHolder.getBlob();
    }

    protected static boolean isVersionOrProxyToVersion(DocumentModel doc) {
        return doc.isVersion() || doc.isProxy() && doc.getCoreSession().getSourceDocument(doc.getRef()).isVersion();
    }

    public static class NuxeoPropertyDataCheckInComment
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        protected NuxeoPropertyDataCheckInComment(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            if (NuxeoPropertyData.isVersionOrProxyToVersion(this.doc)) {
                return this.doc.getCheckinComment();
            }
            if (this.doc.isCheckedOut()) {
                return null;
            }
            CoreSession session = this.doc.getCoreSession();
            DocumentRef v = session.getBaseVersion(this.doc.getRef());
            DocumentModel ver = session.getDocument(v);
            return ver.getCheckinComment();
        }
    }

    public static class NuxeoPropertyDataVersionLabel
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        protected NuxeoPropertyDataVersionLabel(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            if (NuxeoPropertyData.isVersionOrProxyToVersion(this.doc)) {
                return this.doc.getVersionLabel();
            }
            return this.doc.isCheckedOut() ? null : this.doc.getVersionLabel();
        }
    }

    public static class NuxeoPropertyDataVersionSeriesCheckedOutBy
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        protected final CallContext callContext;

        protected NuxeoPropertyDataVersionSeriesCheckedOutBy(PropertyDefinition<String> propertyDefinition, DocumentModel doc, CallContext callContext) {
            super(propertyDefinition, doc);
            this.callContext = callContext;
        }

        @Override
        public String getFirstValue() {
            if (!this.doc.isVersionSeriesCheckedOut()) {
                return null;
            }
            String versionSeriesId = this.doc.getCoreSession().getVersionSeriesId(this.doc.getRef());
            return versionSeriesId == null ? null : this.callContext.getUsername();
        }
    }

    public static class NuxeoPropertyDataVersionSeriesCheckedOutId
    extends NuxeoPropertyDataBase<String>
    implements PropertyId {
        protected NuxeoPropertyDataVersionSeriesCheckedOutId(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            if (!this.doc.isVersionSeriesCheckedOut()) {
                return null;
            }
            return this.doc.getCoreSession().getVersionSeriesId(this.doc.getRef());
        }
    }

    public static class NuxeoPropertyDataIsVersionSeriesCheckedOut
    extends NuxeoPropertyDataBase<Boolean>
    implements PropertyBoolean {
        protected NuxeoPropertyDataIsVersionSeriesCheckedOut(PropertyDefinition<Boolean> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public Boolean getFirstValue() {
            return this.doc.isVersionSeriesCheckedOut();
        }
    }

    public static class NuxeoPropertyDataIsLatestMajorVersion
    extends NuxeoPropertyDataBase<Boolean>
    implements PropertyBoolean {
        protected NuxeoPropertyDataIsLatestMajorVersion(PropertyDefinition<Boolean> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public Boolean getFirstValue() {
            if (NuxeoPropertyData.isVersionOrProxyToVersion(this.doc)) {
                return this.doc.isLatestMajorVersion();
            }
            return !this.doc.isCheckedOut() && this.doc.getVersionLabel().endsWith(".0");
        }
    }

    public static class NuxeoPropertyDataIsLatestVersion
    extends NuxeoPropertyDataBase<Boolean>
    implements PropertyBoolean {
        protected NuxeoPropertyDataIsLatestVersion(PropertyDefinition<Boolean> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public Boolean getFirstValue() {
            if (NuxeoPropertyData.isVersionOrProxyToVersion(this.doc)) {
                return this.doc.isLatestVersion();
            }
            return !this.doc.isCheckedOut();
        }
    }

    public static class NuxeoPropertyDataIsMajorVersion
    extends NuxeoPropertyDataBase<Boolean>
    implements PropertyBoolean {
        protected NuxeoPropertyDataIsMajorVersion(PropertyDefinition<Boolean> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public Boolean getFirstValue() {
            if (NuxeoPropertyData.isVersionOrProxyToVersion(this.doc)) {
                return this.doc.isMajorVersion();
            }
            return !this.doc.isCheckedOut() && this.doc.getVersionLabel().endsWith(".0");
        }
    }

    public static class NuxeoPropertyDataPath
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        protected NuxeoPropertyDataPath(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            String path = this.doc.getPathAsString();
            return path == null ? "" : path;
        }
    }

    public static class NuxeoPropertyDataParentId
    extends NuxeoPropertyDataBase<String>
    implements PropertyId {
        protected NuxeoPropertyDataParentId(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            if (this.doc.getName() == null) {
                return null;
            }
            DocumentRef parentRef = this.doc.getParentRef();
            if (parentRef == null) {
                return null;
            }
            if (parentRef instanceof IdRef) {
                return ((IdRef)parentRef).value;
            }
            return this.doc.getCoreSession().getDocument(parentRef).getId();
        }
    }

    public static class NuxeoPropertyDataName
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        private static final Log log = LogFactory.getLog(NuxeoPropertyDataName.class);

        protected NuxeoPropertyDataName(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        public static String getValue(DocumentModel doc) {
            if (doc.getPath() == null) {
                return "";
            }
            if (doc.getPath().isRoot()) {
                return "";
            }
            return doc.getTitle();
        }

        @Override
        public String getFirstValue() {
            return NuxeoPropertyDataName.getValue(this.doc);
        }

        @Override
        public void setValue(Object value) {
            try {
                this.doc.setPropertyValue("dc:title", (Serializable)((Object)((String)value)));
            }
            catch (PropertyNotFoundException e) {
                log.debug((Object)("Cannot set CMIS name on type: " + this.doc.getType()));
            }
        }
    }

    public static class NuxeoPropertyDataContentStreamMimeType
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        protected NuxeoPropertyDataContentStreamMimeType(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            Blob blob = NuxeoPropertyData.getBlob(this.doc);
            return blob == null ? null : blob.getMimeType();
        }
    }

    public static class NuxeoPropertyDataContentStreamHash
    extends NuxeoPropertyDataBase.NuxeoPropertyMultiDataFixed<String>
    implements PropertyString {
        protected NuxeoPropertyDataContentStreamHash(PropertyDefinition<String> propertyDefinition, List<String> hashes) {
            super(propertyDefinition, hashes);
        }
    }

    public static class NuxeoPropertyDataContentStreamDigest
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        protected NuxeoPropertyDataContentStreamDigest(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            Blob blob = NuxeoPropertyData.getBlob(this.doc);
            return blob == null ? null : blob.getDigest();
        }
    }

    public static class NuxeoPropertyDataContentStreamLength
    extends NuxeoPropertyDataBase<BigInteger>
    implements PropertyInteger {
        protected NuxeoPropertyDataContentStreamLength(PropertyDefinition<BigInteger> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public BigInteger getFirstValue() {
            Blob blob = NuxeoPropertyData.getBlob(this.doc);
            return blob == null ? null : BigInteger.valueOf(blob.getLength());
        }
    }

    public static class NuxeoPropertyDataContentStreamFileName
    extends NuxeoPropertyDataBase<String>
    implements PropertyString {
        protected NuxeoPropertyDataContentStreamFileName(PropertyDefinition<String> propertyDefinition, DocumentModel doc) {
            super(propertyDefinition, doc);
        }

        @Override
        public String getFirstValue() {
            Blob blob = NuxeoPropertyData.getBlob(this.doc);
            return blob == null ? null : blob.getFilename();
        }
    }

    public static class NuxeoPropertyUriData
    extends NuxeoPropertyData<String>
    implements PropertyUri {
        public NuxeoPropertyUriData(PropertyDefinition<String> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }

    public static class NuxeoPropertyHtmlData
    extends NuxeoPropertyData<String>
    implements PropertyHtml {
        public NuxeoPropertyHtmlData(PropertyDefinition<String> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }

    public static class NuxeoPropertyDateTimeData
    extends NuxeoPropertyData<GregorianCalendar>
    implements PropertyDateTime {
        public NuxeoPropertyDateTimeData(PropertyDefinition<GregorianCalendar> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }

    public static class NuxeoPropertyDecimalData
    extends NuxeoPropertyData<BigDecimal>
    implements PropertyDecimal {
        public NuxeoPropertyDecimalData(PropertyDefinition<BigDecimal> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }

    public static class NuxeoPropertyIntegerData
    extends NuxeoPropertyData<BigInteger>
    implements PropertyInteger {
        public NuxeoPropertyIntegerData(PropertyDefinition<BigInteger> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }

    public static class NuxeoPropertyBooleanData
    extends NuxeoPropertyData<Boolean>
    implements PropertyBoolean {
        public NuxeoPropertyBooleanData(PropertyDefinition<Boolean> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }

    public static class NuxeoPropertyIdData
    extends NuxeoPropertyData<String>
    implements PropertyId {
        public NuxeoPropertyIdData(PropertyDefinition<String> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }

    public static class NuxeoPropertyStringData
    extends NuxeoPropertyData<String>
    implements PropertyString {
        public NuxeoPropertyStringData(PropertyDefinition<String> propertyDefinition, DocumentModel doc, String name, boolean readOnly, CallContext callContext) {
            super(propertyDefinition, doc, name, readOnly, callContext);
        }
    }
}

