/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.ReadOnlyMappedBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappedFile
implements ReferenceCounted {
    public static final long DEFAULT_CAPACITY = 0x800000000000L;
    private static final Object GLOBAL_FILE_LOCK = new Object();
    @NotNull
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final long chunkSize;
    private final long overlapSize;
    private final List<WeakReference<MappedBytesStore>> stores = new ArrayList<WeakReference<MappedBytesStore>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private final long capacity;
    private boolean readOnly;
    @NotNull
    private final File file;
    private NewChunkListener newChunkListener = (filename, chunk, delayMicros) -> Jvm.debug().on(MappedFile.class, "Allocation of " + chunk + " chunk in " + filename + " took " + (double)delayMicros / 1000.0 + " ms.");

    protected MappedFile(@NotNull File file, @NotNull RandomAccessFile raf, long chunkSize, long overlapSize, long capacity, boolean readOnly) {
        this.file = file;
        this.raf = raf;
        this.fileChannel = raf.getChannel();
        this.chunkSize = OS.mapAlign((long)chunkSize);
        this.overlapSize = overlapSize > 0L && overlapSize < 65536L ? chunkSize : OS.mapAlign((long)overlapSize);
        this.capacity = capacity;
        this.readOnly = readOnly;
        assert (MappedFile.registerMappedFile(this));
    }

    private static boolean registerMappedFile(MappedFile mappedFile) {
        return true;
    }

    public static void checkMappedFiles() {
    }

    @NotNull
    public static MappedFile of(@NotNull File file, long chunkSize, long overlapSize, boolean readOnly) throws FileNotFoundException {
        RandomAccessFile raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
        long capacity = 0x800000000000L;
        return new MappedFile(file, raf, chunkSize, overlapSize, capacity, readOnly);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(filename, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, long chunkSize, long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(new File(filename), chunkSize, overlapSize);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, overlapSize, false);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize, long overlapSize, boolean readOnly) throws FileNotFoundException {
        return MappedFile.of(file, chunkSize, overlapSize, readOnly);
    }

    @NotNull
    public static MappedFile readOnly(@NotNull File file) throws FileNotFoundException {
        long chunkSize = file.length();
        long overlapSize = 0L;
        if (OS.isWindows() && chunkSize > 0x80000000L) {
            chunkSize = 0x80000000L;
            overlapSize = OS.pageSize();
        }
        return MappedFile.of(file, chunkSize, overlapSize, true);
    }

    public static void warmup() {
        try {
            Jvm.disableDebugHandler();
            File file = File.createTempFile("delete", "me");
            file.deleteOnExit();
            long mapAlignment = OS.mapAlignment();
            int chunks = 64;
            int compileThreshold = Jvm.compileThreshold();
            for (int j = 0; j <= compileThreshold; j += chunks) {
                try {
                    try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                        MappedFile mappedFile = new MappedFile(file, raf, mapAlignment, 0L, mapAlignment * (long)chunks, false);
                        MappedFile.warmup0(mapAlignment, chunks, mappedFile);
                        mappedFile.release();
                    }
                    Thread.yield();
                    Files.delete(file.toPath());
                    continue;
                }
                catch (IOException e) {
                    Jvm.debug().on(MappedFile.class, "Error during warmup", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Jvm.warn().on(MappedFile.class, "Error during warmup", (Throwable)e);
        }
        Jvm.resetExceptionHandlers();
    }

    private static void warmup0(long mapAlignment, int chunks, @NotNull MappedFile mappedFile) throws IOException {
        for (int i = 0; i < chunks; ++i) {
            mappedFile.acquireBytesForRead((long)i * mapAlignment).release();
            mappedFile.acquireBytesForWrite((long)i * mapAlignment).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MappedFile withSizes(long chunkSize, long overlapSize) {
        chunkSize = OS.mapAlign((long)chunkSize);
        overlapSize = OS.mapAlign((long)overlapSize);
        if (chunkSize == this.chunkSize && overlapSize == this.overlapSize) {
            return this;
        }
        try {
            MappedFile mappedFile = new MappedFile(this.file, this.raf, chunkSize, overlapSize, this.capacity, this.readOnly);
            return mappedFile;
        }
        finally {
            this.release();
        }
    }

    @NotNull
    public File file() {
        return this.file;
    }

    @Nullable
    public MappedBytesStore acquireByteStore(long position) throws IOException, IllegalArgumentException, IllegalStateException {
        return this.acquireByteStore(position, this.readOnly ? ReadOnlyMappedBytesStore::new : MappedBytesStore::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends MappedBytesStore> T acquireByteStore(long position, @NotNull MappedBytesStoreFactory<T> mappedBytesStoreFactory) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.closed.get()) {
            throw new IOException("Closed");
        }
        if (position < 0L) {
            throw new IOException("Attempt to access a negative position: " + position);
        }
        int chunk = (int)(position / this.chunkSize);
        List<WeakReference<MappedBytesStore>> list = this.stores;
        synchronized (list) {
            MappedBytesStore mbs;
            while (this.stores.size() <= chunk) {
                this.stores.add(null);
            }
            WeakReference<MappedBytesStore> mbsRef = this.stores.get(chunk);
            if (mbsRef != null && (mbs = (MappedBytesStore)mbsRef.get()) != null && mbs.tryReserve()) {
                return (T)mbs;
            }
            long start = System.nanoTime();
            long minSize = ((long)chunk + 1L) * this.chunkSize + this.overlapSize;
            long size = this.fileChannel.size();
            if (size < minSize && !this.readOnly) {
                try {
                    Object object = GLOBAL_FILE_LOCK;
                    synchronized (object) {
                        size = this.fileChannel.size();
                        if (size < minSize) {
                            try (FileLock ignore = this.fileChannel.lock();){
                                size = this.fileChannel.size();
                                if (size < minSize) {
                                    this.raf.setLength(minSize);
                                }
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new IOException("Failed to resize to " + minSize, ioe);
                }
            }
            long mappedSize = this.chunkSize + this.overlapSize;
            FileChannel.MapMode mode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            long address = 0L;
            try {
                address = OS.map((FileChannel)this.fileChannel, (FileChannel.MapMode)mode, (long)((long)chunk * this.chunkSize), (long)mappedSize);
            }
            catch (IOException e) {
                if (this.readOnly && e.getMessage().equals("Not enough storage is available to process this command")) {
                    Jvm.warn().on(this.getClass(), "Mapping " + this.file + " as READ_ONLY failed, switching to READ_WRITE");
                    address = OS.map((FileChannel)this.fileChannel, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)((long)chunk * this.chunkSize), (long)mappedSize);
                    this.readOnly = false;
                }
                throw e;
            }
            long safeCapacity = this.chunkSize + this.overlapSize / 2L;
            T mbs2 = mappedBytesStoreFactory.create(this, (long)chunk * this.chunkSize, address, mappedSize, safeCapacity);
            this.stores.set(chunk, new WeakReference<T>(mbs2));
            ((NativeBytesStore)mbs2).reserve();
            if (this.newChunkListener != null) {
                this.newChunkListener.onNewChunk(this.file.getPath(), chunk, (System.nanoTime() - start) / 1000L);
            }
            return mbs2;
        }
    }

    @NotNull
    public Bytes acquireBytesForRead(long position) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        Bytes bytes = mbs.bytesForRead();
        bytes.readPositionUnlimited(position);
        mbs.release();
        return bytes;
    }

    public void acquireBytesForRead(long position, @NotNull VanillaBytes bytes) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
    }

    @NotNull
    public Bytes acquireBytesForWrite(long position) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        Bytes bytes = mbs.bytesForWrite();
        bytes.writePosition(position);
        mbs.release();
        return bytes;
    }

    public void acquireBytesForWrite(long position, @NotNull VanillaBytes bytes) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
        bytes.writePosition(position);
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    private void performRelease() {
        for (int i = 0; i < this.stores.size(); ++i) {
            long count;
            WeakReference<MappedBytesStore> storeRef = this.stores.get(i);
            if (storeRef == null) continue;
            MappedBytesStore mbs = (MappedBytesStore)storeRef.get();
            if (mbs != null && (count = mbs.refCount()) > 0L) {
                try {
                    mbs.release();
                }
                catch (IllegalStateException e) {
                    Jvm.debug().on(this.getClass(), (Throwable)e);
                }
                if (count > 1L) continue;
            }
            this.stores.set(i, null);
        }
        try {
            this.raf.close();
            this.closed.set(true);
        }
        catch (IOException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
    }

    @NotNull
    public String referenceCounts() {
        StringBuilder sb = new StringBuilder();
        sb.append("refCount: ").append(this.refCount());
        for (WeakReference<MappedBytesStore> store : this.stores) {
            MappedBytesStore mbs;
            long count = 0L;
            if (store != null && (mbs = (MappedBytesStore)store.get()) != null) {
                count = mbs.refCount();
            }
            sb.append(", ").append(count);
        }
        return sb.toString();
    }

    public long capacity() {
        return this.capacity;
    }

    public long chunkSize() {
        return this.chunkSize;
    }

    public long overlapSize() {
        return this.overlapSize;
    }

    public NewChunkListener getNewChunkListener() {
        return this.newChunkListener;
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.newChunkListener = listener;
    }

    public long actualSize() throws IORuntimeException {
        try {
            return this.fileChannel.size();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

