/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.core.service;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;
import org.nuxeo.ecm.platform.userworkspace.core.service.UserWorkspaceServiceImplComponent;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUserWorkspaceImpl
implements UserWorkspaceService {
    private static final Log log = LogFactory.getLog(DefaultUserWorkspaceServiceImpl.class);
    private static final long serialVersionUID = 1L;
    protected static final char ESCAPE_CHAR = '~';
    protected static final String ESCAPED_CHARS = "~/\\?&;@";
    protected volatile String targetDomainName;
    protected final int maxsize = ((PathSegmentService)Framework.getService(PathSegmentService.class)).getMaxSize();

    protected String getDomainName(CoreSession userCoreSession) {
        if (this.targetDomainName == null) {
            CoreInstance.doPrivileged((CoreSession)userCoreSession, session -> {
                String targetName = this.getComponent().getTargetDomainName();
                PathRef ref = new PathRef("/" + targetName);
                if (session.exists((DocumentRef)ref)) {
                    this.targetDomainName = targetName;
                    return;
                }
                DocumentModelList domains = session.query("select * from Domain order by dc:created");
                if (!domains.isEmpty()) {
                    this.targetDomainName = ((DocumentModel)domains.get(0)).getName();
                }
            });
        }
        return this.targetDomainName;
    }

    protected String getUserName(Principal principal, String username) {
        if (principal instanceof NuxeoPrincipal) {
            username = ((NuxeoPrincipal)principal).getActingUser();
        } else if (username == null) {
            username = principal.getName();
        }
        if (NuxeoPrincipal.isTransientUsername((String)username)) {
            username = null;
        }
        if (StringUtils.isEmpty((String)username)) {
            username = null;
        }
        return username;
    }

    public List<String> getCandidateUserWorkspaceNames(String username) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.escape(username));
        this.generateCandidates(names, username, this.maxsize);
        this.generateCandidates(names, username, 30);
        return names;
    }

    protected String escape(String string) {
        StringBuilder buf = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (ESCAPED_CHARS.indexOf(c) == -1) {
                buf.append(c);
                continue;
            }
            buf.append('~');
            if (c < '\u0010') {
                buf.append('0');
            }
            buf.append(Integer.toHexString(c));
        }
        return buf.length() == string.length() ? string : buf.toString();
    }

    protected void generateCandidates(List<String> names, String username, int max) {
        String digested;
        String name = IdUtils.generateId((String)username, (String)"-", (boolean)false, (int)max);
        if (!names.contains(name)) {
            names.add(name);
        }
        if (name.length() == max && !names.contains(digested = name.substring(0, name.length() - 8) + this.digest(username, 8))) {
            names.add(digested);
        }
    }

    protected String digest(String username, int maxsize) {
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.update(username.getBytes());
            return new String(Hex.encodeHex((byte[])crypt.digest())).substring(0, maxsize);
        }
        catch (NoSuchAlgorithmException cause) {
            throw new NuxeoException("Cannot digest " + username, (Throwable)cause);
        }
    }

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, String usedUsername) {
        String domainName = this.getDomainName(userCoreSession);
        if (domainName == null) {
            return null;
        }
        return new Path("/" + domainName).append("UserWorkspaces").toString();
    }

    public DocumentModel getCurrentUserPersonalWorkspace(String userName, DocumentModel currentDocument) {
        return this.getCurrentUserPersonalWorkspace(null, userName, currentDocument.getCoreSession());
    }

    public DocumentModel getCurrentUserPersonalWorkspace(CoreSession userCoreSession) {
        return this.getCurrentUserPersonalWorkspace(userCoreSession.getPrincipal(), null, userCoreSession);
    }

    public DocumentModel getCurrentUserPersonalWorkspace(CoreSession userCoreSession, DocumentModel context) {
        return this.getCurrentUserPersonalWorkspace(userCoreSession);
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(Principal principal, String userName, CoreSession userCoreSession) {
        String usedUsername = this.getUserName(principal, userName);
        if (usedUsername == null) {
            return null;
        }
        PathRef rootref = this.getExistingUserWorkspaceRoot(userCoreSession, usedUsername);
        if (rootref == null) {
            return null;
        }
        PathRef uwref = this.getExistingUserWorkspace(userCoreSession, rootref, principal, usedUsername);
        DocumentModel uw = userCoreSession.getDocument((DocumentRef)uwref);
        return uw;
    }

    protected PathRef getExistingUserWorkspaceRoot(CoreSession session, String username) {
        String uwrPath = this.computePathUserWorkspaceRoot(session, username);
        if (uwrPath == null) {
            return null;
        }
        PathRef rootref = new PathRef(uwrPath);
        if (session.exists((DocumentRef)rootref)) {
            return rootref;
        }
        String path = (String)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel uwsRootModel = this.doCreateUserWorkspacesRoot(session, rootref);
            DocumentModel docModel = s.getOrCreateDocument(uwsRootModel, doc -> this.initCreateUserWorkspacesRoot((CoreSession)s, (DocumentModel)doc));
            return docModel.getPathAsString();
        });
        return new PathRef(path);
    }

    protected PathRef getExistingUserWorkspace(CoreSession session, PathRef rootref, Principal principal, String username) {
        PathRef freeRef = null;
        for (String name : this.getCandidateUserWorkspaceNames(username)) {
            PathRef ref = new PathRef(rootref, name);
            if (session.exists((DocumentRef)ref) && session.hasPermission(session.getPrincipal(), (DocumentRef)ref, "Everything")) {
                return ref;
            }
            boolean exists = (Boolean)CoreInstance.doPrivileged((CoreSession)session, s -> s.exists((DocumentRef)ref));
            if (exists || freeRef != null) continue;
            freeRef = ref;
        }
        if (freeRef != null) {
            PathRef ref = freeRef;
            String path = (String)CoreInstance.doPrivileged((CoreSession)session, s -> {
                DocumentModel uwsModel = this.doCreateUserWorkspace(session, ref, username);
                return s.getOrCreateDocument(uwsModel, doc -> this.initCreateUserWorkspace((CoreSession)s, (DocumentModel)doc, username)).getPathAsString();
            });
            return new PathRef(path);
        }
        throw new DocumentSecurityException(username);
    }

    public DocumentModel getUserPersonalWorkspace(NuxeoPrincipal principal, DocumentModel context) {
        return this.getCurrentUserPersonalWorkspace((Principal)principal, null, context.getCoreSession());
    }

    public DocumentModel getUserPersonalWorkspace(String userName, DocumentModel context) {
        UnrestrictedUserWorkspaceFinder finder = new UnrestrictedUserWorkspaceFinder(userName, context);
        finder.runUnrestricted();
        return finder.getDetachedUserWorkspace();
    }

    public boolean isUnderUserWorkspace(Principal principal, String username, DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        if ((username = this.getUserName(principal, username)) == null) {
            return false;
        }
        Path path = doc.getPath();
        if (path.segmentCount() < 2) {
            return false;
        }
        String domainName = this.getDomainName(doc.getCoreSession());
        if (!domainName.equals(path.segment(0))) {
            return false;
        }
        if (!"UserWorkspaces".equals(path.segment(1))) {
            return false;
        }
        if (!this.getCandidateUserWorkspaceNames(username).contains(path.segment(2))) {
            return false;
        }
        DocumentModel uws = this.getCurrentUserPersonalWorkspace(principal, username, doc.getCoreSession());
        return uws.getPath().isPrefixOf(doc.getPath());
    }

    protected String buildUserWorkspaceTitle(String userName) {
        String lastName;
        if (userName == null) {
            return null;
        }
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (userManager == null) {
            return userName;
        }
        DocumentModel userModel = userManager.getUserModel(userName);
        if (userModel == null) {
            return userName;
        }
        UserAdapter userAdapter = null;
        userAdapter = (UserAdapter)userModel.getAdapter(UserAdapter.class);
        if (userAdapter == null) {
            return userName;
        }
        StringBuilder title = new StringBuilder();
        String firstName = userAdapter.getFirstName();
        if (firstName != null && firstName.trim().length() > 0) {
            title.append(firstName);
        }
        if ((lastName = userAdapter.getLastName()) != null && lastName.trim().length() > 0) {
            if (title.length() > 0) {
                title.append(" ");
            }
            title.append(lastName);
        }
        if (title.length() > 0) {
            return title.toString();
        }
        return userName;
    }

    protected void notifyEvent(CoreSession coreSession, DocumentModel document, NuxeoPrincipal principal, String eventId, Map<String, Serializable> properties) {
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        EventContextImpl eventContext = null;
        if (document != null) {
            properties.put("repositoryName", (Serializable)((Object)document.getRepositoryName()));
            properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
            properties.put("documentLifeCycle", (Serializable)((Object)document.getCurrentLifeCycleState()));
            eventContext = new DocumentEventContext(coreSession, (Principal)principal, document);
        } else {
            eventContext = new EventContextImpl(coreSession, (Principal)principal);
        }
        eventContext.setProperties(properties);
        Event event = eventContext.newEvent(eventId);
        ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
    }

    protected UserWorkspaceServiceImplComponent getComponent() {
        return (UserWorkspaceServiceImplComponent)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.userworkspace.UserWorkspaceService"));
    }

    protected abstract DocumentModel doCreateUserWorkspacesRoot(CoreSession var1, PathRef var2);

    protected abstract DocumentModel initCreateUserWorkspacesRoot(CoreSession var1, DocumentModel var2);

    protected abstract DocumentModel doCreateUserWorkspace(CoreSession var1, PathRef var2, String var3);

    protected abstract DocumentModel initCreateUserWorkspace(CoreSession var1, DocumentModel var2, String var3);

    public void invalidate() {
        this.targetDomainName = null;
    }

    protected class UnrestrictedUserWorkspaceFinder
    extends UnrestrictedSessionRunner {
        protected DocumentModel userWorkspace;
        protected String userName;

        protected UnrestrictedUserWorkspaceFinder(String userName, DocumentModel context) {
            super(context.getCoreSession().getRepositoryName(), userName);
            this.userName = userName;
        }

        public void run() {
            this.userWorkspace = AbstractUserWorkspaceImpl.this.getCurrentUserPersonalWorkspace(null, this.userName, this.session);
            if (this.userWorkspace != null) {
                this.userWorkspace.detach(true);
            }
        }

        public DocumentModel getDetachedUserWorkspace() {
            return this.userWorkspace;
        }
    }
}

