/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.ChronicleReaderMain;
import net.openhft.chronicle.queue.reader.ChronicleHistoryReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class ChronicleHistoryReaderMain {
    public static void main(@NotNull String[] args) throws IOException {
        new ChronicleHistoryReaderMain().run(args);
    }

    protected void run(String[] args) throws IOException {
        Options options = this.options();
        CommandLine commandLine = this.parseCommandLine(args, options);
        ChronicleHistoryReader chronicleHistoryReader = this.chronicleHistoryReader();
        this.setup(commandLine, chronicleHistoryReader);
        chronicleHistoryReader.execute();
    }

    protected void setup(CommandLine commandLine, ChronicleHistoryReader chronicleHistoryReader) throws IOException {
        chronicleHistoryReader.withMessageSink(System.out::println).withProgress(commandLine.hasOption('p')).withHistosByMethod(commandLine.hasOption('m')).withBasePath(Paths.get(commandLine.getOptionValue('d'), new String[0]));
        if (commandLine.hasOption('t')) {
            chronicleHistoryReader.withTimeUnit(TimeUnit.valueOf(commandLine.getOptionValue('t')));
        }
    }

    @NotNull
    protected ChronicleHistoryReader chronicleHistoryReader() {
        return new ChronicleHistoryReader();
    }

    protected CommandLine parseCommandLine(@NotNull String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                new HelpFormatter().printHelp(ChronicleHistoryReaderMain.class.getSimpleName(), options);
                System.exit(0);
            }
        }
        catch (ParseException e) {
            this.printUsageAndExit(options);
        }
        return commandLine;
    }

    protected void printUsageAndExit(Options options) {
        PrintWriter writer = new PrintWriter(System.out);
        new HelpFormatter().printUsage(writer, 180, ChronicleHistoryReaderMain.class.getSimpleName(), options);
        writer.flush();
        System.exit(1);
    }

    @NotNull
    protected Options options() {
        Options options = new Options();
        ChronicleReaderMain.addOption(options, "d", "directory", true, "Directory containing chronicle queue files", true);
        ChronicleReaderMain.addOption(options, "h", "help-message", false, "Print this help and exit", false);
        ChronicleReaderMain.addOption(options, "t", "time unit", true, "Time unit. Default nanos", false);
        options.addOption(new Option("p", false, "Show progress"));
        options.addOption(new Option("m", false, "By method"));
        return options;
    }
}

