/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.novemberain.quartz.mongodb.JobCompleteHandler;
import com.novemberain.quartz.mongodb.JobConverter;
import com.novemberain.quartz.mongodb.JobDataConverter;
import com.novemberain.quartz.mongodb.LockManager;
import com.novemberain.quartz.mongodb.MongoDBJobStore;
import com.novemberain.quartz.mongodb.TriggerAndJobPersister;
import com.novemberain.quartz.mongodb.TriggerRunner;
import com.novemberain.quartz.mongodb.TriggerStateManager;
import com.novemberain.quartz.mongodb.cluster.CheckinExecutor;
import com.novemberain.quartz.mongodb.cluster.CheckinTask;
import com.novemberain.quartz.mongodb.cluster.RecoveryTriggerFactory;
import com.novemberain.quartz.mongodb.cluster.TriggerRecoverer;
import com.novemberain.quartz.mongodb.dao.CalendarDao;
import com.novemberain.quartz.mongodb.dao.JobDao;
import com.novemberain.quartz.mongodb.dao.LocksDao;
import com.novemberain.quartz.mongodb.dao.PausedJobGroupsDao;
import com.novemberain.quartz.mongodb.dao.PausedTriggerGroupsDao;
import com.novemberain.quartz.mongodb.dao.SchedulerDao;
import com.novemberain.quartz.mongodb.dao.TriggerDao;
import com.novemberain.quartz.mongodb.db.MongoConnector;
import com.novemberain.quartz.mongodb.trigger.MisfireHandler;
import com.novemberain.quartz.mongodb.trigger.TriggerConverter;
import com.novemberain.quartz.mongodb.util.Clock;
import com.novemberain.quartz.mongodb.util.ExpiryCalculator;
import com.novemberain.quartz.mongodb.util.QueryHelper;
import org.bson.Document;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;

public class MongoStoreAssembler {
    public MongoConnector mongoConnector;
    public JobCompleteHandler jobCompleteHandler;
    public LockManager lockManager;
    public TriggerStateManager triggerStateManager;
    public TriggerRunner triggerRunner;
    public TriggerAndJobPersister persister;
    public CalendarDao calendarDao;
    public JobDao jobDao;
    public LocksDao locksDao;
    public SchedulerDao schedulerDao;
    public PausedJobGroupsDao pausedJobGroupsDao;
    public PausedTriggerGroupsDao pausedTriggerGroupsDao;
    public TriggerDao triggerDao;
    public TriggerRecoverer triggerRecoverer;
    public CheckinExecutor checkinExecutor;
    private MongoDatabase db;
    private QueryHelper queryHelper = new QueryHelper();
    private TriggerConverter triggerConverter;

    public void build(MongoDBJobStore jobStore, ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.mongoConnector = this.createMongoConnector(jobStore);
        this.db = this.mongoConnector.selectDatabase(jobStore.dbName);
        JobDataConverter jobDataConverter = new JobDataConverter(jobStore.isJobDataAsBase64());
        this.jobDao = this.createJobDao(jobStore, loadHelper, jobDataConverter);
        this.triggerConverter = new TriggerConverter(this.jobDao, jobDataConverter);
        this.triggerDao = this.createTriggerDao(jobStore);
        this.calendarDao = this.createCalendarDao(jobStore);
        this.locksDao = this.createLocksDao(jobStore);
        this.pausedJobGroupsDao = this.createPausedJobGroupsDao(jobStore);
        this.pausedTriggerGroupsDao = this.createPausedTriggerGroupsDao(jobStore);
        this.schedulerDao = this.createSchedulerDao(jobStore);
        this.persister = this.createTriggerAndJobPersister();
        this.jobCompleteHandler = this.createJobCompleteHandler(signaler);
        this.lockManager = this.createLockManager(jobStore);
        this.triggerStateManager = this.createTriggerStateManager();
        MisfireHandler misfireHandler = this.createMisfireHandler(jobStore, signaler);
        RecoveryTriggerFactory recoveryTriggerFactory = new RecoveryTriggerFactory(jobStore.instanceId);
        this.triggerRecoverer = new TriggerRecoverer(this.locksDao, this.persister, this.lockManager, this.triggerDao, this.jobDao, recoveryTriggerFactory, misfireHandler);
        this.triggerRunner = this.createTriggerRunner(misfireHandler);
        this.checkinExecutor = this.createCheckinExecutor(jobStore);
    }

    private CheckinExecutor createCheckinExecutor(MongoDBJobStore jobStore) {
        return new CheckinExecutor(new CheckinTask(this.schedulerDao), jobStore.clusterCheckinIntervalMillis, jobStore.instanceId);
    }

    private CalendarDao createCalendarDao(MongoDBJobStore jobStore) {
        return new CalendarDao(this.getCollection(jobStore, "calendars"));
    }

    private JobDao createJobDao(MongoDBJobStore jobStore, ClassLoadHelper loadHelper, JobDataConverter jobDataConverter) {
        JobConverter jobConverter = new JobConverter(jobStore.getClassLoaderHelper(loadHelper), jobDataConverter);
        return new JobDao(this.getCollection(jobStore, "jobs"), this.queryHelper, jobConverter);
    }

    private JobCompleteHandler createJobCompleteHandler(SchedulerSignaler signaler) {
        return new JobCompleteHandler(this.persister, signaler, this.jobDao, this.locksDao, this.triggerDao);
    }

    private LocksDao createLocksDao(MongoDBJobStore jobStore) {
        return new LocksDao(this.getCollection(jobStore, "locks"), Clock.SYSTEM_CLOCK, jobStore.instanceId);
    }

    private LockManager createLockManager(MongoDBJobStore jobStore) {
        ExpiryCalculator expiryCalculator = new ExpiryCalculator(this.schedulerDao, Clock.SYSTEM_CLOCK, jobStore.jobTimeoutMillis, jobStore.triggerTimeoutMillis);
        return new LockManager(this.locksDao, expiryCalculator);
    }

    private MisfireHandler createMisfireHandler(MongoDBJobStore jobStore, SchedulerSignaler signaler) {
        return new MisfireHandler(this.calendarDao, signaler, jobStore.misfireThreshold);
    }

    private MongoConnector createMongoConnector(MongoDBJobStore jobStore) throws SchedulerConfigException {
        return MongoConnector.builder().withClient(jobStore.mongo).withUri(jobStore.mongoUri).withCredentials(jobStore.username, jobStore.password).withAddresses(jobStore.addresses).withDatabaseName(jobStore.dbName).withAuthDatabaseName(jobStore.authDbName).withMaxConnectionsPerHost(jobStore.mongoOptionMaxConnectionsPerHost).withConnectTimeoutMillis(jobStore.mongoOptionConnectTimeoutMillis).withSocketTimeoutMillis(jobStore.mongoOptionSocketTimeoutMillis).withSocketKeepAlive(jobStore.mongoOptionSocketKeepAlive).withThreadsAllowedToBlockForConnectionMultiplier(jobStore.mongoOptionThreadsAllowedToBlockForConnectionMultiplier).withSSL(jobStore.mongoOptionEnableSSL, jobStore.mongoOptionSslInvalidHostNameAllowed).withWriteTimeout(jobStore.mongoOptionWriteConcernTimeoutMillis).build();
    }

    private PausedJobGroupsDao createPausedJobGroupsDao(MongoDBJobStore jobStore) {
        return new PausedJobGroupsDao(this.getCollection(jobStore, "paused_job_groups"));
    }

    private PausedTriggerGroupsDao createPausedTriggerGroupsDao(MongoDBJobStore jobStore) {
        return new PausedTriggerGroupsDao(this.getCollection(jobStore, "paused_trigger_groups"));
    }

    private SchedulerDao createSchedulerDao(MongoDBJobStore jobStore) {
        return new SchedulerDao(this.getCollection(jobStore, "schedulers"), jobStore.schedulerName, jobStore.instanceId, jobStore.clusterCheckinIntervalMillis, Clock.SYSTEM_CLOCK);
    }

    private TriggerAndJobPersister createTriggerAndJobPersister() {
        return new TriggerAndJobPersister(this.triggerDao, this.jobDao, this.triggerConverter);
    }

    private TriggerDao createTriggerDao(MongoDBJobStore jobStore) {
        return new TriggerDao(this.getCollection(jobStore, "triggers"), this.queryHelper, this.triggerConverter);
    }

    private TriggerRunner createTriggerRunner(MisfireHandler misfireHandler) {
        return new TriggerRunner(this.persister, this.triggerDao, this.jobDao, this.locksDao, this.calendarDao, misfireHandler, this.triggerConverter, this.lockManager, this.triggerRecoverer);
    }

    private TriggerStateManager createTriggerStateManager() {
        return new TriggerStateManager(this.triggerDao, this.jobDao, this.pausedJobGroupsDao, this.pausedTriggerGroupsDao, this.queryHelper);
    }

    private MongoCollection<Document> getCollection(MongoDBJobStore jobStore, String name) {
        return this.db.getCollection(jobStore.collectionPrefix + name);
    }
}

